/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.source.SourceUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class EngineUtil
implements CONST_IMPL {
    private EngineUtil() {
    }

    public static String getEngineSetting(String name, String defaultValue) {
        Engine engine = ProviderUtil.getEngine();
        String value = engine.getParameter(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getEngineSettingBoolean(String name, boolean defaultValue) {
        Engine engine = ProviderUtil.getEngine();
        String value = engine.getParameter(name);
        return ObjectUtil.booleanValue(value, defaultValue);
    }

    public static String getSourcePath() {
        Specification spec = SpecificationUtil.findSpecification();
        if (spec == null) {
            String path = CycleUtil.getServiceCycle().getRequestScope().getRequestedPath();
            SourceDescriptor source = SourceUtil.getSourceDescriptor(path);
            return source.getSystemID();
        }
        return spec.getSystemID();
    }

    public static String getSourcePath(ProcessorTreeWalker proc) {
        for (ProcessorTreeWalker current = proc; current != null; current = current.getParentProcessor()) {
            if (!(current instanceof Template)) continue;
            return ((Template)current).getSystemID();
        }
        throw new IllegalStateException("unknown sourcePath from processor");
    }

    public static String getSourcePath(NodeTreeWalker node) {
        return node.getSystemID();
    }

    public static Template getTemplate() {
        Specification spec = SpecificationUtil.findSpecification();
        if (spec instanceof Page) {
            NodeTreeWalker parent = spec.getParentNode();
            if (parent != null) {
                spec = SpecificationUtil.findSpecification();
            } else {
                return null;
            }
        }
        if (spec instanceof Template) {
            return (Template)spec;
        }
        throw new IllegalStateException("template not found");
    }

    public static Template getTemplate(ProcessorTreeWalker proc) {
        for (ProcessorTreeWalker current = proc; current != null; current = current.getParentProcessor()) {
            if (!(current instanceof Template)) continue;
            return (Template)current;
        }
        throw new IllegalStateException("template not found from current processor");
    }

    public static Specification getParentSpecification(Specification spec) {
        if (spec instanceof Page) {
            return ProviderUtil.getEngine();
        }
        if (spec instanceof Template) {
            return ((Template)spec).getPage();
        }
        return null;
    }
}

