/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script.rhino;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.WrappedException;
import org.seasar.mayaa.impl.cycle.script.AbstractSourceCompiledScript;
import org.seasar.mayaa.impl.cycle.script.rhino.RhinoUtil;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class SourceCompiledScriptImpl
extends AbstractSourceCompiledScript {
    private static final long serialVersionUID = 970613841877330176L;
    private Script _rhinoScript;
    private Date _compiledTimestamp = new Date();

    public SourceCompiledScriptImpl(SourceDescriptor source, String encoding) {
        super(source, encoding);
    }

    protected void compileFromSource(Context cx, SourceDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this._rhinoScript == null || source.getTimestamp().after(this._compiledTimestamp)) {
            if (!source.exists()) {
                throw new RuntimeException(new FileNotFoundException(source.getSystemID()));
            }
            InputStream stream = source.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(stream, this.getEncoding());
                this._rhinoScript = cx.compileReader((Reader)reader, source.getSystemID(), 1, null);
                this._compiledTimestamp = source.getTimestamp();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtil.close(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object[] args) {
        Context cx = RhinoUtil.enter();
        Object ret = null;
        try {
            this.compileFromSource(cx, this.getSource());
            Object jsRet = this._rhinoScript.exec(cx, RhinoUtil.getScope());
            ret = RhinoUtil.convertResult(cx, this.getExpectedClass(), jsRet);
        }
        catch (WrappedException e) {
            RhinoUtil.removeWrappedException(e);
        }
        finally {
            Context.exit();
        }
        return ret;
    }
}

