/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.scope;

import java.util.Iterator;
import java.util.Map;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.scope.AbstractReadOnlyAttributeScope;
import org.seasar.mayaa.impl.engine.processor.InsertProcessor;

public class BindingScope
extends AbstractReadOnlyAttributeScope {
    private static final long serialVersionUID = 5954219830862345209L;
    private static AttributeScope _paramScope;

    protected ProcessorProperty getTargetAttribute(InsertProcessor processor, String name) {
        Iterator it = processor.getInformalProperties().iterator();
        while (it.hasNext()) {
            ProcessorProperty prop = (ProcessorProperty)it.next();
            if (!prop.getName().getQName().getLocalName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    private static AttributeScope getParamScope() {
        if (_paramScope == null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            _paramScope = cycle.getAttributeScope("param");
        }
        return _paramScope;
    }

    public String getScopeName() {
        return "binding";
    }

    public Iterator iterateAttributeNames() {
        InsertProcessor processor = InsertProcessor.getRenderingCurrent();
        if (processor != null) {
            return new BindingIterator(processor.getInformalProperties().iterator());
        }
        return BindingScope.getParamScope().iterateAttributeNames();
    }

    public boolean hasAttribute(String name) {
        InsertProcessor processor = InsertProcessor.getRenderingCurrent();
        if (processor != null) {
            return this.getTargetAttribute(processor, name) != null;
        }
        return BindingScope.getParamScope().hasAttribute(name);
    }

    public Object getAttribute(String name) {
        InsertProcessor processor = InsertProcessor.getRenderingCurrent();
        if (processor != null) {
            ProcessorProperty prop = this.getTargetAttribute(processor, name);
            if (prop != null) {
                Map binding = processor.getRenderingParameters();
                if (binding != null) {
                    return binding.get(name);
                }
                return prop.getValue().execute(null);
            }
            return null;
        }
        return BindingScope.getParamScope().getAttribute(name);
    }

    private class BindingIterator
    implements Iterator {
        private Iterator _it;

        protected BindingIterator(Iterator it) {
            if (it == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            ProcessorProperty prop = (ProcessorProperty)this._it.next();
            return prop.getName().getQName().getLocalName();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

