/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.jsp;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.cycle.scope.SessionScope;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.StandardScope;
import org.seasar.mayaa.impl.cycle.jsp.BodyContentImpl;
import org.seasar.mayaa.impl.cycle.jsp.ExpressionEvaluatorImpl;
import org.seasar.mayaa.impl.cycle.jsp.JspWriterImpl;
import org.seasar.mayaa.impl.cycle.jsp.VariableResolverImpl;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.IteratorEnumeration;

public class PageContextImpl
extends PageContext {
    private ServletConfig _config;

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new IllegalStateException();
    }

    public void release() {
        throw new IllegalStateException();
    }

    public JspWriter getOut() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        return new JspWriterImpl(response.getWriter());
    }

    public JspWriter popBody() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        return new JspWriterImpl(response.getWriter());
    }

    public BodyContent pushBody() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        return new BodyContentImpl(response.pushWriter());
    }

    public void forward(String relativeUrlPath) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.forward(relativeUrlPath);
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        this.include(relativeUrlPath, false);
    }

    protected String getContextRelativePath(ServletRequest request, String relativePath) {
        if (relativePath.startsWith("/") || !(request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = httpRequest.getServletPath();
        if (StringUtil.hasValue(uri)) {
            int pos = uri.lastIndexOf(47);
            if (pos >= 0) {
                uri = uri.substring(0, pos);
            }
        } else {
            uri = "";
        }
        return uri + '/' + relativePath;
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        if (flush) {
            Response response = CycleUtil.getResponse();
            response.getWriter().flush();
        }
        ServletRequest request = this.getRequest();
        String contextRelativePath = this.getContextRelativePath(request, relativeUrlPath);
        RequestDispatcher dispatcher = request.getRequestDispatcher(contextRelativePath);
        dispatcher.include(request, this.getResponse());
    }

    public void handlePageException(Exception e) {
        this.handlePageException((Throwable)e);
    }

    public void handlePageException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public Exception getException() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Throwable t = cycle.getHandledError();
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return null;
    }

    public ServletContext getServletContext() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        ApplicationScope application = cycle.getApplicationScope();
        Object obj = application.getUnderlyingContext();
        if (obj instanceof ServletContext) {
            return (ServletContext)obj;
        }
        throw new IllegalStateException();
    }

    public HttpSession getSession() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        SessionScope session = cycle.getSessionScope();
        Object obj = session.getUnderlyingContext();
        if (obj instanceof HttpSession) {
            return (HttpSession)obj;
        }
        return null;
    }

    public ServletRequest getRequest() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        RequestScope request = cycle.getRequestScope();
        Object obj = request.getUnderlyingContext();
        if (obj instanceof ServletRequest) {
            return (ServletRequest)obj;
        }
        throw new IllegalStateException();
    }

    public ServletResponse getResponse() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        Object obj = response.getUnderlyingContext();
        if (obj instanceof ServletResponse) {
            return (ServletResponse)obj;
        }
        throw new IllegalStateException();
    }

    public ServletConfig getServletConfig() {
        if (this._config == null) {
            this._config = new CycleServletConfig();
        }
        return this._config;
    }

    public Object getPage() {
        throw new UnsupportedOperationException();
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return ExpressionEvaluatorImpl.getInstance();
    }

    public VariableResolver getVariableResolver() {
        return VariableResolverImpl.getInstance();
    }

    private int toJspScope(String name) {
        if ("page".equals(name)) {
            return 1;
        }
        if ("request".equals(name)) {
            return 2;
        }
        if ("session".equals(name)) {
            return 3;
        }
        if ("application".equals(name)) {
            return 4;
        }
        return 0;
    }

    private String toServiceScope(int scope) {
        if (scope == 4) {
            return "application";
        }
        if (scope == 3) {
            return "session";
        }
        if (scope == 2) {
            return "request";
        }
        if (scope == 1) {
            return "page";
        }
        throw new IllegalArgumentException();
    }

    protected AttributeScope findAttributeScope(String name) {
        AttributeScope pageScope = CycleUtil.getServiceCycle().getPageScope();
        if (pageScope.hasAttribute(name)) {
            return pageScope;
        }
        AttributeScope scope = CycleUtil.findStandardAttributeScope(name);
        if (scope != null) {
            return scope;
        }
        return pageScope;
    }

    public Object findAttribute(String name) {
        return this.findAttributeScope(name).getAttribute(name);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope != 1) {
            String scopeName = this.toServiceScope(scope);
            return CycleUtil.getAttribute(name, scopeName);
        }
        return this.findAttributeScope(name).getAttribute(name);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope != 1) {
            String scopeName = this.toServiceScope(scope);
            CycleUtil.removeAttribute(name, scopeName);
        } else {
            this.findAttributeScope(name).removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope != 1) {
            String scopeName = this.toServiceScope(scope);
            CycleUtil.setAttribute(name, value, scopeName);
        } else {
            this.findAttributeScope(name).setAttribute(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 1);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        String scopeName = this.toServiceScope(scope);
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope attrScope = cycle.getAttributeScope(scopeName);
        return IteratorEnumeration.getInstance(attrScope.iterateAttributeNames());
    }

    public int getAttributesScope(String name) {
        StandardScope standardScope = CycleUtil.getStandardScope();
        int size = standardScope.size();
        for (int i = 0; i < size; ++i) {
            int scope;
            String scopeName = standardScope.get(i);
            Object ret = CycleUtil.getAttribute(name, scopeName);
            if (ret == null || (scope = this.toJspScope(scopeName)) <= 0) continue;
            return scope;
        }
        return 0;
    }

    private class CycleServletConfig
    implements ServletConfig {
        protected CycleServletConfig() {
        }

        public String getInitParameter(String name) {
            return this.getServletContext().getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this.getServletContext().getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.getServletContext();
        }

        public String getServletName() {
            return "Mayaa Servlet";
        }
    }
}

