/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle;

import org.mozilla.javascript.Scriptable;
import org.seasar.mayaa.FactoryFactory;
import org.seasar.mayaa.cycle.CycleFactory;
import org.seasar.mayaa.cycle.CycleLocalInstantiator;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.impl.cycle.CycleNotInitializedException;
import org.seasar.mayaa.impl.cycle.CycleThreadLocalFactory;
import org.seasar.mayaa.impl.cycle.StandardScope;
import org.seasar.mayaa.impl.cycle.scope.ScopeNotWritableException;
import org.seasar.mayaa.impl.cycle.script.rhino.PageAttributeScope;
import org.seasar.mayaa.impl.util.StringUtil;

public class CycleUtil {
    private static CycleUtil _singleton = new CycleUtil();
    private CycleFactory _factory;
    private static StandardScope _standardScope = new StandardScope();
    private static final String DRAFT_WRITING = "org.seasar.mayaa.cycle.DRAFT_WRITING";
    static /* synthetic */ Class class$org$seasar$mayaa$cycle$CycleFactory;

    private CycleUtil() {
    }

    public static boolean isInitialized() {
        return CycleUtil._singleton._factory != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CycleFactory getFactory() {
        if (CycleUtil._singleton._factory == null) {
            CycleUtil cycleUtil = _singleton;
            synchronized (cycleUtil) {
                if (CycleUtil._singleton._factory == null) {
                    CycleUtil._singleton._factory = (CycleFactory)FactoryFactory.getFactory(class$org$seasar$mayaa$cycle$CycleFactory == null ? (class$org$seasar$mayaa$cycle$CycleFactory = CycleUtil.class$("org.seasar.mayaa.cycle.CycleFactory")) : class$org$seasar$mayaa$cycle$CycleFactory);
                }
            }
        }
        return CycleUtil._singleton._factory;
    }

    public static void initialize(Object requestContext, Object responseContext) {
        CycleUtil.getFactory().initialize(requestContext, responseContext);
    }

    public static void cycleFinalize() {
        CycleUtil.getFactory().cycleFinalize();
    }

    public static void registVariableFactory(String key, CycleLocalInstantiator instantiator) {
        CycleThreadLocalFactory.registFactory(key, instantiator);
    }

    public static Object getGlobalVariable(String key, Object[] params) {
        return CycleUtil.getFactory().getLocalVariables().getGlobalVariable(key, params);
    }

    public static void setGlobalVariable(String key, Object value) {
        CycleUtil.getFactory().getLocalVariables().setGlobalVariable(key, value);
    }

    public static void clearGlobalVariable(String key) {
        CycleUtil.getFactory().getLocalVariables().clearGlobalVariable(key);
    }

    public static Object getLocalVariable(String key, Object owner, Object[] params) {
        return CycleUtil.getFactory().getLocalVariables().getVariable(key, owner, params);
    }

    public static void setLocalVariable(String key, Object owner, Object value) {
        CycleUtil.getFactory().getLocalVariables().setVariable(key, owner, value);
    }

    public static void clearLocalVariable(String key, Object owner) {
        CycleUtil.getFactory().getLocalVariables().clearVariable(key, owner);
    }

    public static ServiceCycle getServiceCycle() {
        if (CycleUtil.getFactory() == null) {
            throw new CycleNotInitializedException();
        }
        return CycleUtil.getFactory().getServiceCycle();
    }

    public static StandardScope getStandardScope() {
        return _standardScope;
    }

    public static void addStandardScope(String newScopeName) {
        _standardScope.addScope(newScopeName);
    }

    public static RequestScope getRequestScope() {
        return CycleUtil.getServiceCycle().getRequestScope();
    }

    public static Response getResponse() {
        return CycleUtil.getServiceCycle().getResponse();
    }

    public static AttributeScope findStandardAttributeScope(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        for (int i = 0; i < _standardScope.size(); ++i) {
            AttributeScope scope = cycle.getAttributeScope(_standardScope.get(i));
            if (scope == null) continue;
            if (scope instanceof PageAttributeScope) {
                scope = (AttributeScope)scope.getAttribute("__current__");
                while (scope != null) {
                    if (scope.hasAttribute(name)) {
                        return scope;
                    }
                    Scriptable parent = ((PageAttributeScope)scope).getParentScope();
                    if (parent instanceof AttributeScope) {
                        scope = (AttributeScope)parent;
                        continue;
                    }
                    scope = null;
                }
                continue;
            }
            if (!scope.hasAttribute(name)) continue;
            return scope;
        }
        return null;
    }

    public static Object getAttribute(String name, String scopeName) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getAttributeScope(scopeName);
        return scope.getAttribute(name);
    }

    public static void setAttribute(String name, Object value, String scopeName) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getAttributeScope(scopeName);
        if (!scope.isAttributeWritable()) {
            throw new ScopeNotWritableException(scopeName);
        }
        scope.setAttribute(name, value);
    }

    public static void removeAttribute(String name, String scopeName) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        AttributeScope scope = cycle.getAttributeScope(scopeName);
        if (!scope.isAttributeWritable()) {
            throw new ScopeNotWritableException(scopeName);
        }
        scope.removeAttribute(name);
    }

    public static boolean isDraftWriting() {
        return Boolean.TRUE.equals(CycleUtil.getAttribute(DRAFT_WRITING, "request"));
    }

    public static void beginDraftWriting() {
        CycleUtil.setAttribute(DRAFT_WRITING, Boolean.TRUE, "request");
    }

    public static void endDraftWriting() {
        CycleUtil.setAttribute(DRAFT_WRITING, Boolean.FALSE, "request");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

