/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import org.seasar.mayaa.cycle.CycleWriter;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.impl.cycle.CycleWriterImpl;
import org.seasar.mayaa.impl.util.StringUtil;

public abstract class AbstractResponse
implements Response {
    private String _encoding = "UTF-8";
    private Stack _stack = new Stack();
    private boolean _flushed;

    public AbstractResponse() {
        this._stack.push(new CycleWriterImpl(null));
    }

    private String parseCharacterEncoding(String contentType) {
        int eqPos;
        String lower;
        int startPos;
        if (StringUtil.hasValue(contentType) && (startPos = (lower = contentType.toLowerCase()).indexOf("charset")) > 0 && (eqPos = contentType.indexOf("=", startPos += 7)) > 0) {
            int endPos = contentType.indexOf(";", eqPos);
            if (endPos < 0) {
                endPos = contentType.length();
            }
            return contentType.substring(eqPos + 1, endPos).trim();
        }
        return "UTF-8";
    }

    protected abstract void setContentTypeToUnderlyingObject(String var1);

    public void setContentType(String contentType) {
        if (StringUtil.isEmpty(contentType)) {
            throw new IllegalArgumentException();
        }
        this._encoding = this.parseCharacterEncoding(contentType);
        this.setContentTypeToUnderlyingObject(contentType);
    }

    public CycleWriter getWriter() {
        return (CycleWriter)this._stack.peek();
    }

    public void clearBuffer() {
        this._stack.clear();
        this._stack.push(new CycleWriterImpl(null));
    }

    public CycleWriter pushWriter() {
        CycleWriterImpl writer = new CycleWriterImpl(this.getWriter());
        this._stack.push(writer);
        return writer;
    }

    public CycleWriter popWriter() {
        if (this._stack.size() > 1) {
            return (CycleWriter)this._stack.pop();
        }
        throw new IllegalStateException();
    }

    public void write(char[] cbuf) {
        if (cbuf != null) {
            this.write(cbuf, 0, cbuf.length);
        }
    }

    public void write(char[] cbuf, int off, int len) {
        try {
            this.getWriter().write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(int b) {
        try {
            this.getWriter().write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(String str) {
        if (str != null) {
            this.write(str, 0, str.length());
        }
    }

    public void write(String str, int off, int len) {
        try {
            this.getWriter().write(str, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getEncoding() {
        return this._encoding;
    }

    public void flush() {
        try {
            if (this._stack.size() == 1) {
                CycleWriter writer = (CycleWriter)this._stack.peek();
                OutputStreamWriter underlyingWriter = new OutputStreamWriter(this.getOutputStream(), this._encoding);
                writer.writeOut(underlyingWriter);
                ((Writer)underlyingWriter).flush();
            } else {
                this.getWriter().flush();
            }
            this._flushed = true;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isFlushed() {
        return this._flushed;
    }

    public abstract /* synthetic */ String encodeURL(String var1);

    public abstract /* synthetic */ OutputStream getOutputStream();

    public abstract /* synthetic */ void setHeader(String var1, String var2);

    public abstract /* synthetic */ void addHeader(String var1, String var2);

    public abstract /* synthetic */ void setStatus(int var1);

    public abstract /* synthetic */ Object getUnderlyingContext();

    public abstract /* synthetic */ void setUnderlyingContext(Object var1);
}

