/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.tld;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.impl.builder.library.TLDLibraryDefinition;
import org.seasar.mayaa.impl.builder.library.TLDProcessorDefinition;
import org.seasar.mayaa.impl.builder.library.tld.AttributeTagHandler;
import org.seasar.mayaa.impl.builder.library.tld.TaglibTagHandler;
import org.seasar.mayaa.impl.builder.library.tld.TeiTagHandler;
import org.seasar.mayaa.impl.engine.processor.JspProcessor;
import org.seasar.mayaa.impl.util.IllegalClassTypeException;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.xml.TagHandler;
import org.xml.sax.Attributes;

public class TagTagHandler
extends TagHandler {
    protected static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$tld$TagTagHandler == null ? (class$org$seasar$mayaa$impl$builder$library$tld$TagTagHandler = TagTagHandler.class$("org.seasar.mayaa.impl.builder.library.tld.TagTagHandler")) : class$org$seasar$mayaa$impl$builder$library$tld$TagTagHandler));
    private TaglibTagHandler _parent;
    private TLDProcessorDefinition _processor;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$tld$TagTagHandler;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$Tag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TagExtraInfo;

    public TagTagHandler(TaglibTagHandler parent) {
        super("tag");
        this._parent = parent;
        this.putHandler(new TeiTagHandler(this));
        this.putHandler(new AttributeTagHandler(this));
        this.putHandler(new TagHandler("name"){

            protected void end(String body) {
                TagTagHandler.this.setProcessorName(body);
            }
        });
        this.putHandler(new TagClassSetter("tag-class", this));
        this.putHandler(new TagClassSetter("tagclass", this));
        this.putHandler(new TeiClassSetter("tei-class", this));
        this.putHandler(new TeiClassSetter("teiclass", this));
        this.putHandler(new TagHandler("dynamic-attributes"){

            protected void end(String body) {
                try {
                    TagTagHandler.this.getProcessorDefinition().setDynamicAttribute(ObjectUtil.booleanValue(body, false));
                }
                catch (RuntimeException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    this.invalidate();
                }
            }
        });
    }

    protected void setProcessorName(String name) {
        this._processor.setName(name);
    }

    protected void setProcessorClass(Class clazz) {
        this._processor.setProcessorClass(clazz);
    }

    protected void setTeiClass(Class teiClass) {
        this._processor.setExtraInfoClass(teiClass);
    }

    protected void start(Attributes attributes, String systemID, int lineNumber) {
        this._processor = new TLDProcessorDefinition();
        this._processor.setSystemID(systemID);
        this._processor.setLineNumber(lineNumber);
    }

    protected void end(String body) {
        TLDLibraryDefinition library = this._parent.getLibraryDefinition();
        library.addProcessorDefinition(this._processor);
        this._processor.setLibraryDefinition(library);
        this._processor = null;
    }

    public TLDProcessorDefinition getProcessorDefinition() {
        if (this._processor == null) {
            throw new IllegalStateException();
        }
        return this._processor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TeiClassSetter
    extends TagHandler {
        private TagTagHandler _handler;

        protected TeiClassSetter(String name, TagTagHandler handler) {
            super(name);
            this._handler = handler;
        }

        protected void end(String body) {
            try {
                Class clazz = ObjectUtil.loadClass(body, class$javax$servlet$jsp$tagext$TagExtraInfo == null ? (class$javax$servlet$jsp$tagext$TagExtraInfo = TagTagHandler.class$("javax.servlet.jsp.tagext.TagExtraInfo")) : class$javax$servlet$jsp$tagext$TagExtraInfo);
                TagTagHandler.this.setTeiClass(clazz);
            }
            catch (RuntimeException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage());
                }
                this._handler.invalidate();
            }
        }
    }

    private class TagClassSetter
    extends TagHandler {
        private TagTagHandler _handler;

        protected TagClassSetter(String name, TagTagHandler handler) {
            super(name);
            this._handler = handler;
        }

        protected void end(String body) {
            try {
                Class tagClass = ObjectUtil.loadClass(body);
                if (!JspProcessor.isSupportClass(tagClass)) {
                    throw new IllegalClassTypeException(class$javax$servlet$jsp$tagext$Tag == null ? (class$javax$servlet$jsp$tagext$Tag = TagTagHandler.class$("javax.servlet.jsp.tagext.Tag")) : class$javax$servlet$jsp$tagext$Tag, tagClass);
                }
                TagTagHandler.this.setProcessorClass(tagClass);
            }
            catch (RuntimeException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                this._handler.invalidate();
            }
        }
    }
}

