/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.scanner;

import java.io.InputStream;
import java.util.Iterator;
import org.seasar.mayaa.FactoryFactory;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.scanner.SourceAlias;
import org.seasar.mayaa.impl.builder.library.scanner.TaglibLocationsHandler;
import org.seasar.mayaa.impl.source.ApplicationSourceDescriptor;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.XMLUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class WebXMLTaglibSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private static final long serialVersionUID = -4740935373481152275L;
    public static final String ASSIGNED = (class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner == null ? (class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner = WebXMLTaglibSourceScanner.class$("org.seasar.mayaa.impl.builder.library.scanner.WebXMLTaglibSourceScanner")) : class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner) + ".ASSIGNED";
    public static final String REAL_PATH = (class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner == null ? (class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner = WebXMLTaglibSourceScanner.class$("org.seasar.mayaa.impl.builder.library.scanner.WebXMLTaglibSourceScanner")) : class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner) + ".REAL_PATH";
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$scanner$WebXMLTaglibSourceScanner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator scanWebXml(SourceDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (!source.exists()) {
            throw new IllegalStateException();
        }
        InputStream stream = source.getInputStream();
        try {
            TaglibLocationsHandler handler = new TaglibLocationsHandler();
            XMLUtil.parse(handler, stream, "web.xml", source.getSystemID(), true, true, true);
            Iterator iterator = handler.iterateTaglibLocations();
            return iterator;
        }
        finally {
            IOUtil.close(stream);
        }
    }

    public Iterator scan() {
        SourceDescriptor source = FactoryFactory.getBootstrapSource("/WEB-INF", "web.xml");
        return new TaglibLocationIterator(this.scanWebXml(source));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TaglibLocationIterator
    implements Iterator {
        private Iterator _it;

        protected TaglibLocationIterator(Iterator it) {
            if (it == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            SourceAlias alias = (SourceAlias)this._it.next();
            String systemID = alias.getSystemID();
            if (systemID.startsWith("/WEB-INF/")) {
                systemID = systemID.substring("/WEB-INF/".length());
            }
            ApplicationSourceDescriptor source = new ApplicationSourceDescriptor();
            if (!systemID.startsWith("/")) {
                source.setRoot("/WEB-INF");
            }
            source.setSystemID(systemID);
            source.setParameter(SourceAlias.ALIAS, alias.getAlias());
            source.setParameter(REAL_PATH, alias.getSystemID());
            source.setParameter(ASSIGNED, "true");
            return source;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

