/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.seasar.mayaa.builder.library.PropertyDefinition;
import org.seasar.mayaa.builder.library.PropertySet;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.builder.library.ProcessorDefinitionImpl;
import org.seasar.mayaa.impl.builder.library.TLDScriptingVariableInfo;
import org.seasar.mayaa.impl.engine.processor.JspProcessor;
import org.seasar.mayaa.impl.util.ObjectUtil;

public class TLDProcessorDefinition
extends ProcessorDefinitionImpl {
    private static final long serialVersionUID = -646585734601397162L;
    private Class _tagClass;
    private Class _teiClass;
    private boolean _dynamicAttribute;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TagExtraInfo;

    public void setProcessorClass(Class processorClass) {
        if (!JspProcessor.isSupportClass(processorClass)) {
            throw new IllegalArgumentException();
        }
        this._tagClass = processorClass;
    }

    public Class getProcessorClass() {
        if (this._tagClass == null) {
            throw new IllegalStateException();
        }
        return this._tagClass;
    }

    public void setExtraInfoClass(Class teiClass) {
        if (teiClass == null || !(class$javax$servlet$jsp$tagext$TagExtraInfo == null ? (class$javax$servlet$jsp$tagext$TagExtraInfo = TLDProcessorDefinition.class$("javax.servlet.jsp.tagext.TagExtraInfo")) : class$javax$servlet$jsp$tagext$TagExtraInfo).isAssignableFrom(teiClass)) {
            throw new IllegalArgumentException();
        }
        this._teiClass = teiClass;
    }

    public Class getExtraInfoClass() {
        return this._teiClass;
    }

    public boolean isDynamicAttribute() {
        return this._dynamicAttribute;
    }

    public void setDynamicAttribute(boolean dynamicAttribute) {
        this._dynamicAttribute = dynamicAttribute;
    }

    protected TemplateProcessor newInstance() {
        JspProcessor processor = new JspProcessor();
        processor.setTagClass(this.getProcessorClass());
        return processor;
    }

    protected void settingPropertySet(SpecificationNode original, SpecificationNode injected, TemplateProcessor processor, PropertySet propertySet) {
        Hashtable<String, Object> tagDataSeed = new Hashtable<String, Object>();
        Iterator it = propertySet.iteratePropertyDefinition();
        while (it.hasNext()) {
            PropertyDefinition property = (PropertyDefinition)it.next();
            Object prop = property.createProcessorProperty(this, original, injected);
            if (prop == null) continue;
            ProcessorProperty currentProp = (ProcessorProperty)prop;
            JspProcessor jsp = (JspProcessor)processor;
            jsp.addProcessorProperty(currentProp);
            CompiledScript value = currentProp.getValue();
            tagDataSeed.put(currentProp.getName().getQName().getLocalName(), this.prepareScript(value));
        }
        if (this.getExtraInfoClass() != null) {
            this.settingExtraInfo((JspProcessor)processor, tagDataSeed);
        }
    }

    private Object prepareScript(CompiledScript script) {
        if (script.isLiteral()) {
            return script.execute(null);
        }
        return script;
    }

    protected void settingExtraInfo(JspProcessor processor, Hashtable seed) {
        TagExtraInfo tei = (TagExtraInfo)ObjectUtil.newInstance(this.getExtraInfoClass());
        boolean hasNestedVariable = this.existsNestedVariable(tei, seed);
        boolean hasDynamicName = this.existsDynamicName(seed);
        TLDScriptingVariableInfo variableInfo = new TLDScriptingVariableInfo();
        variableInfo.setTagExtraInfo(tei);
        variableInfo.setNestedVariable(hasNestedVariable);
        variableInfo.setDynamicName(hasDynamicName);
        if (hasNestedVariable) {
            ScriptableTagData tagData = new ScriptableTagData(seed);
            if (hasDynamicName) {
                variableInfo.setTagData(tagData);
            } else {
                variableInfo.setVariableInfos(tei.getVariableInfo((TagData)tagData));
            }
        }
        processor.setTLDScriptingVariableInfo(variableInfo);
    }

    protected boolean existsNestedVariable(TagExtraInfo tei, Hashtable seed) {
        VariableInfo[] dummy = tei.getVariableInfo((TagData)new DummyTagData(seed));
        for (int i = 0; i < dummy.length; ++i) {
            if (dummy[i].getScope() != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean existsDynamicName(Hashtable seed) {
        Enumeration keys = seed.keys();
        while (keys.hasMoreElements()) {
            if (!(seed.get(keys.nextElement()) instanceof CompiledScript)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ScriptableTagData
    extends TagData {
        public ScriptableTagData(Hashtable seed) {
            super(seed);
        }

        public boolean isDynamicAttribute(String attName) {
            return super.getAttribute(attName) instanceof CompiledScript;
        }

        public Object getAttribute(String attName) {
            Object value = super.getAttribute(attName);
            if (value instanceof CompiledScript) {
                return ((CompiledScript)value).execute(null);
            }
            return value;
        }

        public String getAttributeString(String attName) {
            Object value = this.getAttribute(attName);
            if (value != null) {
                return String.valueOf(value);
            }
            return (String)value;
        }
    }

    protected static class DummyTagData
    extends TagData {
        public DummyTagData(Hashtable seed) {
            super(seed);
        }

        public Object getAttribute(String attName) {
            return attName;
        }

        public String getAttributeString(String attName) {
            return attName;
        }
    }
}

