/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.injection;

import org.seasar.mayaa.builder.injection.InjectionChain;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class DefaultInjectionChain
implements InjectionChain,
CONST_IMPL {
    private QName[] _specialNames = new QName[]{CONST_IMPL.QM_CDATA, CONST_IMPL.QM_CHARACTERS, CONST_IMPL.QM_COMMENT, CONST_IMPL.QM_DOCTYPE, CONST_IMPL.QM_PI};

    protected QName[] getSpecialNames() {
        return this._specialNames;
    }

    protected boolean isSpecialNode(QName qName) {
        QName[] specialNames = this.getSpecialNames();
        for (int i = 0; i < specialNames.length; ++i) {
            if (!specialNames[i].equals(qName)) continue;
            return true;
        }
        return false;
    }

    public SpecificationNode getNode(SpecificationNode original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        if (this.isSpecialNode(original.getQName())) {
            return original.copyTo();
        }
        QName qName = original.getQName();
        URI uri = qName.getNamespaceURI();
        SpecificationNode element = BuilderUtil.createInjectedNode(CONST_IMPL.QM_TEMPLATE_ELEMENT, uri, original, false);
        StringBuffer name = new StringBuffer();
        String prefix = original.getPrefix();
        if (StringUtil.hasValue(prefix)) {
            name.append(prefix).append(":");
        }
        name.append(qName.getLocalName());
        element.addAttribute(CONST_IMPL.QM_NAME, name.toString());
        return element;
    }
}

