/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder;

import java.util.Iterator;
import org.seasar.mayaa.builder.PathAdjuster;
import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.builder.library.LibraryManager;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.IllegalNameException;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class BuilderUtil
implements CONST_IMPL {
    private BuilderUtil() {
    }

    public static SpecificationNode createInjectedNode(QName qName, URI uri, SpecificationNode original, boolean mayaa) {
        if (qName == null || original == null) {
            throw new IllegalArgumentException();
        }
        String systemID = original.getSystemID();
        int lineNumber = original.getLineNumber();
        boolean onTemplate = original.isOnTemplate();
        int sequenceID = original.getSequenceID();
        SpecificationNode node = SpecificationUtil.createSpecificationNode(qName, systemID, lineNumber, onTemplate, sequenceID);
        if (StringUtil.hasValue(uri)) {
            PathAdjuster adjuster = ProviderUtil.getPathAdjuster();
            boolean needAdjust = adjuster.isTargetNode(original.getQName());
            String basePath = null;
            if (needAdjust) {
                String contextPath = CycleUtil.getRequestScope().getContextPath();
                String sourcePath = EngineUtil.getSourcePath(original);
                basePath = contextPath + sourcePath;
            }
            Iterator it = original.iterateAttribute();
            while (it.hasNext()) {
                NodeAttribute attr = (NodeAttribute)it.next();
                String attrValue = attr.getValue();
                if (needAdjust && adjuster.isTargetAttribute(original.getQName(), attr.getQName())) {
                    attrValue = adjuster.adjustRelativePath(basePath, attrValue);
                }
                String originalName = null;
                if (!StringUtil.isEmpty(attr.getPrefix()) && attr.getQName().getLocalName().indexOf(58) < 0) {
                    originalName = attr.getPrefix() + ":" + attr.getQName().getLocalName();
                }
                node.addAttribute(attr.getQName(), originalName, attrValue);
            }
            it = original.iteratePrefixMapping(false);
            while (it.hasNext()) {
                PrefixMapping prefixMapping = (PrefixMapping)it.next();
                node.addPrefixMapping(prefixMapping.getPrefix(), prefixMapping.getNamespaceURI());
            }
        }
        node.setParentSpace(original.getParentSpace());
        node.setDefaultNamespaceURI(original.getDefaultNamespaceURI());
        return node;
    }

    public static PrefixAwareName parseName(Namespace namespace, String qName) {
        String[] parsed = qName.split(":");
        String prefix = null;
        String localName = null;
        URI namespaceURI = null;
        PrefixMapping mapping = null;
        if (parsed.length == 2) {
            prefix = parsed[0];
            localName = parsed[1];
            mapping = namespace.getMappingFromPrefix(prefix, true);
            if (mapping == null) {
                if ("xml".equals(prefix)) {
                    mapping = SpecificationUtil.XML_DEFAULT_PREFIX_MAPPING;
                } else {
                    namespaceURI = CONST_IMPL.URI_HTML;
                    mapping = SpecificationUtil.HTML_DEFAULT_PREFIX_MAPPING;
                    localName = qName;
                    prefix = "";
                }
            }
            namespaceURI = mapping.getNamespaceURI();
        } else if (parsed.length == 1) {
            localName = parsed[0];
            namespaceURI = namespace.getDefaultNamespaceURI();
            if (namespaceURI == null) {
                mapping = namespace.getMappingFromPrefix("", true);
                if (mapping != null) {
                    namespaceURI = mapping.getNamespaceURI();
                } else {
                    namespaceURI = CONST_IMPL.URI_HTML;
                    mapping = SpecificationUtil.HTML_DEFAULT_PREFIX_MAPPING;
                }
            }
        } else {
            throw new IllegalNameException(qName);
        }
        prefix = mapping != null ? mapping.getPrefix() : "";
        PrefixAwareName ret = SpecificationUtil.createPrefixAwareName(SpecificationUtil.createQName(namespaceURI, localName), prefix);
        return ret;
    }

    static SpecificationNode nodeCopyOf(SpecificationNode node, QName newQName, SequenceIDGenerator sequenceIDGenerator) {
        if (newQName == null) {
            newQName = node.getQName();
        }
        return SpecificationUtil.createSpecificationNode(newQName, node.getSystemID(), node.getLineNumber(), true, sequenceIDGenerator.nextSequenceID());
    }

    public static void characterProcessorCopy(TemplateProcessor from, TemplateProcessorSupport to, SequenceIDGenerator idGenerator) {
        to.setOriginalNode(from.getOriginalNode());
        to.setInjectedNode(from.getInjectedNode());
        to.setEvalBodyInclude(false);
        LibraryManager libraryManager = ProviderUtil.getLibraryManager();
        to.setProcessorDefinition(libraryManager.getProcessorDefinition(CONST_IMPL.QM_CHARACTERS));
    }
}

