/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.util.AbstractMessagedException;

public abstract class MayaaException
extends AbstractMessagedException {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$MayaaException == null ? (class$org$seasar$mayaa$impl$MayaaException = MayaaException.class$("org.seasar.mayaa.impl.MayaaException")) : class$org$seasar$mayaa$impl$MayaaException));
    private String _originalSystemID;
    private int _originalLineNumber = -1;
    private String _injectedSystemID;
    private int _injectedLineNumber = -1;
    private static final int RESERVED_PARAM_COUNT = 4;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$MayaaException;

    public MayaaException() {
        this((Throwable)null);
    }

    public MayaaException(Throwable cause) {
        super(cause);
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        if (cycle != null) {
            NodeTreeWalker injected;
            NodeTreeWalker original = cycle.getOriginalNode();
            if (original != null) {
                this._originalSystemID = original.getSystemID();
                this._originalLineNumber = original.getLineNumber();
            }
            if ((injected = cycle.getInjectedNode()) != null) {
                this._injectedSystemID = injected.getSystemID();
                this._injectedLineNumber = injected.getLineNumber();
            }
        }
    }

    protected abstract String[] getMessageParams();

    protected String[] getParamValues() {
        String[] params;
        block3: {
            params = AbstractMessagedException.ZERO_PARAM;
            try {
                params = this.getMessageParams();
                if (params == null) {
                    params = AbstractMessagedException.ZERO_PARAM;
                }
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)t.getMessage(), t);
            }
        }
        int paramLength = params.length;
        String[] newParams = new String[paramLength + 4];
        newParams[0] = this._originalSystemID;
        newParams[1] = Integer.toString(this._originalLineNumber);
        newParams[2] = this._injectedSystemID;
        newParams[3] = Integer.toString(this._injectedLineNumber);
        System.arraycopy(params, 0, newParams, 4, paramLength);
        return newParams;
    }

    public String getOriginalSystemID() {
        return this._originalSystemID;
    }

    public int getOriginalLineNumber() {
        return this._originalLineNumber;
    }

    public String getInjectedSystemID() {
        return this._injectedSystemID;
    }

    public int getInjectedLineNumber() {
        return this._injectedLineNumber;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

