/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.FactoryFactory;
import org.seasar.mayaa.UnifiedFactory;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.MarshallUtil;
import org.seasar.mayaa.impl.cycle.web.ApplicationScopeImpl;
import org.seasar.mayaa.impl.factory.UnifiedFactoryHandler;
import org.seasar.mayaa.impl.source.ApplicationSourceDescriptor;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.XMLUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class FactoryFactoryImpl
extends FactoryFactory
implements CONST_IMPL {
    private static final long serialVersionUID = -1393736148065197812L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$FactoryFactoryImpl == null ? (class$org$seasar$mayaa$impl$FactoryFactoryImpl = FactoryFactoryImpl.class$("org.seasar.mayaa.impl.FactoryFactoryImpl")) : class$org$seasar$mayaa$impl$FactoryFactoryImpl));
    static /* synthetic */ Class class$org$seasar$mayaa$impl$FactoryFactoryImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$UnifiedFactory;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$factory$UnifiedFactoryHandler;

    protected boolean checkInterface(Class clazz) {
        return clazz != null && clazz.isInterface() && (class$org$seasar$mayaa$UnifiedFactory == null ? (class$org$seasar$mayaa$UnifiedFactory = FactoryFactoryImpl.class$("org.seasar.mayaa.UnifiedFactory")) : class$org$seasar$mayaa$UnifiedFactory).isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnifiedFactory marshallFactory(Class interfaceClass, Object context, SourceDescriptor source, UnifiedFactory beforeFactory) {
        UnifiedFactory factory;
        if (source == null) {
            throw new IllegalArgumentException();
        }
        String systemID = source.getSystemID();
        if (source.exists()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("marshall factory: " + source.getSystemID()));
            }
            UnifiedFactoryHandler handler = new UnifiedFactoryHandler(interfaceClass, beforeFactory);
            InputStream stream = source.getInputStream();
            try {
                XMLUtil.parse(handler, stream, "-//The Seasar Foundation//DTD Mayaa Factory 1.0//EN", systemID, true, true, false);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Factory parse error on " + systemID), t);
                }
                factory = beforeFactory;
            }
            finally {
                IOUtil.close(stream);
            }
            factory = handler.getUnifiedFactory();
        } else {
            factory = beforeFactory;
        }
        if (factory != null) {
            factory.setUnderlyingContext(context);
        }
        return factory;
    }

    protected UnifiedFactory getFactory(Class interfaceClass, Object context) {
        if (!this.checkInterface(interfaceClass) || context == null) {
            throw new IllegalArgumentException();
        }
        String systemID = interfaceClass.getName();
        SourceDescriptor source = MarshallUtil.getDefaultSource(systemID, class$org$seasar$mayaa$impl$factory$UnifiedFactoryHandler == null ? (class$org$seasar$mayaa$impl$factory$UnifiedFactoryHandler = FactoryFactoryImpl.class$("org.seasar.mayaa.impl.factory.UnifiedFactoryHandler")) : class$org$seasar$mayaa$impl$factory$UnifiedFactoryHandler);
        UnifiedFactory factory = this.marshallFactory(interfaceClass, context, source, null);
        Iterator it = MarshallUtil.iterateMetaInfSources(systemID);
        while (it.hasNext()) {
            source = (SourceDescriptor)it.next();
            factory = this.marshallFactory(interfaceClass, context, source, factory);
        }
        source = FactoryFactory.getBootstrapSource("/WEB-INF", systemID);
        factory = this.marshallFactory(interfaceClass, context, source, factory);
        return factory;
    }

    protected ApplicationScope getApplicationScope(Object context) {
        ApplicationScopeImpl application = new ApplicationScopeImpl();
        application.setUnderlyingContext(context);
        return application;
    }

    protected SourceDescriptor getBootstrapSource(String root, String systemID, Object context) {
        ApplicationSourceDescriptor appSource = new ApplicationSourceDescriptor();
        if (StringUtil.hasValue(root)) {
            appSource.setRoot(root);
        }
        appSource.setSystemID(systemID);
        appSource.setApplicationScope(this.getApplicationScope(context));
        return appSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

