/*
 * Decompiled with CFR 0.152.
 */
package org.nancle.annotation.collector;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.nancle.annotation.ActionURL;
import org.nancle.annotation.ErrorPage;
import org.nancle.annotation.Page;
import org.nancle.annotation.Pages;
import org.nancle.container.InvokeInfo;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCollector
implements ClassTraversal.ClassHandler {
    private String rootDir = "./";
    private HashMap<String, InvokeInfo> invokeInfoMap = new HashMap();

    public void collection(String string) {
        File file = this.getRootDir();
        ClassTraversal.forEach((File)file, (String)string, (ClassTraversal.ClassHandler)this);
    }

    public void setRootDir(String string) {
        this.rootDir = string;
    }

    protected File getRootDir() {
        return new File(this.rootDir);
    }

    public void processClass(String string, String string2) {
        String string3 = ClassUtil.concatName((String)string, (String)string2);
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(string3);
            this.collectionAnnotation(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    protected void collectionAnnotation(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            InvokeInfo invokeInfo = this.parseActionUrl(methodArray[i]);
            if (invokeInfo == null) continue;
            invokeInfo = this.parseParamType(methodArray[i], invokeInfo);
            invokeInfo = this.parsePages(methodArray[i], invokeInfo);
            invokeInfo = this.parseErrorPage(methodArray[i], invokeInfo);
            invokeInfo.setClazz(clazz);
            invokeInfo.setMethod(methodArray[i]);
            this.invokeInfoMap.put(invokeInfo.getUrl(), invokeInfo);
        }
    }

    private InvokeInfo parseActionUrl(Method method) {
        ActionURL actionURL = method.getAnnotation(ActionURL.class);
        if (actionURL == null) {
            return null;
        }
        String string = actionURL.value();
        InvokeInfo invokeInfo = new InvokeInfo();
        invokeInfo.setUrl(string);
        return invokeInfo;
    }

    private InvokeInfo parseParamType(Method method, InvokeInfo invokeInfo) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0) {
            invokeInfo.setFormClazz(classArray[0]);
        }
        return invokeInfo;
    }

    private InvokeInfo parsePages(Method method, InvokeInfo invokeInfo) {
        Pages pages = method.getAnnotation(Pages.class);
        if (pages == null) {
            return invokeInfo;
        }
        Page[] pageArray = pages.value();
        if (pageArray.length > 0) {
            for (int i = 0; i < pageArray.length; ++i) {
                invokeInfo.addPage(pageArray[i].status(), pageArray[i].page());
            }
        }
        return invokeInfo;
    }

    private InvokeInfo parseErrorPage(Method method, InvokeInfo invokeInfo) {
        ErrorPage errorPage = method.getAnnotation(ErrorPage.class);
        if (errorPage == null) {
            return invokeInfo;
        }
        invokeInfo.setErrorPage(errorPage.value());
        return invokeInfo;
    }

    public HashMap<String, InvokeInfo> getInvokeInfoMap() {
        return this.invokeInfoMap;
    }
}

