/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cyberneko.html.HTMLEntities;
import org.seasar.mayaa.impl.cycle.script.ScriptUtil;
import org.seasar.mayaa.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;

public final class StringUtil {
    private static Map _propFiles = new HashMap();
    private static final String[] ZERO = new String[0];
    private static final String SP_OPEN = "${";
    private static final String SP_CLOSE = "}";

    private StringUtil() {
    }

    public static boolean isEmpty(Object test) {
        boolean result;
        if (test instanceof String) {
            result = StringUtil.isEmpty((String)test);
        } else {
            result = ScriptUtil.isEmpty(test);
            if (!result) {
                result = StringUtil.isEmpty(test.toString());
            }
        }
        return result;
    }

    public static String valueOf(Object value) {
        String result = null;
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public static boolean isEmpty(String test) {
        return test == null || test.length() == 0;
    }

    public static boolean hasValue(Object test) {
        return !StringUtil.isEmpty(test);
    }

    public static boolean hasValue(String test) {
        return !StringUtil.isEmpty(test);
    }

    public static String preparePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        path = path.trim();
        if ((path = path.replace(File.separatorChar, '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() > 0 && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public static String resolveEntity(String blockString) {
        StringBuffer buffer = new StringBuffer();
        int start = blockString.indexOf("&");
        if (start == -1) {
            return blockString;
        }
        buffer.append(blockString.substring(0, start));
        do {
            int end;
            if ((end = blockString.indexOf(";", start)) == -1) {
                buffer.append(blockString.substring(start));
                break;
            }
            String entity = blockString.substring(start + 1, end);
            int value = HTMLEntities.get((String)entity);
            if (value != -1) {
                buffer.append((char)value);
            } else {
                buffer.append(blockString.substring(start, end + 1));
            }
            start = blockString.indexOf("&", end);
            if (start == -1) {
                buffer.append(blockString.substring(end + 1));
                break;
            }
            if (start == end + 1) continue;
            buffer.append(blockString.substring(end + 1, start));
        } while (start != blockString.length());
        return buffer.toString();
    }

    public static String[] parsePath(String path, String suffixSeparator) {
        int lastDotOffset;
        String[] ret = new String[3];
        int paramOffset = path.indexOf(63);
        if (paramOffset >= 0) {
            path = path.substring(0, paramOffset);
        }
        int lastSlashOffset = path.lastIndexOf(47);
        String folder = "";
        String file = path;
        if (lastSlashOffset >= 0) {
            folder = path.substring(0, lastSlashOffset + 1);
            file = path.substring(lastSlashOffset + 1);
        }
        if ((lastDotOffset = file.lastIndexOf(46)) > 0) {
            ret[2] = file.substring(lastDotOffset + 1);
            file = file.substring(0, lastDotOffset);
        } else {
            ret[2] = "";
        }
        int suffixSeparatorOffset = file.lastIndexOf(suffixSeparator);
        if (suffixSeparatorOffset > 0) {
            ret[0] = folder + file.substring(0, suffixSeparatorOffset);
            ret[1] = file.substring(suffixSeparatorOffset + suffixSeparator.length());
        } else {
            ret[0] = folder + file;
            ret[1] = "";
        }
        return ret;
    }

    public static boolean isRelativePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return false;
        }
        return path.startsWith("./");
    }

    public static String adjustRelativePath(String base, String path) {
        if (!StringUtil.isRelativePath(path)) {
            return path;
        }
        if (StringUtil.isEmpty(base)) {
            throw new IllegalArgumentException();
        }
        try {
            String baseDir = base.substring(0, base.lastIndexOf(47));
            return StringUtil.adjustRecursive(baseDir, path);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String adjustRecursive(String dir, String path) {
        if (StringUtil.isEmpty(path)) {
            return dir + '/';
        }
        try {
            if (path.startsWith("../")) {
                if (StringUtil.isEmpty(dir)) {
                    return StringUtil.adjustRecursive(dir, path.substring(3));
                }
                String parentDir = dir.substring(0, dir.lastIndexOf(47));
                return StringUtil.adjustRecursive(parentDir, path.substring(3));
            }
            if (path.startsWith("./")) {
                return StringUtil.adjustRecursive(dir, path.substring(2));
            }
            return dir + '/' + path;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeFileProtocol(String systemID) {
        if (StringUtil.hasValue(systemID) && systemID.startsWith("file://")) {
            return systemID.substring(7);
        }
        return systemID;
    }

    public static boolean hasSystemProperties(String value) {
        int openIndex = value.indexOf(SP_OPEN);
        int closeIndex = value.lastIndexOf(SP_CLOSE);
        return openIndex >= 0 && closeIndex >= 0 && openIndex < closeIndex;
    }

    public static String replaceSystemProperties(String value) {
        if (!StringUtil.hasSystemProperties(value)) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value.length() + 100);
        int openIndex = value.indexOf(SP_OPEN);
        buffer.append(value.substring(0, openIndex));
        while (openIndex < value.length()) {
            int fromIndex = openIndex + SP_OPEN.length();
            int closeIndex = value.indexOf(SP_CLOSE, fromIndex);
            if (closeIndex >= 0) {
                String key = value.substring(fromIndex, closeIndex).trim();
                String propertyValue = System.getProperty(key);
                if (propertyValue == null) {
                    throw new IllegalStateException(key);
                }
                buffer.append(propertyValue);
                int lastIndex = closeIndex + SP_CLOSE.length();
                openIndex = value.indexOf(SP_OPEN, lastIndex);
                if (openIndex < 0) {
                    openIndex = value.length();
                }
                buffer.append(value.substring(lastIndex, openIndex));
                continue;
            }
            buffer.append(value.substring(openIndex));
            openIndex = value.length();
        }
        return buffer.toString();
    }

    public static String getMessage(Class clazz, int index) {
        return StringUtil.getMessage(clazz, index, ZERO);
    }

    public static String getMessage(Class clazz, int index, String param0) {
        return StringUtil.getMessage(clazz, index, new String[]{param0});
    }

    public static String getMessage(Class clazz, int index, String param0, String param1) {
        return StringUtil.getMessage(clazz, index, new String[]{param0, param1});
    }

    public static String getMessage(Class clazz, int index, String param0, String param1, String param2) {
        return StringUtil.getMessage(clazz, index, new String[]{param0, param1, param2});
    }

    protected static String getMessage(Class clazz, int index, String[] params) {
        String message;
        Package key = clazz.getPackage();
        Properties properties = (Properties)_propFiles.get(key);
        if (properties == null) {
            ClassLoaderSourceDescriptor source = new ClassLoaderSourceDescriptor();
            source.setSystemID("message.properties");
            source.setNeighborClass(clazz);
            properties = new Properties();
            _propFiles.put(key, properties);
            if (source.exists()) {
                InputStream stream = source.getInputStream();
                try {
                    properties.load(stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    IOUtil.close(stream);
                }
            }
        }
        String className = ObjectUtil.getSimpleClassName(clazz);
        StringBuffer propertyName = new StringBuffer(className);
        if (index > 0) {
            propertyName.append(".").append(index);
        }
        if (StringUtil.isEmpty(message = properties.getProperty(propertyName.toString()))) {
            message = "!" + clazz.getName() + "!";
        }
        if (params == null) {
            params = ZERO;
        }
        return MessageFormat.format(message, params);
    }

    public static String escapeXml(String text) {
        if (text == null) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 50);
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeWhitespace(String text) {
        if (text == null) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 50);
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\r': {
                    sb.append("&#xd;");
                    continue block5;
                }
                case '\n': {
                    sb.append("&#xa;");
                    continue block5;
                }
                case '\t': {
                    sb.append("&#x9;");
                    continue block5;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeEol(String text, boolean forHTML) {
        if (text == null) {
            return "";
        }
        String br = forHTML ? "<br>" : "<br />";
        char[] chars = text.toCharArray();
        StringBuffer sb = new StringBuffer(chars.length + 50);
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\r': {
                    sb.append(br);
                    if (chars.length <= i + 1 || chars[i + 1] != '\n') continue block4;
                    ++i;
                    continue block4;
                }
                case '\n': {
                    sb.append(br);
                    continue block4;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    public static String parsePrefix(String qName) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        int position = qName.indexOf(58);
        if (position >= 0) {
            return qName.substring(0, position);
        }
        return "";
    }

    public static boolean equals(Object s1, Object s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public static String join(Object[] items, String delimiter) {
        if (items == null) {
            return String.valueOf(items);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }
}

