/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.seasar.mayaa.cycle.scope.AttributeScope;

public class IteratorUtil {
    public static final Iterator NULL_ITERATOR = new Iterator(){

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };

    private IteratorUtil() {
    }

    public static Iterator toIterator(Object o) {
        if (o instanceof AttributeScope) {
            return ((AttributeScope)o).iterateAttributeNames();
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof Iterator) {
            return (Iterator)o;
        }
        if (o instanceof Enumeration) {
            return new EnumrationIterator((Enumeration)o);
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().iterator();
        }
        if (o instanceof Object[]) {
            return IteratorUtil.toObjectIterator((Object[])o);
        }
        if (o instanceof boolean[]) {
            return IteratorUtil.toObjectIterator((boolean[])o);
        }
        if (o instanceof byte[]) {
            return IteratorUtil.toObjectIterator((byte[])o);
        }
        if (o instanceof char[]) {
            return IteratorUtil.toObjectIterator((char[])o);
        }
        if (o instanceof short[]) {
            return IteratorUtil.toObjectIterator((short[])o);
        }
        if (o instanceof int[]) {
            return IteratorUtil.toObjectIterator((int[])o);
        }
        if (o instanceof long[]) {
            return IteratorUtil.toObjectIterator((long[])o);
        }
        if (o instanceof float[]) {
            return IteratorUtil.toObjectIterator((float[])o);
        }
        if (o instanceof double[]) {
            return IteratorUtil.toObjectIterator((double[])o);
        }
        if (o != null) {
            return IteratorUtil.toObjectIterator(new Object[]{o});
        }
        return NULL_ITERATOR;
    }

    private static Iterator toObjectIterator(Object[] objects) {
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(boolean[] booleans) {
        Boolean[] objects = new Boolean[booleans.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Boolean(booleans[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(byte[] bytes) {
        Byte[] objects = new Byte[bytes.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Byte(bytes[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(char[] chars) {
        Character[] objects = new Character[chars.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Character(chars[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(short[] shorts) {
        Short[] objects = new Short[shorts.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Short(shorts[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(int[] ints) {
        Integer[] objects = new Integer[ints.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Integer(ints[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(long[] longs) {
        Long[] objects = new Long[longs.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Long(longs[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(float[] floats) {
        Float[] objects = new Float[floats.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Float(floats[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static Iterator toObjectIterator(double[] doubles) {
        Double[] objects = new Double[doubles.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new Double(doubles[i]);
        }
        return Arrays.asList(objects).iterator();
    }

    private static class EnumrationIterator
    implements Iterator {
        private Enumeration _enumeration;

        protected EnumrationIterator(Enumeration enumeration) {
            this._enumeration = enumeration;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this._enumeration.hasMoreElements();
        }

        public Object next() {
            return this._enumeration.nextElement();
        }
    }
}

