/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileSearchIterator
implements Iterator,
Runnable {
    private File _root;
    private FilenameFilter _filenameFilter;
    private boolean _done = false;
    private File _current;
    private Thread _stepFindThread;
    private boolean _gotNext = false;
    private volatile boolean _doFindNext;
    private volatile boolean _doFindNextDone;
    private Thread _internalCurrentThread;

    public FileSearchIterator(File rootDir) {
        this(rootDir, null);
    }

    public FileSearchIterator(File rootDir, FilenameFilter filenameFilter) {
        this._root = rootDir;
        this._filenameFilter = filenameFilter;
    }

    public File getRoot() {
        return this._root;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filenameFilter;
    }

    protected void startThread() {
        if (this._stepFindThread == null) {
            this._done = false;
            this._doFindNext = false;
            this._stepFindThread = new Thread(this);
            this._stepFindThread.setName("fileSearch:root=" + this._root + ":filter=" + this._filenameFilter);
            this._stepFindThread.start();
        }
    }

    protected void stopThread() {
        this._stepFindThread = null;
    }

    public boolean hasNext() {
        if (this._done && this._current == null) {
            return false;
        }
        this.startThread();
        this._doFindNext = true;
        while (!this._done && !this._doFindNextDone) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        boolean found = this._doFindNextDone;
        this._doFindNext = false;
        while (!this._done && this._doFindNextDone) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this._done && !found) {
            return false;
        }
        this._gotNext = found;
        return found;
    }

    public Object next() {
        if (!this._gotNext && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._gotNext = false;
        return this._current;
    }

    public void run() {
        try {
            this._done = false;
            this._current = null;
            this._internalCurrentThread = Thread.currentThread();
            this.findFile(this._root, this._root);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._done = true;
    }

    protected void findFile(File root, File dir) throws InterruptedException {
        File file;
        int i;
        File[] files = this._filenameFilter == null ? dir.listFiles() : dir.listFiles(this._filenameFilter);
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (!file.isFile() || file.isHidden()) continue;
            while (!this._doFindNext && this._internalCurrentThread == this._stepFindThread) {
                Thread.sleep(1L);
            }
            if (this._internalCurrentThread != this._stepFindThread) {
                return;
            }
            this._current = file;
            this._doFindNextDone = true;
            while (this._doFindNext && this._internalCurrentThread == this._stepFindThread) {
                Thread.sleep(1L);
            }
            this._doFindNextDone = false;
            if (this._internalCurrentThread == this._stepFindThread) continue;
            return;
        }
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (!file.isDirectory()) continue;
            this.findFile(root, file);
            if (this._internalCurrentThread == this._stepFindThread) continue;
            return;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void finalize() throws Throwable {
        this.stopThread();
        super.finalize();
    }
}

