/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.builder.PathAdjuster;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.processor.AbstractAttributableProcessor;
import org.seasar.mayaa.impl.engine.processor.ElementProcessor;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class AttributeProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = -8399232805371906530L;
    private PrefixAwareName _name;
    private ProcessorProperty _value;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$processor$ElementProcessor;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractAttributableProcessor findParentAttributable() {
        for (ProcessorTreeWalker parent = this.getParentProcessor(); parent != null; parent = parent.getParentProcessor()) {
            if (!(parent instanceof AbstractAttributableProcessor)) continue;
            return (AbstractAttributableProcessor)parent;
        }
        throw new IllegalStateException();
    }

    public void setName(PrefixAwareName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    protected PrefixAwareName getName() {
        return this._name;
    }

    public void setValue(ProcessorProperty value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this._value = value;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._value == null) {
            throw new IllegalStateException();
        }
        AbstractAttributableProcessor parent = this.findParentAttributable();
        QName parentQName = parent.getClass() == (class$org$seasar$mayaa$impl$engine$processor$ElementProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$ElementProcessor = AttributeProcessor.class$("org.seasar.mayaa.impl.engine.processor.ElementProcessor")) : class$org$seasar$mayaa$impl$engine$processor$ElementProcessor) ? ((ElementProcessor)parent).getName().getQName() : parent.getOriginalNode().getQName();
        QName attributeQName = this.getName().getQName();
        if (this.getName().getPrefix().equals("") && !parentQName.equals(this.getName().getQName())) {
            attributeQName = SpecificationUtil.createQName(parentQName.getNamespaceURI(), attributeQName.getLocalName());
            this.setName(SpecificationUtil.createPrefixAwareName(attributeQName, ""));
        }
        String basePath = null;
        PathAdjuster adjuster = ProviderUtil.getPathAdjuster();
        if (adjuster.isTargetAttribute(parentQName, attributeQName)) {
            String contextPath = CycleUtil.getRequestScope().getContextPath();
            String sourcePath = EngineUtil.getSourcePath(this.getParentProcessor());
            basePath = contextPath + sourcePath;
        }
        parent.addProcesstimeProperty(new ProcessorPropertyWrapper(this._name, this._value, basePath));
        return ProcessStatus.SKIP_BODY;
    }

    public void kill() {
        this._name = null;
        this._value = null;
        super.kill();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected abstract class ScriptWrapper
    implements CompiledScript {
        private CompiledScript _script;
        private boolean _string;

        public ScriptWrapper(CompiledScript script) {
            this._script = script;
            this._string = (class$java$lang$String == null ? (class$java$lang$String = AttributeProcessor.class$("java.lang.String")) : class$java$lang$String).equals(this._script.getExpectedClass());
        }

        public boolean isString() {
            return this._string;
        }

        public void setExpectedClass(Class expectedClass) {
            this._script.setExpectedClass(expectedClass);
        }

        public Class getExpectedClass() {
            return this._script.getExpectedClass();
        }

        public Object execute(Object[] args) {
            return this._script.execute(args);
        }

        public void setMethodArgClasses(Class[] methodArgClasses) {
            this._script.setMethodArgClasses(methodArgClasses);
        }

        public Class[] getMethodArgClasses() {
            return this._script.getMethodArgClasses();
        }

        public boolean isLiteral() {
            return this._script.isLiteral();
        }

        public String getScriptText() {
            return this._script.getScriptText();
        }

        public boolean isReadOnly() {
            return this._script.isReadOnly();
        }

        public void assignValue(Object value) {
            this._script.assignValue(value);
        }

        public String toString() {
            return this._script.toString();
        }

        public String escape(String value) {
            return StringUtil.escapeWhitespace(StringUtil.escapeXml(value));
        }
    }

    protected class EscapedLiteralScript
    extends ScriptWrapper {
        private static final long serialVersionUID = -441522603771461865L;
        private String _escapedValue = "";

        public EscapedLiteralScript(CompiledScript script, String basePath) {
            super(script);
            Object obj;
            if (this.isString() && StringUtil.hasValue(obj = super.execute(null))) {
                this._escapedValue = obj.toString();
                if (basePath != null) {
                    this._escapedValue = StringUtil.adjustRelativePath(basePath, this._escapedValue);
                }
                this._escapedValue = this.escape(this._escapedValue);
            }
        }

        public Object execute(Object[] args) {
            return this._escapedValue;
        }
    }

    protected class EscapableScript
    extends ScriptWrapper {
        private static final long serialVersionUID = -5393294025521796857L;
        private String _basePath;

        public EscapableScript(CompiledScript script, String basePath) {
            super(script);
            this._basePath = basePath;
        }

        public Object execute(Object[] args) {
            Object result = super.execute(args);
            if (this.isString() && StringUtil.hasValue(result)) {
                if (this._basePath != null) {
                    result = StringUtil.adjustRelativePath(this._basePath, result.toString());
                }
                result = this.escape(result.toString());
            }
            return result;
        }
    }

    protected class ProcessorPropertyWrapper
    implements ProcessorProperty {
        private PrefixAwareName _attrName;
        private ProcessorProperty _attrValue;
        private CompiledScript _script;

        public ProcessorPropertyWrapper(PrefixAwareName name, ProcessorProperty property, String basePath) {
            if (name == null || property == null) {
                throw new IllegalArgumentException();
            }
            this._attrName = name;
            this._attrValue = property;
            this._script = this._attrValue.getValue().isLiteral() ? new EscapedLiteralScript(this._attrValue.getValue(), basePath) : new EscapableScript(this._attrValue.getValue(), basePath);
        }

        public PrefixAwareName getName() {
            return this._attrName;
        }

        public CompiledScript getValue() {
            return this._script;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessorProperty) {
                PrefixAwareName otherName = ((ProcessorProperty)obj).getName();
                return this.getName().getQName().equals(otherName.getQName());
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.getName().toString() + "=\"" + this._script + "\"";
        }
    }
}

