/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.error.ErrorHandler;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.CyclicForwardException;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.PageForwarded;
import org.seasar.mayaa.impl.engine.PageNotFoundException;
import org.seasar.mayaa.impl.engine.ProcessorDump;
import org.seasar.mayaa.impl.engine.RenderNotCompletedException;
import org.seasar.mayaa.impl.engine.RenderingTerminated;
import org.seasar.mayaa.impl.engine.SpecificationCache;
import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.source.DelaySourceDescriptor;
import org.seasar.mayaa.impl.source.SourceUtil;
import org.seasar.mayaa.impl.util.DateFormatPool;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class EngineImpl
extends SpecificationImpl
implements Engine,
CONST_IMPL {
    static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$EngineImpl == null ? (class$org$seasar$mayaa$impl$engine$EngineImpl = EngineImpl.class$("org.seasar.mayaa.impl.engine.EngineImpl")) : class$org$seasar$mayaa$impl$engine$EngineImpl));
    private static final long serialVersionUID = 1428444571422324206L;
    private static final String DEFAULT_SPECIFICATION = "defaultSpecification";
    private static final String PAGE_CLASS = "pageClass";
    private static final String TEMPLATE_CLASS = "templateClass";
    private static final String PAGE_SERIALIZE = "pageSerialize";
    private static final String SURVIVE_LIMIT = "surviveLimit";
    private static final String FORWARD_LIMIT = "forwardLimit";
    private static final String REQUESTED_SUFFIX_ENABLED = "requestedSuffixEnabled";
    private static final String DUMP_ENABLED = "dumpEnabled";
    private static final String MAYAA_EXTENSION = ".mayaa";
    private static final boolean DEFAULT_PAGE_SERIALIZE = true;
    private transient Specification _defaultSpecification;
    private transient ErrorHandler _errorHandler;
    private transient SpecificationCache _specCache;
    private String _defaultSpecificationID = "";
    private List _templatePathPatterns;
    private Class _pageClass = class$org$seasar$mayaa$impl$engine$PageImpl == null ? (class$org$seasar$mayaa$impl$engine$PageImpl = EngineImpl.class$("org.seasar.mayaa.impl.engine.PageImpl")) : class$org$seasar$mayaa$impl$engine$PageImpl;
    private Class _templateClass = class$org$seasar$mayaa$impl$engine$TemplateImpl == null ? (class$org$seasar$mayaa$impl$engine$TemplateImpl = EngineImpl.class$("org.seasar.mayaa.impl.engine.TemplateImpl")) : class$org$seasar$mayaa$impl$engine$TemplateImpl;
    private int _surviveLimit = 5;
    private boolean _requestedSuffixEnabled = false;
    private boolean _dumpEnabled = false;
    private int _forwardLimit = 10;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$EngineImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$PageImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$TemplateImpl;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$CyclicForwardException;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$Page;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$Template;

    public EngineImpl() {
        this.setSpecificationSerialize(true);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        if (this._errorHandler == null) {
            throw new IllegalStateException();
        }
        return this._errorHandler;
    }

    public Specification findSpecificationFromCache(String systemID) {
        return this.getCache().get(systemID);
    }

    protected Page findPageFromCache(String pageName) {
        return (Page)this.findSpecificationFromCache(pageName + MAYAA_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String pageName) {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            Page page = this.findPageFromCache(pageName);
            if (page == null) {
                page = this.createPageInstance(pageName);
            }
            return page;
        }
    }

    public boolean isPageRequested() {
        RequestScope request = CycleUtil.getRequestScope();
        if (CONST_IMPL.QM_MAYAA.getLocalName().equals(request.getExtension())) {
            return true;
        }
        return this.validPath(request.getRequestedPath(), request.getMimeType());
    }

    private boolean validPath(String path, String mimeType) {
        if (this._templatePathPatterns != null) {
            Iterator it = this._templatePathPatterns.iterator();
            while (it.hasNext()) {
                PathPattern pattern = (PathPattern)it.next();
                if (!pattern.matches(path)) continue;
                return pattern.isTemplate();
            }
        }
        return mimeType != null && (mimeType.indexOf("html") != -1 || mimeType.indexOf("xml") != -1);
    }

    protected Throwable removeWrapperRuntimeException(Throwable t) {
        Throwable throwable = t;
        while (throwable.getClass().equals(class$java$lang$RuntimeException == null ? EngineImpl.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public void handleError(Throwable t, boolean pageFlush) {
        if ((t = this.removeWrapperRuntimeException(t)) instanceof IOException && this.isClientAbortException((IOException)t)) {
            return;
        }
        if (t instanceof CyclicForwardException) {
            throw (CyclicForwardException)t;
        }
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        try {
            cycle.setHandledError(t);
            this.getErrorHandler().doErrorHandle(t, pageFlush);
        }
        catch (RenderingTerminated ignore) {
        }
        catch (PageForwarded pf) {
            this.checkCyclicForward(cycle.getRequestScope());
            this.doPageService(cycle, null, pageFlush);
        }
        catch (Throwable internal) {
            if (internal instanceof PageNotFoundException) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)t.getMessage());
                }
            } else if (LOG.isFatalEnabled()) {
                String fatalMsg = StringUtil.getMessage(class$org$seasar$mayaa$impl$engine$EngineImpl == null ? (class$org$seasar$mayaa$impl$engine$EngineImpl = EngineImpl.class$("org.seasar.mayaa.impl.engine.EngineImpl")) : class$org$seasar$mayaa$impl$engine$EngineImpl, 0, internal.getMessage());
                LOG.fatal((Object)fatalMsg, internal);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            cycle.setHandledError(null);
        }
    }

    protected void checkCyclicForward(RequestScope request) {
        String pageName;
        Integer count;
        int countInt;
        if (this._forwardLimit <= 0) {
            return;
        }
        String key = (class$org$seasar$mayaa$impl$engine$CyclicForwardException == null ? (class$org$seasar$mayaa$impl$engine$CyclicForwardException = EngineImpl.class$("org.seasar.mayaa.impl.engine.CyclicForwardException")) : class$org$seasar$mayaa$impl$engine$CyclicForwardException).getName();
        HashMap<String, Integer> pathMap = (HashMap<String, Integer>)request.getAttribute(key);
        if (pathMap == null) {
            pathMap = new HashMap<String, Integer>();
            request.setAttribute(key, pathMap);
        }
        int n = countInt = (count = (Integer)pathMap.get(pageName = this.getRequestedPageName(request))) != null ? count + 1 : 1;
        if (countInt > this._forwardLimit) {
            throw new CyclicForwardException(pageName);
        }
        pathMap.put(pageName, new Integer(countInt));
    }

    protected String getRequestedPageName(RequestScope request) {
        StringBuffer sb = new StringBuffer();
        sb.append(request.getPageName());
        if (StringUtil.hasValue(request.getRequestedSuffix())) {
            sb.append(this.getSuffixSeparator());
            sb.append(request.getRequestedSuffix());
        }
        sb.append('.');
        sb.append(request.getExtension());
        return sb.toString();
    }

    protected void saveToCycle() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(this);
        cycle.setInjectedNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        EngineImpl engineImpl = this;
        synchronized (engineImpl) {
            if (this._defaultSpecification != null) {
                if (!this._defaultSpecification.isDeprecated()) {
                    return;
                }
                this.releaseDefaultSpecification();
            }
            if (StringUtil.hasValue(this._defaultSpecificationID)) {
                this._defaultSpecification = this.createDefaultSpecification(this._defaultSpecificationID);
            }
        }
    }

    public void addChildNode(NodeTreeWalker childNode) {
        if (this._defaultSpecification != null) {
            this._defaultSpecification.addChildNode(childNode);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public NodeTreeWalker getChildNode(int index) {
        if (this._defaultSpecification != null) {
            return this._defaultSpecification.getChildNode(index);
        }
        throw new UnsupportedOperationException();
    }

    public int getChildNodeSize() {
        if (this._defaultSpecification != null) {
            return this._defaultSpecification.getChildNodeSize();
        }
        throw new UnsupportedOperationException();
    }

    public void clearChildNodes() {
        if (this._defaultSpecification != null) {
            this._defaultSpecification.clearChildNodes();
        }
        throw new UnsupportedOperationException();
    }

    public void kill() {
        super.kill();
        this.releaseDefaultSpecification();
    }

    protected void releaseDefaultSpecification() {
        if (this._defaultSpecification != null) {
            this._defaultSpecification.kill();
            this._defaultSpecification = null;
        }
    }

    public void insertChildNode(int index, NodeTreeWalker childNode) {
        if (this._defaultSpecification != null) {
            this._defaultSpecification.insertChildNode(index, childNode);
        }
        throw new UnsupportedOperationException();
    }

    public boolean removeChildNode(NodeTreeWalker node) {
        if (this._defaultSpecification != null) {
            this._defaultSpecification.removeChildNode(node);
        }
        throw new UnsupportedOperationException();
    }

    public Iterator iterateChildNode() {
        if (this._defaultSpecification != null) {
            return this._defaultSpecification.iterateChildNode();
        }
        throw new UnsupportedOperationException();
    }

    public Date getTimestamp() {
        if (this._defaultSpecification != null) {
            return this._defaultSpecification.getTimestamp();
        }
        return null;
    }

    public boolean isDeprecated() {
        if (this._defaultSpecification != null) {
            return this._defaultSpecification.isDeprecated();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPageService(ServiceCycle cycle, Map pageScopeValues, boolean pageFlush) {
        this.build();
        try {
            boolean service = true;
            while (service) {
                try {
                    String pageName = null;
                    String extension = null;
                    String requestedSuffix = null;
                    ProcessStatus ret = null;
                    this.saveToCycle();
                    SpecificationUtil.initScope();
                    SpecificationUtil.startScope(pageScopeValues);
                    try {
                        SpecificationUtil.execEvent(this, CONST_IMPL.QM_BEFORE_RENDER);
                        RequestScope request = cycle.getRequestScope();
                        pageName = request.getPageName();
                        extension = request.getExtension();
                        if (this._requestedSuffixEnabled) {
                            requestedSuffix = request.getRequestedSuffix();
                        }
                        Page page = this.getPage(pageName);
                        ret = page.doPageRender(requestedSuffix, extension);
                        this.saveToCycle();
                        SpecificationUtil.execEvent(this, CONST_IMPL.QM_AFTER_RENDER);
                    }
                    finally {
                        SpecificationUtil.endScope();
                    }
                    Response response = CycleUtil.getResponse();
                    if (ret == null && !response.getWriter().isDirty()) {
                        throw new RenderNotCompletedException(pageName, extension);
                    }
                    if (pageFlush) {
                        response.flush();
                    }
                    service = false;
                }
                catch (RenderingTerminated rt) {
                    service = false;
                }
                catch (PageForwarded ignore) {
                    this.checkCyclicForward(cycle.getRequestScope());
                }
            }
        }
        catch (Throwable t) {
            cycle.getResponse().clearBuffer();
            SpecificationUtil.initScope();
            this.handleError(t, pageFlush);
            this.saveToCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doResourceService(ServiceCycle cycle) {
        InputStream stream;
        if (cycle == null) {
            throw new IllegalArgumentException();
        }
        String path = cycle.getRequestScope().getRequestedPath();
        SourceDescriptor source = SourceUtil.getSourceDescriptor(path);
        source.setSystemID(path);
        String[] modifiedSinces = (String[])cycle.getRequestScope().getHeaderValues().getAttribute("If-Modified-Since");
        if (modifiedSinces != null && modifiedSinces.length > 0) {
            String modifiedSince = modifiedSinces[0];
            Date sinceDate = null;
            DateFormat format = DateFormatPool.borrowRFC1123Format();
            try {
                sinceDate = format.parse(modifiedSince);
            }
            catch (ParseException e) {
                DateFormat format2 = DateFormatPool.borrowRFC2822Format();
                try {
                    sinceDate = format2.parse(modifiedSince);
                }
                catch (ParseException e2) {
                }
                finally {
                    DateFormatPool.returnFormat(format2);
                }
            }
            finally {
                DateFormatPool.returnFormat(format);
            }
            Date sourceTimestamp = new Date(source.getTimestamp().getTime() / 1000L * 1000L);
            if (sinceDate != null && !sourceTimestamp.after(sinceDate)) {
                cycle.getResponse().setStatus(304);
                return;
            }
        }
        if ((stream = source.getInputStream()) == null) {
            cycle.getResponse().setStatus(404);
            return;
        }
        DateFormat format = DateFormatPool.borrowRFC1123Format();
        try {
            cycle.getResponse().setHeader("Last-Modified", format.format(source.getTimestamp()));
        }
        finally {
            DateFormatPool.returnFormat(format);
        }
        OutputStream out = cycle.getResponse().getOutputStream();
        try {
            int readln;
            byte[] buffer = new byte[512];
            while ((readln = stream.read(buffer)) != -1) {
                out.write(buffer, 0, readln);
            }
            out.flush();
            return;
        }
        catch (IOException e) {
            if (!this.isClientAbortException(e)) throw new RuntimeException(e);
            stream = null;
            return;
        }
        finally {
            if (stream != null) {
                IOUtil.close(stream);
            }
        }
    }

    protected boolean isClientAbortException(IOException e) {
        String simpleClassName = ObjectUtil.getSimpleClassName(e.getClass());
        switch (simpleClassName.charAt(0)) {
            case 'E': {
                return simpleClassName.equals("EOFException");
            }
            case 'C': {
                return simpleClassName.equals("ClientAbortException");
            }
        }
        return false;
    }

    public void doService(Map pageScopeValues, boolean pageFlush) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        if (this.isPageRequested()) {
            this.doPageService(cycle, pageScopeValues, pageFlush);
            if (this._dumpEnabled) {
                this.dump(cycle);
            }
        } else {
            this.doResourceService(cycle);
        }
    }

    protected void dump(ServiceCycle cycle) {
        ProcessorDump dump = new ProcessorDump();
        dump.setPrintContents(true);
        RequestScope request = cycle.getRequestScope();
        String pageName = request.getPageName();
        Page page = this.getPage(pageName);
        dump.printSource(page);
    }

    protected SpecificationCache getCache() {
        if (this._specCache == null) {
            this._specCache = new SpecificationCache(this._surviveLimit);
        }
        return this._specCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Specification createSpecificationInstance(String systemID, boolean registCache, SpecificationGenerator generator) {
        SourceDescriptor source;
        Class specClass;
        Specification spec;
        if (this.isSpecificationSerialize() && (spec = this.deserialize(systemID)) != null) {
            if (!spec.isDeprecated()) {
                if (registCache) {
                    this.getCache().add(spec);
                }
                return spec;
            }
            spec.kill();
        }
        if ((specClass = generator.getInstantiator(source = SourceUtil.getSourceDescriptor(systemID))) == null) {
            return null;
        }
        spec = (Specification)ObjectUtil.newInstance(specClass);
        generator.initialize(spec);
        if (spec instanceof SpecificationImpl) {
            ((SpecificationImpl)spec).setSpecificationSerialize(this.isSpecificationSerialize());
        }
        spec.setSource(source);
        spec.setSystemID(systemID);
        try {
            SpecificationUtil.startScope(null);
            try {
                spec.build();
            }
            finally {
                SpecificationUtil.endScope();
            }
        }
        catch (RuntimeException e) {
            spec.kill();
            throw e;
        }
        if (registCache) {
            this.getCache().add(spec);
        }
        return spec;
    }

    public Specification createDefaultSpecification(String systemID) {
        return this.createSpecificationInstance(systemID, false, new SpecificationGenerator(){

            public Class getInstantiator(SourceDescriptor source) {
                return class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl = EngineImpl.class$("org.seasar.mayaa.impl.engine.specification.SpecificationImpl")) : class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl;
            }

            public void initialize(Specification instance) {
            }
        });
    }

    public Page createPageInstance(final String pageName) {
        return (Page)this.createSpecificationInstance(pageName + MAYAA_EXTENSION, true, new SpecificationGenerator(){

            public Class getInstantiator(SourceDescriptor source) {
                return EngineImpl.this.getPageClass();
            }

            public void initialize(Specification instance) {
                ((Page)instance).initialize(pageName);
            }
        });
    }

    public Template createTemplateInstance(final Page page, final String suffix, final String extension) {
        return (Template)this.createSpecificationInstance(this.getTemplateID(page, suffix, extension), true, new SpecificationGenerator(){

            public Class getInstantiator(SourceDescriptor source) {
                if (!source.exists()) {
                    return null;
                }
                return EngineImpl.this.getTemplateClass();
            }

            public void initialize(Specification instance) {
                ((Template)instance).initialize(page, suffix, extension);
            }
        });
    }

    public String getTemplateID(Page page, String suffix, String extension) {
        StringBuffer name = new StringBuffer(page.getPageName());
        if (StringUtil.hasValue(suffix)) {
            String separator = this.getSuffixSeparator();
            name.append(separator).append(suffix);
        }
        if (StringUtil.hasValue(extension)) {
            name.append(".").append(extension);
        }
        return name.toString();
    }

    protected String getSuffixSeparator() {
        return EngineUtil.getEngineSetting("suffixSeparator", "$");
    }

    protected void finalize() throws Throwable {
        if (this._specCache != null) {
            this._specCache.release();
        }
        super.finalize();
    }

    public void setParameter(String name, String value) {
        if (DEFAULT_SPECIFICATION.equals(name)) {
            DelaySourceDescriptor source = new DelaySourceDescriptor();
            source.setSystemID(value);
            this.setSource(source);
            this._defaultSpecificationID = value;
        } else if ("templatePathPattern".equals(name)) {
            if (StringUtil.hasValue(value)) {
                if (this._templatePathPatterns == null) {
                    this._templatePathPatterns = new LinkedList();
                }
                PathPattern pathPattern = new PathPattern(Pattern.compile(value), true);
                this._templatePathPatterns.add(0, pathPattern);
            }
        } else if ("notTemplatePathPattern".equals(name)) {
            if (StringUtil.hasValue(value)) {
                if (this._templatePathPatterns == null) {
                    this._templatePathPatterns = new LinkedList();
                }
                PathPattern pathPattern = new PathPattern(Pattern.compile(value), false);
                this._templatePathPatterns.add(0, pathPattern);
            }
        } else if (PAGE_CLASS.equals(name)) {
            Class pageClass;
            if (StringUtil.hasValue(value) && (class$org$seasar$mayaa$engine$Page == null ? (class$org$seasar$mayaa$engine$Page = EngineImpl.class$("org.seasar.mayaa.engine.Page")) : class$org$seasar$mayaa$engine$Page).isAssignableFrom(pageClass = ObjectUtil.loadClass(value))) {
                this._pageClass = pageClass;
            }
        } else if (TEMPLATE_CLASS.equals(name)) {
            Class templateClass;
            if (StringUtil.hasValue(value) && (class$org$seasar$mayaa$engine$Template == null ? (class$org$seasar$mayaa$engine$Template = EngineImpl.class$("org.seasar.mayaa.engine.Template")) : class$org$seasar$mayaa$engine$Template).isAssignableFrom(templateClass = ObjectUtil.loadClass(value))) {
                this._templateClass = templateClass;
            }
        } else if (PAGE_SERIALIZE.equals(name)) {
            this.setSpecificationSerialize(Boolean.valueOf(value));
        } else if (SURVIVE_LIMIT.equals(name)) {
            this._surviveLimit = Integer.parseInt(value);
        } else if (FORWARD_LIMIT.equals(name)) {
            this._forwardLimit = Integer.parseInt(value);
        } else if (REQUESTED_SUFFIX_ENABLED.equals(name)) {
            this._requestedSuffixEnabled = Boolean.valueOf(value);
        } else if (DUMP_ENABLED.equals(name)) {
            this._dumpEnabled = Boolean.valueOf(value);
        }
        super.setParameter(name, value);
    }

    public String getParameter(String name) {
        if (DEFAULT_SPECIFICATION.equals(name)) {
            return this._defaultSpecificationID;
        }
        if ("templatePathPattern".equals(name)) {
            if (this._templatePathPatterns == null) {
                return null;
            }
            return this.patternToString(this._templatePathPatterns, true);
        }
        if ("notTemplatePathPattern".equals(name)) {
            if (this._templatePathPatterns == null) {
                return null;
            }
            return this.patternToString(this._templatePathPatterns, false);
        }
        if (PAGE_CLASS.equals(name)) {
            return this._pageClass.getName();
        }
        if (TEMPLATE_CLASS.equals(name)) {
            return this._templateClass.getName();
        }
        if (PAGE_SERIALIZE.equals(name)) {
            return String.valueOf(this.isSpecificationSerialize());
        }
        if (SURVIVE_LIMIT.equals(name)) {
            return String.valueOf(this._surviveLimit);
        }
        if (FORWARD_LIMIT.equals(name)) {
            return String.valueOf(this._forwardLimit);
        }
        if (REQUESTED_SUFFIX_ENABLED.equals(name)) {
            return String.valueOf(this._requestedSuffixEnabled);
        }
        if (DUMP_ENABLED.equals(name)) {
            return String.valueOf(this._dumpEnabled);
        }
        return super.getParameter(name);
    }

    private String patternToString(List patterns, boolean result) {
        StringBuffer sb = new StringBuffer();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            PathPattern pathPattern = (PathPattern)it.next();
            if (pathPattern.isTemplate() != result) continue;
            sb.append(pathPattern.getPattern());
            sb.append("|");
        }
        return sb.toString();
    }

    protected Class getPageClass() {
        return this._pageClass;
    }

    protected Class getTemplateClass() {
        return this._templateClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PathPattern {
        private Pattern _pattern;
        private boolean _result;

        public PathPattern(Pattern pattern, boolean result) {
            this._pattern = pattern;
            this._result = result;
        }

        public boolean matches(String path) {
            return this._pattern.matcher(path).matches();
        }

        public boolean isTemplate() {
            return this._result;
        }

        public String getPattern() {
            return this._pattern.pattern();
        }
    }

    private static interface SpecificationGenerator {
        public Class getInstantiator(SourceDescriptor var1);

        public void initialize(Specification var1);
    }
}

