/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.seasar.mayaa.impl.cycle.script.ScriptBlock;
import org.seasar.mayaa.impl.cycle.script.UnbalancedBraceException;
import org.seasar.mayaa.impl.util.StringUtil;

public class ScriptBlockIterator
implements Iterator {
    private String _text;
    private String _blockSign;
    private int _offset;
    private boolean _onTemplate = true;

    public ScriptBlockIterator(String text, String blockSign, boolean onTemplate) {
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(blockSign)) {
            throw new IllegalArgumentException();
        }
        this._text = text;
        this._blockSign = blockSign;
        this._offset = 0;
        this._onTemplate = onTemplate;
    }

    public boolean hasNext() {
        return this._offset < this._text.length();
    }

    protected int scanBlockCloseOffset(int start) {
        char c = this._text.charAt(start);
        if (c != '{') {
            throw new IllegalArgumentException();
        }
        boolean inBlockComment = false;
        boolean inLineComment = false;
        boolean inString = false;
        char stringBeginQuote = '\u0000';
        boolean inEscapeSequence = false;
        int depth = 0;
        for (int i = start; i < this._text.length(); ++i) {
            c = this._text.charAt(i);
            if (inBlockComment) {
                if (c != '/' || this._text.charAt(i - 1) != '*') continue;
                inBlockComment = false;
            } else if (inLineComment) {
                if (c != '\n' && c != '\r') continue;
                inLineComment = false;
            } else {
                if (inEscapeSequence) {
                    inEscapeSequence = false;
                    continue;
                }
                if (inString && stringBeginQuote == c) {
                    inString = false;
                    continue;
                }
            }
            if (!inString) {
                if (c == '/') {
                    if (i <= 0 || this._text.charAt(i - 1) != '/') continue;
                    inLineComment = true;
                    continue;
                }
                if (c == '*') {
                    if (i <= 0 || this._text.charAt(i - 1) != '/') continue;
                    inBlockComment = true;
                    continue;
                }
                if (c == '{') {
                    ++depth;
                    continue;
                }
                if (c == '}') {
                    if (--depth == 0) {
                        return i;
                    }
                    if (depth >= 0) continue;
                    throw new UnbalancedBraceException(this._text, i);
                }
                if (c != '\'' && c != '\"') continue;
                inString = true;
                stringBeginQuote = c;
                continue;
            }
            if (c != '\\') continue;
            inEscapeSequence = true;
        }
        return -1;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String blockStart = this._blockSign + "{";
        int sign = this._text.indexOf(blockStart, this._offset);
        if (sign != -1) {
            if (this._offset == sign) {
                int close = this.scanBlockCloseOffset(this._offset + this._blockSign.length());
                if (close == -1) {
                    throw new UnbalancedBraceException(this._text, this._text.length());
                }
                String text = this._text.substring(this._offset + blockStart.length(), close);
                this._offset = close + 1;
                if (this._onTemplate) {
                    text = StringUtil.resolveEntity(text);
                }
                return new ScriptBlock(text, false, this._blockSign);
            }
            String lastLiteralBlock = this._text.substring(this._offset, sign);
            this._offset = sign;
            return new ScriptBlock(lastLiteralBlock, true, this._blockSign);
        }
        String lastLiteralBlock = this._text.substring(this._offset);
        this._offset = this._text.length();
        return new ScriptBlock(lastLiteralBlock, true, this._blockSign);
    }

    protected int getOffset() {
        return this._offset;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

