/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script;

import org.seasar.mayaa.impl.cycle.script.AbstractCompiledScript;
import org.seasar.mayaa.impl.cycle.script.ReadOnlyScriptBlockException;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public abstract class AbstractSourceCompiledScript
extends AbstractCompiledScript {
    private SourceDescriptor _source;
    private String _encoding;

    public AbstractSourceCompiledScript(SourceDescriptor source, String encoding) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this._source = source;
        this._encoding = encoding;
    }

    protected SourceDescriptor getSource() {
        return this._source;
    }

    protected String getEncoding() {
        if (StringUtil.isEmpty(this._encoding)) {
            return System.getProperty("file.encoding", "UTF-8");
        }
        return this._encoding;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void assignValue(Object value) {
        throw new ReadOnlyScriptBlockException(this.toString());
    }

    public String getScriptText() {
        return this._source.getSystemID();
    }
}

