/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.scope;

import java.util.Iterator;
import java.util.Locale;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.scope.AbstractWritableAttributeScope;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public abstract class AbstractRequestScope
extends AbstractWritableAttributeScope
implements RequestScope,
CONST_IMPL {
    private String _pageName;
    private String _requestedSuffix;
    private String _extension;
    private String _mimeType;

    public void parsePath(String path) {
        String suffixSeparator = EngineUtil.getEngineSetting("suffixSeparator", "$");
        String[] parsed = StringUtil.parsePath(path, suffixSeparator);
        this._pageName = parsed[0];
        this._requestedSuffix = parsed[1];
        this._extension = parsed[2];
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        ApplicationScope application = cycle.getApplicationScope();
        this._mimeType = application.getMimeType(path);
    }

    public void setForwardPath(String relativeUrlPath) {
        if (StringUtil.isEmpty(relativeUrlPath)) {
            throw new IllegalArgumentException();
        }
        this.parsePath(relativeUrlPath);
    }

    public String getScopeName() {
        return "request";
    }

    public String getPageName() {
        if (this._pageName == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._pageName;
    }

    public String getRequestedSuffix() {
        if (this._requestedSuffix == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._requestedSuffix;
    }

    public String getExtension() {
        if (this._extension == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._extension;
    }

    public String getMimeType() {
        if (this._mimeType == null) {
            this.parsePath(this.getRequestedPath());
        }
        return this._mimeType;
    }

    public abstract /* synthetic */ AttributeScope getHeaderValues();

    public abstract /* synthetic */ AttributeScope getParamValues();

    public abstract /* synthetic */ Locale[] getLocales();

    public abstract /* synthetic */ String getRequestedPath();

    public abstract /* synthetic */ String getContextPath();

    public abstract /* synthetic */ void removeAttribute(String var1);

    public abstract /* synthetic */ void setAttribute(String var1, Object var2);

    public abstract /* synthetic */ Object getAttribute(String var1);

    public abstract /* synthetic */ boolean hasAttribute(String var1);

    public abstract /* synthetic */ Iterator iterateAttributeNames();

    public abstract /* synthetic */ Object getUnderlyingContext();

    public abstract /* synthetic */ void setUnderlyingContext(Object var1);
}

