/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.seasar.mayaa.cycle.CycleWriter;

public class CycleWriterImpl
extends CycleWriter {
    private CycleWriter _enclosingWriter;
    private CharArrayWriter _buffer;
    private boolean _flushed;

    public CycleWriterImpl(CycleWriter enclosingWriter) {
        this._enclosingWriter = enclosingWriter;
        this._buffer = new CharArrayWriter();
    }

    public CycleWriter getEnclosingWriter() {
        return this._enclosingWriter;
    }

    public void clearBuffer() {
        this._buffer.reset();
    }

    public String getString() {
        return this._buffer.toString();
    }

    public boolean isDirty() {
        return this._flushed || this._buffer.size() > 0;
    }

    public void writeOut(Writer writer) throws IOException {
        if (writer == null) {
            return;
        }
        writer.write(this._buffer.toCharArray());
        this._buffer.reset();
        this._flushed = true;
    }

    public void write(char[] cbuf, int off, int len) {
        if (len == 0) {
            return;
        }
        this._buffer.write(cbuf, off, len);
    }

    public void flush() throws IOException {
        this.writeOut(this._enclosingWriter);
    }

    public void close() {
    }
}

