/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.mayaa.cycle.CycleLocalInstantiator;

public class CycleThreadLocalFactory {
    private static ThreadLocal _cycleLocalVariables = new ThreadLocal();
    private static Map _instantiators = new HashMap();

    private CycleThreadLocalFactory() {
        throw new UnsupportedOperationException();
    }

    public static void cycleLocalInitialize() {
        _cycleLocalVariables.set(new HashMap());
    }

    public static void cycleLocalFinalize() {
        Map map = (Map)_cycleLocalVariables.get();
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                Object key = entry.getKey();
                if (key instanceof InstanceKey) {
                    key = ((InstanceKey)key).getKey();
                }
                CycleLocalInstantiator instantiator = (CycleLocalInstantiator)_instantiators.get(key);
                instantiator.destroy(value);
            }
        }
        _cycleLocalVariables.set(null);
    }

    public static void registFactory(String key, CycleLocalInstantiator instantiator) {
        _instantiators.put(key, instantiator);
    }

    public static void clearLocalVariable(Object key) {
        Map map;
        Object instance;
        if (_cycleLocalVariables.get() == null) {
            CycleThreadLocalFactory.cycleLocalInitialize();
        }
        if ((instance = (map = (Map)_cycleLocalVariables.get()).get(key)) != null) {
            String strKey = key instanceof InstanceKey ? ((InstanceKey)key).getKey() : key.toString();
            CycleLocalInstantiator instantiator = (CycleLocalInstantiator)_instantiators.get(strKey);
            if (instantiator != null) {
                instantiator.destroy(instance);
            }
            map.put(key, null);
        }
    }

    public static Object get(Object key, Object[] params) {
        Map localVariables;
        Object result;
        if (_cycleLocalVariables.get() == null) {
            CycleThreadLocalFactory.cycleLocalInitialize();
        }
        if ((result = (localVariables = (Map)_cycleLocalVariables.get()).get(key)) == null) {
            Object owner;
            String strKey;
            if (key instanceof InstanceKey) {
                strKey = ((InstanceKey)key).getKey();
                owner = ((InstanceKey)key).getOwner();
            } else {
                strKey = key.toString();
                owner = null;
            }
            CycleLocalInstantiator instantiator = (CycleLocalInstantiator)_instantiators.get(strKey);
            if (instantiator == null) {
                throw new IllegalStateException("inistantiator unknown. key = " + key);
            }
            result = owner == null ? instantiator.create(params) : instantiator.create(owner, params);
            localVariables.put(key, result);
        }
        return result;
    }

    public static void set(Object key, Object value) {
        Map localVariables;
        Object existValue;
        if (_cycleLocalVariables.get() == null) {
            CycleThreadLocalFactory.cycleLocalInitialize();
        }
        if ((existValue = (localVariables = (Map)_cycleLocalVariables.get()).get(key)) != null) {
            CycleThreadLocalFactory.clearLocalVariable(key);
        }
        localVariables.put(key, value);
    }

    public static class InstanceKey {
        private String _key;
        private Object _owner;

        public InstanceKey(String key, Object owner) {
            this._key = key;
            this._owner = owner;
        }

        public String getKey() {
            return this._key;
        }

        public Object getOwner() {
            return this._owner;
        }

        public int hashCode() {
            return this._key.hashCode() + this._owner.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof InstanceKey) {
                InstanceKey other = (InstanceKey)obj;
                return other._owner == this._owner && other._key.equals(this._key);
            }
            return false;
        }
    }
}

