/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.scanner.SourceAlias;
import org.seasar.mayaa.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;
import org.seasar.mayaa.source.SourceDescriptor;

public class JarSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private static final long serialVersionUID = 6023587474701789138L;
    private String _root;
    private SourceDescriptor _descriptor;
    private Set _folderFilters = new HashSet();
    private Set _ignores = new HashSet();
    private Set _extensions = new HashSet();

    public Iterator scan() {
        if (this._descriptor == null) {
            return NullIterator.getInstance();
        }
        HashSet aliases = new HashSet();
        this.scanSource(this._descriptor, aliases);
        return new AliasToSourceIterator(aliases.iterator());
    }

    protected String getJarName(String systemID) {
        if (StringUtil.hasValue(systemID)) {
            int pos = systemID.lastIndexOf("/");
            if (pos != -1) {
                return systemID.substring(pos + 1);
            }
            return systemID;
        }
        return null;
    }

    protected void scanSource(SourceDescriptor source, Set aliases) {
        if (source == null || !source.exists()) {
            throw new IllegalArgumentException();
        }
        String jarName = this.getJarName(source.getSystemID());
        if (StringUtil.hasValue(jarName)) {
            String jarPath = (this._root != null ? this._root : "") + source.getSystemID();
            Date timestamp = source.getTimestamp();
            InputStream stream = source.getInputStream();
            try {
                JarInputStream jar = new JarInputStream(stream);
                this.addAliases(jar, jarPath, timestamp, aliases);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtil.close(stream);
            }
        }
    }

    protected void addAliases(JarInputStream jar, String jarPath, Date timestamp, Set aliases) throws IOException {
        JarEntry entry;
        while ((entry = jar.getNextJarEntry()) != null) {
            String entryName = entry.getName();
            if (!this.nameStartsWith(entryName) || !this.extensionEndsWith(entryName)) continue;
            aliases.add(new SourceAlias(jarPath, entryName, timestamp));
        }
    }

    protected boolean nameStartsWith(String entryName) {
        if (this._folderFilters.size() > 0) {
            boolean ok = false;
            Iterator it = this._folderFilters.iterator();
            while (it.hasNext()) {
                String filter = (String)it.next();
                if (!entryName.startsWith(filter)) continue;
                ok = true;
            }
            if (!ok) {
                return false;
            }
        }
        if (this._ignores.size() > 0) {
            Iterator it = this._ignores.iterator();
            while (it.hasNext()) {
                String filter = (String)it.next();
                if (!entryName.startsWith(filter)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean extensionEndsWith(String entryName) {
        if (this._extensions.size() == 0) {
            return true;
        }
        Iterator it = this._extensions.iterator();
        while (it.hasNext()) {
            String filter = (String)it.next();
            if (!entryName.endsWith(filter)) continue;
            return true;
        }
        return false;
    }

    public void setDescriptor(SourceDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    protected String getFileName(String path) {
        int separatorIndex = path.lastIndexOf(47);
        if (separatorIndex > 0) {
            path = path.substring(separatorIndex + 1);
        } else if (File.separatorChar != '/' && (separatorIndex = path.lastIndexOf(File.separatorChar)) > 0) {
            path = path.substring(separatorIndex + 1);
        }
        return path;
    }

    public void setParameter(String name, String value) {
        if ("root".equals(name)) {
            this._root = value;
        } else if ("folder".equals(name)) {
            this._folderFilters.add(value);
        } else if ("ignore".equals(name)) {
            this._ignores.add(value);
        } else if ("extension".equals(name)) {
            this._extensions.add(value);
        }
        super.setParameter(name, value);
    }

    protected class AliasToSourceIterator
    implements Iterator {
        private Iterator _it;

        public AliasToSourceIterator(Iterator it) {
            if (it == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            SourceAlias alias = (SourceAlias)this._it.next();
            ClassLoaderSourceDescriptor source = new ClassLoaderSourceDescriptor();
            source.setSystemID(alias.getSystemID());
            source.setParameter(SourceAlias.ALIAS, alias.getAlias());
            source.setTimestamp(alias.getTimestamp());
            return source;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

