/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.mld;

import org.seasar.mayaa.ParameterAware;
import org.seasar.mayaa.impl.builder.library.LibraryDefinitionImpl;
import org.seasar.mayaa.impl.builder.library.mld.ConverterTagHandler;
import org.seasar.mayaa.impl.builder.library.mld.ProcessorTagHandler;
import org.seasar.mayaa.impl.builder.library.mld.PropertySetTagHandler;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.factory.AbstractParameterAwareTagHandler;
import org.seasar.mayaa.impl.util.StringUtil;
import org.xml.sax.Attributes;

public class LibraryTagHandler
extends AbstractParameterAwareTagHandler {
    private LibraryDefinitionImpl _libraryDefinition;

    public LibraryTagHandler() {
        super("library");
        this.putHandler(new ConverterTagHandler(this, this));
        this.putHandler(new ProcessorTagHandler(this));
        this.putHandler(new PropertySetTagHandler("propertySet", this, this));
    }

    protected void start(Attributes attributes, String systemID, int lineNumber) {
        String uri = attributes.getValue("uri");
        this._libraryDefinition = new LibraryDefinitionImpl();
        this._libraryDefinition.setNamespaceURI(SpecificationUtil.createURI(uri));
        this._libraryDefinition.setSystemID(StringUtil.removeFileProtocol(systemID));
        this._libraryDefinition.setLineNumber(lineNumber);
    }

    public LibraryDefinitionImpl getLibraryDefinition() {
        if (this._libraryDefinition == null) {
            throw new IllegalStateException();
        }
        return this._libraryDefinition;
    }

    public ParameterAware getParameterAware() {
        return this.getLibraryDefinition();
    }
}

