/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.builder.TemplateBuilder;
import org.seasar.mayaa.builder.injection.InjectionChain;
import org.seasar.mayaa.builder.injection.InjectionResolver;
import org.seasar.mayaa.builder.library.LibraryManager;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.processor.OptimizableProcessor;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.builder.ProcessorNotInjectedException;
import org.seasar.mayaa.impl.builder.SpecificationBuilderImpl;
import org.seasar.mayaa.impl.builder.SpecificationNodeHandler;
import org.seasar.mayaa.impl.builder.TemplateNodeHandler;
import org.seasar.mayaa.impl.builder.TemplateNodeNotResolvedException;
import org.seasar.mayaa.impl.builder.injection.DefaultInjectionChain;
import org.seasar.mayaa.impl.builder.parser.AdditionalHandler;
import org.seasar.mayaa.impl.builder.parser.TemplateParser;
import org.seasar.mayaa.impl.builder.parser.TemplateScanner;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.AttributeProcessor;
import org.seasar.mayaa.impl.engine.processor.CharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.DoBodyProcessor;
import org.seasar.mayaa.impl.engine.processor.ElementProcessor;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.xml.XMLReaderPool;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TemplateBuilderImpl
extends SpecificationBuilderImpl
implements TemplateBuilder,
CONST_IMPL {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$TemplateBuilderImpl == null ? (class$org$seasar$mayaa$impl$builder$TemplateBuilderImpl = TemplateBuilderImpl.class$("org.seasar.mayaa.impl.builder.TemplateBuilderImpl")) : class$org$seasar$mayaa$impl$builder$TemplateBuilderImpl));
    private static final long serialVersionUID = -1031702086020145692L;
    private List _resolvers = new ArrayList();
    private List _unmodifiableResolvers = Collections.unmodifiableList(this._resolvers);
    private HtmlReaderPool _htmlReaderPool = new HtmlReaderPool();
    private InjectionChain _chain = new DefaultInjectionChain();
    private boolean _outputTemplateWhitespace = true;
    private boolean _optimize = true;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$TemplateBuilderImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInjectionResolver(InjectionResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        List list = this._resolvers;
        synchronized (list) {
            this._resolvers.add(resolver);
        }
    }

    protected List getInjectionResolvers() {
        return this._unmodifiableResolvers;
    }

    protected boolean isHTML(String mimeType) {
        return mimeType != null && mimeType.indexOf("html") != -1;
    }

    protected XMLReaderPool getXMLReaderPool(String systemID) {
        ApplicationScope application = CycleUtil.getServiceCycle().getApplicationScope();
        String mimeType = application.getMimeType(systemID);
        if (this.isHTML(mimeType)) {
            return this._htmlReaderPool;
        }
        return super.getXMLReaderPool(systemID);
    }

    protected SpecificationNodeHandler createContentHandler(Specification specification) {
        if (!(specification instanceof Template)) {
            throw new IllegalArgumentException();
        }
        TemplateNodeHandler handler = new TemplateNodeHandler((Template)specification);
        handler.setOutputTemplateWhitespace(this._outputTemplateWhitespace);
        return handler;
    }

    protected String getPublicID() {
        return CONST_IMPL.URI_MAYAA + "/template";
    }

    protected void afterBuild(Specification specification) {
        if (!(specification instanceof Template)) {
            throw new IllegalArgumentException();
        }
        LOG.debug((Object)("built node tree from template. " + specification.getSystemID()));
        this.doInjection((Template)specification);
        if (this._optimize) {
            this.nodeOptimize((Template)specification);
        }
        LOG.debug((Object)("built processor tree from node tree. " + specification.getSystemID()));
    }

    protected void nodeOptimize(Template template) {
        Template idGenerator = template;
        ArrayList children = new ArrayList();
        AbsoluteCompareList usingNodes = new AbsoluteCompareList();
        this.walkTreeOptimizeNode(idGenerator, template, children, usingNodes);
        SpecificationNode mayaaNode = SpecificationUtil.getMayaaNode(template);
        this.breakRelationship(template);
        idGenerator.resetSequenceID(1);
        this.walkTreeNodeChainModify(idGenerator, template, children);
        template.addChildNode(mayaaNode);
    }

    protected void breakRelationship(NodeTreeWalker parent) {
        for (int i = 0; i < parent.getChildNodeSize(); ++i) {
            this.breakRelationship(parent.getChildNode(i));
        }
        parent.clearChildNodes();
    }

    protected void walkTreeNodeChainModify(SequenceIDGenerator idGenerator, NodeTreeWalker parent, List children) {
        parent.clearChildNodes();
        for (int i = 0; i < children.size(); ++i) {
            NodeAndChildren nodeAndChildren = (NodeAndChildren)children.get(i);
            SpecificationNode node = nodeAndChildren._originalNode;
            node.setSequenceID(idGenerator.nextSequenceID());
            node.setParentNode(parent);
            parent.addChildNode(node);
            this.walkTreeNodeChainModify(idGenerator, node, nodeAndChildren._list);
        }
    }

    protected void walkTreeOptimizeNode(SequenceIDGenerator idGenerator, ProcessorTreeWalker parent, List children, List usingNodes) {
        for (int i = 0; i < parent.getChildProcessorSize(); ++i) {
            ProcessorTreeWalker walker = parent.getChildProcessor(i);
            if (!(walker instanceof TemplateProcessor)) continue;
            TemplateProcessor processor = (TemplateProcessor)walker;
            SpecificationNode node = processor.getOriginalNode();
            if (processor instanceof LiteralCharactersProcessor) {
                node = SpecificationUtil.createSpecificationNode(CONST_IMPL.QM_CHARACTERS, node.getSystemID(), node.getLineNumber(), true, idGenerator.nextSequenceID());
                processor.setOriginalNode(node);
                SpecificationNode injectedNode = processor.getInjectedNode();
                injectedNode = SpecificationUtil.createSpecificationNode(CONST_IMPL.QM_LITERALS, injectedNode.getSystemID(), injectedNode.getLineNumber(), false, 1);
                processor.setInjectedNode(injectedNode);
            } else if (!(processor instanceof ElementProcessor) && !(processor instanceof AttributeProcessor)) {
                processor.getOriginalNode().setParentSpace(null);
                processor.getInjectedNode().setParentSpace(null);
            }
            NodeAndChildren nodeAndChildren = new NodeAndChildren(node);
            children.add(nodeAndChildren);
            usingNodes.add(node);
            if (processor.getChildProcessorSize() <= 0) continue;
            this.walkTreeOptimizeNode(idGenerator, processor, nodeAndChildren._list, usingNodes);
        }
    }

    protected void saveToCycle(NodeTreeWalker originalNode, NodeTreeWalker injectedNode) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(originalNode);
        cycle.setInjectedNode(injectedNode);
    }

    protected TemplateProcessor findConnectPoint(TemplateProcessor processor) {
        if (processor instanceof ElementProcessor && ((ElementProcessor)processor).isDuplicated()) {
            return this.findConnectPoint((TemplateProcessor)processor.getChildProcessor(0));
        }
        for (int i = 0; i < processor.getChildProcessorSize(); ++i) {
            ProcessorTreeWalker child = processor.getChildProcessor(i);
            if (child instanceof CharactersProcessor) {
                CharactersProcessor charsProc = (CharactersProcessor)child;
                CompiledScript script = charsProc.getText().getValue();
                if (script.isLiteral()) {
                    String value = script.getScriptText();
                    if (!StringUtil.hasValue(value.trim())) continue;
                    return null;
                }
                return null;
            }
            if (child instanceof AttributeProcessor) continue;
            return null;
        }
        return processor;
    }

    protected TemplateProcessor createProcessor(SpecificationNode original, SpecificationNode injected) {
        QName name = injected.getQName();
        LibraryManager libraryManager = ProviderUtil.getLibraryManager();
        ProcessorDefinition def = libraryManager.getProcessorDefinition(name);
        if (def != null) {
            TemplateProcessor proc = def.createTemplateProcessor(original, injected);
            proc.setOriginalNode(original);
            proc.setInjectedNode(injected);
            return proc;
        }
        return null;
    }

    protected InjectionChain getDefaultInjectionChain() {
        return this._chain;
    }

    protected TemplateProcessor resolveInjectedNode(Template template, Stack stack, SpecificationNode original, SpecificationNode injected, Set divided) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        this.saveToCycle(original, injected);
        TemplateProcessor processor = this.createProcessor(original, injected);
        if (processor == null) {
            PrefixMapping mapping = original.getMappingFromPrefix("", true);
            if (mapping == null) {
                throw new IllegalStateException();
            }
            URI defaultURI = mapping.getNamespaceURI();
            if (defaultURI.equals(injected.getQName().getNamespaceURI())) {
                InjectionChain chain = this.getDefaultInjectionChain();
                SpecificationNode retry = chain.getNode(injected);
                processor = this.createProcessor(original, retry);
            }
            if (processor == null) {
                throw new ProcessorNotInjectedException(injected.toString());
            }
        }
        ProcessorTreeWalker parent = (ProcessorTreeWalker)stack.peek();
        parent.addChildProcessor(processor);
        processor.initialize();
        Iterator it = injected.iterateChildNode();
        if (!it.hasNext()) {
            return processor;
        }
        stack.push(processor);
        while (it.hasNext()) {
            SpecificationNode childNode = (SpecificationNode)it.next();
            this.saveToCycle(original, childNode);
            TemplateProcessor childProcessor = this.resolveInjectedNode(template, stack, original, childNode, divided);
            if (!(childProcessor instanceof DoBodyProcessor)) continue;
            stack.push(childProcessor);
            this.walkParsedTree(template, stack, original, divided);
            stack.pop();
        }
        stack.pop();
        this.saveToCycle(original, injected);
        return this.findConnectPoint(processor);
    }

    protected void optimizeProcessors(SequenceIDGenerator idGenerator, ProcessorTreeWalker parent, List collecter, Set divided) {
        int i;
        ArrayList<ProcessorTreeWalker> expands = new ArrayList<ProcessorTreeWalker>();
        Iterator it = collecter.iterator();
        while (it.hasNext()) {
            ProcessorTreeWalker processor = (ProcessorTreeWalker)it.next();
            if (processor == null) {
                throw new IllegalStateException("processor is null");
            }
            if (processor instanceof OptimizableProcessor && !divided.contains(processor)) {
                ProcessorTreeWalker[] processors = ((OptimizableProcessor)((Object)processor)).divide(idGenerator);
                for (int i2 = 0; i2 < processors.length; ++i2) {
                    expands.add(processors[i2]);
                }
                divided.add(processor);
                continue;
            }
            expands.add(processor);
        }
        ArrayList<ProcessorTreeWalker> packs = new ArrayList<ProcessorTreeWalker>();
        for (i = 0; i < expands.size(); ++i) {
            ProcessorTreeWalker node = (ProcessorTreeWalker)expands.get(i);
            node = this.convertCharactersProcessor(node, idGenerator);
            if (packs.size() > 0 && node instanceof LiteralCharactersProcessor) {
                Object last = packs.get(packs.size() - 1);
                if (last instanceof LiteralCharactersProcessor) {
                    LiteralCharactersProcessor rawLast = (LiteralCharactersProcessor)last;
                    rawLast.setText(rawLast.getText() + ((LiteralCharactersProcessor)node).getText());
                    continue;
                }
                packs.add(node);
                continue;
            }
            packs.add(node);
        }
        for (i = 0; i < packs.size(); ++i) {
            ProcessorTreeWalker child = (ProcessorTreeWalker)packs.get(i);
            child.setParentProcessor(parent);
            parent.addChildProcessor(child);
        }
    }

    protected ProcessorTreeWalker convertCharactersProcessor(ProcessorTreeWalker processor, SequenceIDGenerator idGenerator) {
        CharactersProcessor cnode;
        if (processor instanceof CharactersProcessor && (cnode = (CharactersProcessor)processor).getText() != null && cnode.getText().getValue() != null && cnode.getText().getValue().isLiteral()) {
            LiteralCharactersProcessor literalProcessor = new LiteralCharactersProcessor(cnode.getText().getValue().getScriptText());
            BuilderUtil.characterProcessorCopy(cnode, literalProcessor, idGenerator);
            processor = literalProcessor;
        }
        return processor;
    }

    protected SpecificationNode resolveOriginalNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        if (this._resolvers.size() > 0) {
            InjectionChainImpl first = new InjectionChainImpl(chain);
            return first.getNode(original);
        }
        return chain.getNode(original);
    }

    protected void walkParsedTree(Template template, Stack stack, NodeTreeWalker original, Set divided) {
        ProcessorTreeWalker parent;
        int count;
        if (original == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = original.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode child;
            try {
                child = (SpecificationNode)it.next();
            }
            catch (ConcurrentModificationException e) {
                LOG.error((Object)"original.childNodes \u3092\u30a4\u30c6\u30ec\u30fc\u30c8\u4e2d\u306b\u66f4\u65b0\u3055\u308c\u3066\u3057\u307e\u3063\u305f\u3002", (Throwable)e);
                throw e;
            }
            this.saveToCycle(child, child);
            if (CONST_IMPL.QM_MAYAA.equals(child.getQName())) continue;
            InjectionChain chain = this.getDefaultInjectionChain();
            SpecificationNode injected = this.resolveOriginalNode(child, chain);
            if (injected == null) {
                throw new TemplateNodeNotResolvedException(original.toString());
            }
            this.saveToCycle(child, injected);
            TemplateProcessor processor = this.resolveInjectedNode(template, stack, child, injected, divided);
            if (processor == null) continue;
            stack.push(processor);
            this.walkParsedTree(template, stack, child, divided);
            stack.pop();
        }
        if (this._optimize && (count = (parent = (ProcessorTreeWalker)stack.peek()).getChildProcessorSize()) > 0) {
            ArrayList<ProcessorTreeWalker> childProcessors = new ArrayList<ProcessorTreeWalker>();
            for (int i = 0; i < count; ++i) {
                childProcessors.add(parent.getChildProcessor(i));
            }
            parent.clearChildProcessors();
            this.optimizeProcessors(template, parent, childProcessors, divided);
        }
    }

    public void setParameter(String name, String value) {
        if ("outputTemplateWhitespace".equals(name)) {
            this._outputTemplateWhitespace = ObjectUtil.booleanValue(value, true);
        } else if ("optimize".equals(name)) {
            this._optimize = ObjectUtil.booleanValue(value, true);
        }
        super.setParameter(name, value);
    }

    protected void doInjection(Template template) {
        if (template == null) {
            throw new IllegalArgumentException();
        }
        this.saveToCycle(template, template);
        Stack<Template> stack = new Stack<Template>();
        stack.push(template);
        SpecificationNode mayaa = SpecificationUtil.createSpecificationNode(CONST_IMPL.QM_MAYAA, template.getSystemID(), 0, true, 0);
        template.addChildNode(mayaa);
        HashSet divided = null;
        if (this._optimize) {
            divided = new HashSet();
        }
        this.walkParsedTree(template, stack, template, divided);
        if (!template.equals(stack.peek())) {
            throw new IllegalStateException();
        }
        this.saveToCycle(template, template);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class InjectionChainImpl
    implements InjectionChain {
        private int _index;
        private InjectionChain _external;

        public InjectionChainImpl(InjectionChain external) {
            this._external = external;
        }

        public SpecificationNode getNode(SpecificationNode original) {
            if (original == null) {
                throw new IllegalArgumentException();
            }
            if (this._index < TemplateBuilderImpl.this.getInjectionResolvers().size()) {
                InjectionResolver resolver = (InjectionResolver)TemplateBuilderImpl.this.getInjectionResolvers().get(this._index);
                ++this._index;
                InjectionChain chain = this._index == TemplateBuilderImpl.this.getInjectionResolvers().size() ? this._external : this;
                return resolver.getNode(original, chain);
            }
            throw new IndexOutOfBoundsException();
        }
    }

    protected class HtmlReaderPool
    extends XMLReaderPool {
        private static final long serialVersionUID = -5203349759797583368L;

        protected HtmlReaderPool() {
        }

        protected Object createObject() {
            return new TemplateParser(new TemplateScanner());
        }

        protected boolean validateObject(Object object) {
            return object instanceof TemplateParser;
        }

        public XMLReader borrowXMLReader(ContentHandler handler, boolean namespaces, boolean validation, boolean xmlSchema) {
            XMLReader htmlReader = super.borrowXMLReader(handler, namespaces, validation, xmlSchema);
            if (handler instanceof AdditionalHandler) {
                try {
                    htmlReader.setProperty("org.seasar.mayaa.impl.builder.parser.AdditionalHandler", handler);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
            return htmlReader;
        }
    }

    private static class NodeAndChildren {
        public SpecificationNode _originalNode;
        public List _list = new ArrayList();

        public NodeAndChildren(SpecificationNode originalNode) {
            this._originalNode = originalNode;
        }
    }

    private static class AbsoluteCompareList
    extends ArrayList {
        private static final long serialVersionUID = 1L;

        protected AbsoluteCompareList() {
        }

        public int indexOf(Object elem) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != elem) continue;
                return i;
            }
            return -1;
        }
    }
}

