/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder;

import java.io.InputStream;
import org.seasar.mayaa.builder.SpecificationBuilder;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.SpecificationNodeHandler;
import org.seasar.mayaa.impl.util.IOUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.xml.XMLReaderPool;
import org.seasar.mayaa.source.SourceDescriptor;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SpecificationBuilderImpl
extends ParameterAwareImpl
implements SpecificationBuilder,
CONST_IMPL {
    private static final long serialVersionUID = 7852577574830768959L;
    private boolean _outputMayaaWhitespace = false;

    protected XMLReaderPool getXMLReaderPool(String systemID) {
        return XMLReaderPool.getPool();
    }

    protected SpecificationNodeHandler createContentHandler(Specification specification) {
        SpecificationNodeHandler handler = new SpecificationNodeHandler(specification);
        handler.setOutputMayaaWhitespace(this._outputMayaaWhitespace);
        return handler;
    }

    protected String getPublicID() {
        return CONST_IMPL.URI_MAYAA + "/specification";
    }

    protected void afterBuild(Specification specification) {
    }

    public void build(Specification specification) {
        if (specification == null) {
            throw new IllegalArgumentException();
        }
        SourceDescriptor source = specification.getSource();
        if (source.exists()) {
            SpecificationNodeHandler handler = this.createContentHandler(specification);
            XMLReaderPool pool = this.getXMLReaderPool(source.getSystemID());
            XMLReader xmlReader = pool.borrowXMLReader(handler, true, false, false);
            InputStream stream = source.getInputStream();
            InputSource input = new InputSource(stream);
            input.setPublicId(this.getPublicID());
            input.setSystemId(source.getSystemID());
            try {
                xmlReader.parse(input);
                this.afterBuild(specification);
            }
            catch (Throwable t) {
                specification.kill();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("build failed. " + source.getSystemID(), t);
            }
            finally {
                pool.returnXMLReader(xmlReader);
                IOUtil.close(stream);
            }
        }
    }

    public void setParameter(String name, String value) {
        if ("outputMayaaWhitespace".equals(name)) {
            this._outputMayaaWhitespace = ObjectUtil.booleanValue(value, true);
        }
        super.setParameter(name, value);
    }
}

