/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.seasar.extension.jta.TransactionImpl;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.exception.SNotSupportedException;
import org.seasar.framework.exception.SSystemException;

public final class TransactionManagerImpl
implements TransactionManager {
    private ThreadLocal threadAttachTx_ = new ThreadLocal();

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            throw new SNotSupportedException("ESSR0316", null);
        }
        tx = this.attachTransaction();
        tx.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        tx.commit();
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        try {
            tx.suspend();
        }
        catch (XAException ex) {
            throw new SSystemException("ESSR0363", new Object[]{ex}, (Throwable)ex);
        }
        this.setCurrent(null);
        return tx;
    }

    public void resume(Transaction resumeTx) throws InvalidTransactionException, IllegalStateException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            throw new SIllegalStateException("ESSR0317", null);
        }
        this.setCurrent((TransactionImpl)resumeTx);
        try {
            ((TransactionImpl)resumeTx).resume();
        }
        catch (XAException ex) {
            throw new SSystemException("ESSR0364", new Object[]{ex}, (Throwable)ex);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        tx.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
    }

    public int getStatus() {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.getCurrent();
    }

    private TransactionImpl getCurrent() {
        TransactionImpl tx = (TransactionImpl)this.threadAttachTx_.get();
        if (tx != null && tx.getStatus() == 6) {
            return null;
        }
        return tx;
    }

    private void setCurrent(TransactionImpl current) {
        this.threadAttachTx_.set(current);
    }

    private TransactionImpl attachTransaction() {
        TransactionImpl tx = (TransactionImpl)this.threadAttachTx_.get();
        if (tx == null) {
            tx = new TransactionImpl();
            this.setCurrent(tx);
        }
        return tx;
    }
}

