/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.EnumerationIterator;
import org.seasar.framework.util.MethodUtil;

public class ClassLoaderUtil {
    private static Method findLoadedClassMethod = ClassUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", new Class[]{String.class});

    public static ClassLoader getClassLoader(Class targetClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader targetClassLoader = targetClass.getClassLoader();
        ClassLoader thisClassLoader = ClassLoaderUtil.class.getClassLoader();
        if (targetClassLoader != null && thisClassLoader != null) {
            if (ClassLoaderUtil.isAncestor(thisClassLoader, targetClassLoader)) {
                return thisClassLoader;
            }
            return targetClassLoader;
        }
        if (targetClassLoader != null) {
            return targetClassLoader;
        }
        if (thisClassLoader != null) {
            return thisClassLoader;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader != null) {
            return systemClassLoader;
        }
        throw new IllegalStateException(MessageFormatter.getMessage("ESSR0001", new Object[]{"ClassLoader"}));
    }

    public static Iterator getResources(String name) {
        return ClassLoaderUtil.getResources(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Iterator getResources(Class targetClass, String name) {
        return ClassLoaderUtil.getResources(ClassLoaderUtil.getClassLoader(targetClass), name);
    }

    public static Iterator getResources(ClassLoader loader, String name) {
        try {
            Enumeration<URL> e = loader.getResources(name);
            return new EnumerationIterator(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static boolean isAncestor(ClassLoader cl, ClassLoader other) {
        while (cl != null) {
            if (cl == other) {
                return true;
            }
            cl = cl.getParent();
        }
        return false;
    }

    public static Class findLoadedClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            Class clazz = (Class)MethodUtil.invoke(findLoadedClassMethod, loader, new Object[]{className});
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    static {
        findLoadedClassMethod.setAccessible(true);
    }
}

