/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Constructor;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ClassUnmatchRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.ConstructorAssembler;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.IllegalConstructorRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;

public abstract class AbstractConstructorAssembler
extends AbstractAssembler
implements ConstructorAssembler {
    public AbstractConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    public Object assemble() {
        if (this.getComponentDef().getExpression() != null) {
            return this.assembleExpression();
        }
        if (this.getComponentDef().getArgDefSize() > 0) {
            return this.assembleManual();
        }
        return this.doAssemble();
    }

    protected abstract Object doAssemble();

    protected Object assembleExpression() {
        ComponentDef cd = this.getComponentDef();
        S2Container container = cd.getContainer();
        Expression expression = cd.getExpression();
        Object component = expression.evaluate(container, null);
        Class componentClass = cd.getComponentClass();
        if (componentClass != null && !componentClass.isInstance(component)) {
            throw new ClassUnmatchRuntimeException(componentClass, component != null ? component.getClass() : null);
        }
        return component;
    }

    protected Object assembleManual() {
        Object[] args = new Object[this.getComponentDef().getArgDefSize()];
        for (int i = 0; i < args.length; ++i) {
            try {
                args[i] = this.getComponentDef().getArgDef(i).getValue();
                continue;
            }
            catch (ComponentNotFoundRuntimeException cause) {
                throw new IllegalConstructorRuntimeException(this.getComponentDef().getComponentClass(), (Throwable)cause);
            }
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.getComponentDef().getConcreteClass());
        return beanDesc.newInstance(args);
    }

    protected Object assembleDefault() {
        Class clazz = this.getComponentDef().getConcreteClass();
        Constructor constructor = ClassUtil.getConstructor(clazz, null);
        return ConstructorUtil.newInstance(constructor, null);
    }
}

