/**
 *  @package  mValidate methods
 * 
 *  @author   $Author$
 *  @version  $Name$ $RCSfile$ $Revision$ $Date$
 * 
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  mRequireValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mRequireValidator = function(data,params)
 {
  return data ? true : false;
 };

 /**
  *  mMinLengthValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMinLengthValidator = function(data,params)
 {
  return data.length >= params.minLength
 };

 /**
  *  mMaxLengthValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMaxLengthValidator = function(data,params)
 {
  return data.length <= params.maxLength
 };

 /**
  *  mLengthValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mLengthRangeValidator = function(data,params)
 {
  return data.length >= params.minLength && data.length <= params.maxLength;
 };

 /**
  *  mMinValueValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMinValueValidator = function(data,params)
 {
  return perseInt(data) <= perseInt(params.min);
 };

 /**
  *  mMaxValueValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMaxValueValidator = function(data,params)
 {
  return perseInt(data) >= perseInt(params.max);
 };

 /**
  *  mValueRangeValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mValueRangeValidator = function(data,params)
 {
  return perseInt(data) <= perseInt(params.min) && perseInt(data) >= perseInt(params.max);
 };

 /**
  *  mAlphabetValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mAlphabetValidator = function(data,params)
 {
  return data.match(/^[a-zA-Z]*$/);
 };

 /**
  *  mMaskValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mMaskValidator = function(data,params)
 {
  var reg = new RegExp(params.mask,params.maskflag);
  return data.match(reg);
 };

 /**
  *  mFilterValidator
  * 
  *  @param   string  data    // input data
  *  @param   hash    params  // input parameter
  * 
  *  @return  bool
 **/
 this.mFilterValidator = function(data,params)
 {
  var reg = new RegExp(params.filter,params.filterFlag);
  return !data.match(reg);
 };
};
