/**
 *  mController
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: mController.js,v $ $Revision: 1.3 $ $Date: 2006/11/15 12:41:21 $
 * 
 *  @requires DomUtils
 *  @requires mUtils
**/
var mController =
{
 /**
  *  render object
  * 
  *  @see     mRender
  *  @private
 **/
 _render : {},

 /**
  *  request object
  * 
  *  @see     mRequest
  *  @private
 **/
 _request : {},

 /**
  *  model objects
  * 
  *  @see     mModel
  *  @private
 **/
 _models : {},

 /**
  *  action objects
  * 
  *  @see     mAction
  *  @private
 **/
 _actions : {},

 /**
  *  active action name
  * 
  *  @see     mController#procedureAction
  *  @private
 **/
 _actionName : null,

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
 },

 /**
  *  procedureAction
  * 
  *  @param   string  actionName  // target action name
  * 
  *  @return  void
 **/
 procedureAction : function(actionName)
 {
  mUtils.logger.resetLog();
  mController._actionName = actionName;
  mController._loadConfig();
 },

 /**
  *  _loadConfig
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_loadLanguage
  *  @private
 **/
 _loadConfig : function()
 {
  mUtils.config.loadCustomConfig(this._actionName,this._loadLanguage,null);
 },

 /**
  *  _loadLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_loadFrame
  *  @private
 **/
 _loadLanguage : function()
 {
  mUtils.language.loadCustomLanguage(mController._actionName,mController._loadFrame,null);
 },

 /**
  *  _loadFrame
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_setupFrame
  *  @private
 **/
 _loadFrame : function()
 {
  var config = mUtils.config;
  mUtils.loadFile(config.getConfig('renderPath'));
  mUtils.loadFile(config.getConfig('requestPath'));
  mUtils.waitResponse(mController,{
        '_render'  : config.getConfig('renderPath'),
        '_request' : config.getConfig('requestPath')
        },mController._setupFrame,null)
 },

 /**
  *  _setupFrame
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_loadModel
  *  @private
 **/
 _setupFrame : function()
 {
  mController._request.init();
  mController._render.init();
  mController._loadModel();
 },

 /**
  *  _loadModel
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_setupModel
  *  @private
 **/
 _loadModel : function()
 {
  var file = mUtils.config.getConfig('modelPath') + this._actionName + 'Model.js';
  var obj  = {};
  obj[this._actionName] = file;
  mUtils.loadFile(file);
  mUtils.waitResponse(this._models,obj,this._loadAction,null);
 },

 /**
  *  _loadAction
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_setupAction
  *  @private
 **/
 _loadAction : function()
 {
  var file = mUtils.config.getConfig('actionPath') + mController._actionName + 'Action.js';
  var obj  = new Object();
  obj[mController._actionName] = file;
  mUtils.loadFile(file);
  mUtils.waitResponse(mController._actions,obj,mController._setupAction,null);
 },

 /**
  *  _setupAction
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mController#_executeAction
  *  @private
 **/
 _setupAction : function()
 {
  var actionName = mController._actionName;
  var action = mController._actions[actionName];
  try
  {
   action.init(mController._models[actionName]);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action initialize',actionName + mUtils.language.getLanguage('mControllerCantInit') + '<br />' + e);
  }
  mController._executeAction(action);
 },

 /**
  *  _executeAction
  * 
  *  @param   mAction  action  // current action
  * 
  *  @return  void
  * 
  *  @see     mController#_executeView
  *  @private
 **/
 _executeAction : function(action)
 {
  try
  {
   var viewName = action.execute(this._request);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action execute',this._actionName + mUtils.language.getLanguage('mControllerCantExecute') + '<br />' + e);
  }
  this._executeView(action,viewName);
 },

 /**
  *  _executeView
  * 
  *  @param   mAction  action    // current action
  *  @param   eNum     viewName  // target view name
  *                      executeViewIndex,executeViewInput,executeViewSuccess,
  *                      executeViewError,executeViewNone
  * 
  *  @return  void
  * 
  *  @private
 **/
 _executeView : function(action,viewName)
 {
  try
  {
   action[viewName](this._render);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action view',this._actionName + '.' + viewName + mUtils.language.getLanguage('mControllerCantView') + '<br />' + e);
  }
  this._render.display();
  if(mUtils.config.getConfig('useDebug'))
   mUtils.renderLog('memo',true);
 }
};

DomUtils.appendEvent(window,'load',mController.init,'normal');
