/**
 *  htmlRender
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: htmlRender.js,v $ $Revision: 1.2 $ $Date: 2006/11/10 08:30:13 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mController
**/
{
 /**
  *  render target object
  * 
  *  @private
 **/
 this._renderTarget = null;

 /**
  *  render text
  *
  *  @private
 **/
 this._renderText = null;

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
 };

 /**
  *  setRenderTarget
  * 
  *  @param   object  targetObject
  * 
  *  @return  void
 **/
 this.setRenderTarget = function(targetObject)
 {
  this._renderTarget = targetObject;
 };

 /**
  *  setRenderValue
  * 
  *  @param   string  txt
  *
  *  @return  void
 **/
 this.setRenderValue = function(txt)
 {
  this._renderText = txt;
 };

 /**
  *  display
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.display = function()
 {
  if(this._renderTarget == undefined)
  {
   mUtils.logger.setMessage('warning','htmlRender','display',mUtils.language.getLanguage('mRenderNotSet'));
   return;
  }
  try
  {
   switch(this._renderTarget.nodeName)
   {
    case 'INPUT':
    case 'TEXTAREA':
    case 'SELECT':
     this._renderTarget.value = this._renderText;
     break;
    default:
     this._renderTarget.innerHTML = this._renderText;
     break;
   }
  }
  catch(e)
  {
   mUtils.logger.setMessage('warning','htmlRender','display',mUtils.language.getLanguage('mRenderNotWrite'));
  }
 };
};
