/**
 *  mUtils
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: mUtils.js,v $ $Revision: 1.7 $ $Date: 2006/11/12 06:49:29 $
 * 
 *  @requires DomUtils
 *  @requires HttpRequestUtils
**/
var mUtils = 
{
 /**
  *  config object
  * 
  *  @see  mConfig
 **/
 config :
 {
  /**
   *  default config data object
   * 
   *  @private
  **/
  _defaultData : {
   'language'          : 'en',
   'useCustomConfig'   : false,
   'useDebug'          : false,
   'useDirLanguage'    : false,
   'useCustomLanguage' : false
  },

  /**
   *  config data object
   * 
   *  @private
  **/
  _configData : {},

  /**
   *  custom config data object
   * 
   *  @private
  **/
  _customData : {},

  /**
   *  init
   * 
   *  @param   void
   * 
   *  @return  void
  **/
  init : function()
  {
   this._loadConfig();
  },

  /**
   *  _loadConfig
   * 
   *  @param   void
   * 
   *  @return  void
   * 
   *  @see     mUtils#_setupConfig
   *  @private
  **/
  _loadConfig : function()
  {
   mUtils.loadFile('./config.js');
   mUtils.waitResponse(this,{'_configData' : './config.js'},this._setupConfig,null);
  },

  /**
   *  _setupConfig
   * 
   *  @param   void
   * 
   *  @return  void
   * 
   *  @see     mUtils#_loadUtils
   *  @private
  **/
  _setupConfig : function()
  {
   mUtils.config._setDefaultPath('render'   ,'render/htmlRender.js');
   mUtils.config._setDefaultPath('request'  ,'request/formRequest.js');
   mUtils.config._setDefaultPath('logger'   ,'lib/logger.js');
   mUtils.config._setDefaultPath('language' ,'lib/language.js');
   mUtils.config._setDefaultPath('filter'   ,'lib/filter.js');
   mUtils.config._setDefaultPath('validator','lib/validator.js');
   mUtils.config._setDefaultPath('config'   ,'configs/');
   mUtils.config._setDefaultPath('sysLang'  ,'lang/');
   mUtils.config._setDefaultPath('model'    ,'models/');
   mUtils.config._setDefaultPath('action'   ,'actions/');
   mUtils.config._setDefaultPath('languages','lang/');
   mUtils._loadUtils();
  },

  /**
   *  _setDefaultPath
   * 
   *  @param   string  keyName
   *  @param   string  value
   * 
   *  @return  void
   * 
   *  @private
  **/
  _setDefaultPath : function(keyName,value)
  {
   this._defaultData[keyName + 'Path'] = this.getConfig('rootPath') + value;
  },

  /**
   *  setConfig
   * 
   *  @param   string  keyName
   *  @param   string  value
   * 
   *  @return  void
  **/
  setConfig : function(keyName,value)
  {
   this._customData[keyName] = value;
  },

  /**
   *  resetConfig
   * 
   *  @param   void
   * 
   *  @return  void
  **/
  resetConfig : function()
  {
   this._customData = {};
  },

  /**
   *  getConfig
   * 
   *  @param   string  keyName
   * 
   *  @return  string
  **/
  getConfig : function(keyName)
  {
   switch(true)
   {
    case this._customData[keyName] != undefined:
     return this.customData[keyName];
    case this._configData[keyName] != undefined:
     return this._configData[keyName];
    case this._defaultData[keyName] != undefined:
     return this._defaultData[keyName];
    default:
     mUtils.logger.setMessage('notice','mConfig','get config',keyName + mUtils.language.getLanguage('mConfigUndefined'));
     return null;
   }
  }
 },

 /**
  *  logger object
  * 
  *  @see  mLogger
 **/
 logger : {},

 /**
  *  langage object
  * 
  *  @see  mLanguage
 **/
 language : {},

 /**
  *  validator objects
  * 
  *  @see  mValidator
 **/
 validator : {},

 /**
  *  filter objects
  * 
  *  @see  mFilter
 **/
 filter : {},

 /**
  *  object cache
  * 
  *  @see  mUtils.loadFile
  * 
  *  @private
 **/
 _objectCache : {},

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
  mUtils.config.init();
 },

 /**
  *  _loadUtils
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_setupUtils
  *  @private
 **/
 _loadUtils : function()
 {
  var config = mUtils.config;
  mUtils.loadFile(config.getConfig('loggerPath'));
  mUtils.loadFile(config.getConfig('languagePath'));
  mUtils.loadFile(config.getConfig('filterPath'));
  mUtils.loadFile(config.getConfig('validatorPath'));
  mUtils.waitResponse(mUtils,{
        'logger'    : config.getConfig('loggerPath'),
        'language'  : config.getConfig('languagePath'),
        'filter'    : config.getConfig('filterPath'),
        'validator' : config.getConfig('validatorPath')
        },mUtils._setupUtils,null);
 },

 /**
  *  _setupUtils
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_loadDirLanguage
  *  @private
 **/
 _setupUtils : function()
 {
  mUtils.logger.init();
  mUtils.language.init();
  mUtils._loadDirLanguage();
 },

 /**
  *  _loadDirLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_setupDirLanguage
  *  @private
 **/
 _loadDirLanguage : function()
 {
  var config = mUtils.config;
  if(!config.getConfig('useDirLanguage'))
   return;
  var file = config.getConfig('languagesPath') + config.getConfig('language') + '/lang.js';
  mUtils.loadFile(file);
  mUtils.waitResponse(mUtils.language,{'_langData' : file},function(){},null);
 },

 /**
  *  loadFile
  * 
  *  @param   string  file
  * 
  *  @return  void
 **/
 loadFile : function(file)
 {
  if(mUtils._objectCache[file] != undefined)
   return;
  var cli = HttpRequestUtils.getClient('get',file);
  cli.callbacks['200'] = function(res)
  {
   var obj = new Function(res.txt);
   mUtils._objectCache[file] = new obj();
  };
  cli.callbacks['404'] = function(res)
  {
   try
   {
    mUtils.logger.setMessage('warning','mUtils','loadFile',file + mUtils.language.getLanguage('mUtilsError404'));
    mUtils._objectCache[file] = {};
   }
   catch(e)
   {
    throw file + ' is file not found';
   }
  };
  cli.callbacks['unknown'] = function(res)
  {
   throw 'file load error';
  }
  cli.send('');
 },

 /**
  *  waitResponse
  * 
  *  @param   object    pObj
  *  @param   object    list
  *  @param   function  fnc
  *  @param   object    args
  * 
  *  @return  void
 **/
 waitResponse : function(pObj,list,fnc,args)
 {
  var flag = true;
  for(var i in list)
  {
   if(mUtils._objectCache[list[i]] == undefined)
   {
    flag = false;
    break;
   }
   else
    pObj[i] = mUtils._objectCache[list[i]];
  }
  if(flag)
   fnc(args);
  else
   setTimeout(function(){mUtils.waitResponse(pObj,list,fnc,args)},100);
 },

 /**
  *  renderLog
  * 
  *  @param   string  level
  *  @param   bool    flag
  * 
  *  @return  void
 **/
 renderLog : function(level,flag)
 {
  var mes = this.logger.getMessageString(level,flag);
  try
  {
   DomUtils.getObject('logbox').innerHTML = mes;
  }
  catch(e)
  {
   document.body.appendChild(DomUtils.createObject('logbox','div',{'innerHTML' : mes},{}));
  }
 },

 /**
  *  doTypeSafe
  * 
  *  @param   string  type
  *                     bool,int,float,string,text
  *  @param   string  value
  * 
  *  @return  string
 **/
 doTypesafe : function(type,value)
 {
  switch(type)
  {
   case 'bool':
    return value ? true : false;
    break;
   case 'int':
    return parseInt(value,10);
    break;
   case 'float':
    return parseFloat(value);
    break;
   case 'string':
    value = value.replace(/(\xd\x0a)|(\x0a)|(\x0d)/g,'');
   case 'text':
   default:
    return value;
    break;
  }
 },

 /**
  *  doValidate
  * 
  *  @param   string  value
  *  @param   array   validator
  *  @param   object  params
  * 
  *  @return  string
 **/
 doValidate : function(value,validator,params)
 {
  var flag     = true;
  for(var v in validate)
   if(!this.validator[v](value,params))
    flag = false;
  return flag ? value : null;
 },

 /**
  *  doFilter
  * 
  *  @param   string  value
  *  @param   array   filter
  *  @param   object  params
  * 
  *  @return  string
 **/
 doFilter : function(value,filter,params)
 {
  for(var v in filter)
   value = this.filter[filter[v]](value,params);
  return value;
 }
};


DomUtils.appendEvent(window,'load',mUtils.init,false);
