/**
 *  mLogger
 * 
 *  @author   $Author$
 *  @version  $Name$ $RCSfile$ $Revision$ $Date$
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  message object
  * 
  *  @private
 **/
 this._message = {};

 /**
  *  timer object
  * 
  *  @private
 **/
 this._timer = {};

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
  this.resetLog();
 };

 /**
  *  setMessage
  * 
  *  @param   string  level
  *                     memo,notice,warning,critical
  *  @param   string  path
  *  @param   string  section
  *  @param   string  message
  * 
  *  @return  void
 **/
 this.setMessage = function(level,path,section,message)
 {
  this._message[level].push({'path' : path,'section' : section,'message' : message,'time' : this.getTimer('mutanMain')});
 };

 /**
  *  getMessage
  * 
  *  @param   string level
  *                    memo,notice,warning,critical
  *  @param   bool   flag
  * 
  *  @return  array
 **/
 this.getMessage = function(level,flag)
 {
  if(!flag)
   return this._message[level];
  var mes = [];
  switch(level)
  {
   case 'memo':
    for(var i in this._message.memo)
    {
     this._message.memo[i].level = 'memo';
     mes.push(this._message.memo[i]);
    }
   case 'notice':
    for(var i in this._message.notice)
    {
     this._message.notice[i].level = 'notice';
     mes.push(this._message.notice[i]);
    }
   case 'warning':
    for(var i in this._message.warning)
    {
     this._message.warning[i].level = 'warning';
     mes.push(this._message.warning[i]);
    }
   case 'critical':
    for(var i in this._message.critical)
    {
     this._message.critical[i].level = 'critical';
     mes.push(this._message.critical[i]);
    }
   default:
  }
  return mes;
 };

 /**
  *  getMessageString
  * 
  *  @param   string level
  *                    memo,notice,warning,critical
  *  @param   bool   flag
  * 
  *  @return  array
 **/
 this.getMessageString = function(level,flag)
 {
  var mes = this.getMessage(level,flag);
  var str = '<dl>';
  for(var m in mes)
   str += '<dt>' + mes[m].level + '</dt><dd>' + mes[m].path + ' : ' + mes[m].section + ' (time : ' + mes[m].time +  ')<br />' + mes[m].message + '</dd>';
  return (str + '</dl>');
 }

 /**
  *  setTimer
  * 
  *  @param   string  timerName
  * 
  *  @return  void
 **/
 this.setTimer = function(timerName)
 {
  var dobj = new Date();
  this._timer[timerName] = dobj.getTime();
 };

 /**
  *  getTimer
  * 
  *  @param   string  timerName
  * 
  *  @return  int
 **/
 this.getTimer = function(timerName)
 {
  var dobj = new Date();
  return dobj.getTime() - this._timer[timerName];
 };

 /**
  *  resetLog
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.resetLog = function()
 {
  this._message = {'memo' : [],'notice' : [],'warning' : [],'critical' : []};
  this.setTimer('mutanMain');
 };
};
