/**
 *  mFilter methods
 * 
 *  @author   $Author$
 *  @version  $Name$ $RCSfile$ $Revision$ $Date$
 * 
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  mHtmlFilter
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  string
 **/
 this.mHtmlFilter = function(data,params)
 {
  var pats = [
      {'from' : /&/g,'to' : '&amp;'},
      {'from' : /</g,'to' : '&lt;'},
      {'from' : />/g,'to' : '&gt;'},
      {'from' : /"/g,'to' : '&quot;'},
      {'from' : /'/g,'to' : '&#039;'},
      {'from' : / /g,'to' : '&nbsp;'}];
  for(var i in pats)
   data = data.replace(pats[i].from,pats[i].to);
  return data;
 };

 /**
  *  mUnHtmlFilter
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  string
 **/
 this.mUnHtmlFilter = function(data,params)
 {
  var pats = [
      {'from' : /&amp;/g ,'to' : '&'},
      {'from' : /&gt;/g  ,'to' : '<'},
      {'from' : /&lt;/g  ,'to' : '>'},
      {'from' : /&quot;/g,'to' : '"'},
      {'from' : /&#039;/g,'to' : "'"},
      {'from' : /&nbsp;/g,'to' : ' '}];
  for(var i in pattern)
   data = data.replace(pats[i].from,pats[i].to);
  return data;
 };

 /**
  *  mNewLineFilter
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  string
 **/
 this.mNewLineFilter = function(data,params)
 {
  return data.replace(/(\x0d\x0a)|(\x0a)|(\x0d)/g,'<br />');
 };

 /**
  *  mNewLineUnFilter
  * 
  *  @param   string  data
  *  @param   object  params
  * 
  *  @return  string
 **/
 this.mNewLineUnFilter = function(data,params)
 {
  return data.replace(/<br \/>/g,"\n");
 };
};
