/**
 * # CHAPTER #
 * ============================================================================
 * XMLtableΥإåϢΥإåե
 * ============================================================================
 */

#include <mssOutput.h>
#include <mssOption.h>

#ifndef __MSSHEADER_H
#define __MSSHEADER_H 1

#include <mssInput.h>

/**
 * # MACRO #
 * mssFields¤Τ˳Ǽ줿iܤιܤιֹ롣
 */
#define MssFlds2num(flds,i) ((*((flds)->fi+(i)))->num)

/**
 * # MACRO #
 * mssFields¤Τ˳Ǽ줿iܤιܤι̾롣
 */
#define MssFlds2name(flds,i) ((*((flds)->fi+(i)))->name)

/**
 * # MACRO #
 * mssFields¤Τ˳Ǽ줿iܤιܤΥֹͥ롣
 */
#define MssFlds2priority(flds,i) ((*((flds)->fi+(i)))->priority)

/**
 * # MACRO #
 * mssFields¤Τ˳Ǽ줿iܤιܤεս祽ȥե饰롣
 */
#define MssFlds2revFlg(flds,i) ((*((flds)->fi+(i)))->revFlg)

/**
 * # MACRO #
 * mssFields¤Τ˳Ǽ줿iܤιܤοͥȥե饰롣
 */
#define MssFlds2numFlg(flds,i) ((*((flds)->fi+(i)))->numFlg)

/**
 * # MACRO #
 * mssFields¤Τ˳Ǽ줿iܤιܤĹ(ĹΤ)롣
 */
#define MssFlds2length(flds,i) ((*((flds)->fi+(i)))->length)

/**
 * # STRUCT #
 * xmlTablιܤ˴ؤǼ빽¤
 */
struct mssFldInfo {
  int    num;     /*ֹ(0Ϥޤ)*/
  char  *name;    /*̾*/
  int    priority;/*ȤΥֹͥ(1Ϥޤ롢̵0)*/
  int    revFlg;  /*ս祽ȥե饰(0 or 1)*/
  int    numFlg;  /*ͥȥե饰(0 or 1)*/
  int    length;  /*ĹΤȤιĹ(ʤξ0)*/
  char  *comment; /*ܤΥ(ʤξNULL)*/
};

/**
 * # STRUCT #
 * ʣܤǼ빽¤
 */
struct mssFields {
  struct mssFldInfo **fi; /*mssFldInfoؤΥݥ*/
  int cnt;                /*ܤο*/
};

/**
 * # STRUCT #
 * xmlTableΥإåǼ빽¤
 */
struct mssHeader {
  struct mssFields * flds;  /*ܾ*/
  char *             title;   /*ȥʸ*/
  char *             comment; /*ʸ(Ԥ¸)*/
  int                version; /*xmlTableΥС(1.0->10, 1.1->11)*/
  char *             xmlver;  /*XMLС*/
  char *             xmlenc;  /*XML󥳡ǥ*/
  int                datTop;  /*ºݤΥǡϤޤޤǤʸ*/
  int                recCnt;  /*쥳ɹԿ(ʤξ-1)*/
};

/**
 * # PROTOTYPE # 
 */
struct 			mssFldInfo *mssInitFldInfo();
void 			mssFreeFldInfo( struct mssFldInfo *fi);
void 			mssShowFldInfo(struct mssFldInfo *fi);
struct mssFldInfo *     mssFldNum2Add(struct mssFields *flds, int num);
struct mssFldInfo *	mssFldNam2Add(struct mssFields *flds, char *name);
struct mssFldInfo **	mssFldGlbNam2Add(struct mssFields *flds, char *name);
int 			mssFldNam2Num(struct mssFields *flds, char *name);
int 			mssFldNum2SrtPri(struct mssFields *flds, int num);
int 			mssFldNum2SrtRev(struct mssFields *flds, int num);
int 			mssFldNum2SrtNum(struct mssFields *flds, int num);
void 			mssFreeHeader(struct mssHeader *hd);
struct mssHeader *	mssInitHeader(char *title, char *comment);
struct mssHeader *	mssInitCpyHeader(struct mssHeader *old);
struct mssHeader *	mssInitSetHeader( char *title, char *comment, char *xmlver, char *xmlenc, int version);
void 			mssSetHeaderRecCnt(struct mssHeader *hd, int recCnt);
struct mssFields *	mssInitFields();
void 			mssFreeFields(struct mssFields *flds);
void 			mssShowFields(struct mssFields *flds);
void			mssUpdateFieldsSortPriority(struct mssFields *flds);
void			mssSetFldInfoSort(struct mssFldInfo *fi, int prioriy, int revFlg,int numFlg);
void			mssClearFieldsSort(struct mssFields *flds);
void			mssSetFieldsSort(struct mssFields *flds, struct mssFields *sortFlds);
void			mssSetFieldsSortPriority(struct mssFields *flds);
void			mssSetFldInfoLength(struct mssFldInfo *fi, int length);
void			mssSetFldInfoNum(struct mssFldInfo *fi, int num);
void			mssSetFldInfoName(struct mssFldInfo *fi, char *name);
void			mssSetFldInfoComment(struct mssFldInfo *fi, char *comment);
void 			mssSetFieldsSequenceNum(struct mssFields *flds);
void		 	mssAddFieldsByStr(struct mssFields *flds, char *str);
void			mssAddFieldsByStrList(struct mssFields *flds, char **str, int cnt);
void			mssAddFieldsByFldInfo(struct mssFields *flds, struct mssFldInfo *fi);
void			mssAddFieldsByFldInfoList(struct mssFields *flds, struct mssFldInfo **fi);
void			mssAddFieldsByFields(struct mssFields *flds, struct mssFields *addFlds);
void			mssAddHeadOrOptFields(struct mssFields *flds, struct mssHeader *hd, MssOptFLD *optFld);
void			mssWriteFldInfo(struct mssFldInfo *fi, int version, struct mssFPW *fp);
void			mssWriteHeader( struct mssHeader *hd, struct mssFPW *fp);
void			mssWriteFooter(struct mssFPW *fp);
void			mssCreateBlankXtFile(char **fldName, int fldCnt, char *fname);
struct mssHeader *	mssReadHeader( struct mssFPR *fp);
void			mssShowHeader(struct mssHeader *hd);
int			mssChkSorted( struct mssFields *sf, struct mssHeader *hd);
void			mssSetOptFld(MssOptFLD *optFLD, struct mssHeader *hd);
void			mssSetOptKey(MssOptKEY *optKEY, struct mssHeader *hd);

#endif /* _HEADER_H */

