/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIؤб 2003/07/19                                         */
/*============================================================================*/
#include <musashi.h>
#include <suffixTree.h>
#include <dasg.h>
#include <xtcntseqHelp.h>

#include <stdlib.h>
#include <limits.h>

struct mssComHelp comHelp={
  "xtcntseq",     /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;

/*----------------------------------------------------------------------------*/
/*originalιʸhashɽϿΥɥ쥹seqơ֥Ͽ   */
/*----------------------------------------------------------------------------*/
struct mssHashNode **setSeqDat(
  struct mssHashNode **seq, /*󥹤*/
  struct mssHash *hash,     /*Ͽhashɽ*/
  int *keyCnt,           /*󥹤Υ*/
  char *str){            /*Ͽoriginalʸ*/

  struct mssHashNode *hn;  /*Ͽ줿hashNodeؤΥݥ*/
  MssValue v;              /*hashɽؤϿѥߡ*/

  mssVinit(&v,STR);
  hn=mssHashInsertAdd(hash,str,v);
  seq=mssRealloc(seq,sizeof(struct mssHashNode *)*(*keyCnt+1),"seq1");
  *(seq+*keyCnt)=hn;
  (*keyCnt)++;

  return(seq);
}

int main(int argc, char *argv[]){
/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
    KEYT,   /* ΥץΥȥ(Helpɽ)                         */
    KEYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* 󥹰Ԥ̤뤿ι                                         */
/*----------------------------------------------------------------------------*/
  MssOptKEY optUNT={
    OKEY,   /* ץ󥿥                                             */
    "u",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
    UNTT,   /* ΥץΥȥ(Helpɽ)                         */
    UNTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ȹ                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optSRT={
    OFLD,   /* ץ󥿥                                             */
    "s",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n,r",  /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    SRTT,   /* ΥץΥȥ(Helpɽ)                         */
    SRTC,   /* ΥץΥ(Helpɽ)                         */
    SRTF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* 󥹤ͤΥǡ                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                         */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptINT optCNT={
    OINT,   /* ץ󥿥                                             */
    "c",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    10,     /* ǥե(ͤȤƻ)                                   */
    1,      /* Ǿ                                                       */
    INT_MAX,/*                                                        */
    CNTT,   /* ΥץΥȥ(Helpɽ)                         */
    CNTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ()                                                             */
/*----------------------------------------------------------------------------*/
  MssOptDBL optPCT={
    ODBL,   /* ץ󥿥                                             */
    "p",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    5,      /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    100,    /*                                                        */
    PCTT,   /* ΥץΥȥ(Helpɽ)                         */
    PCTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* 󥹤Ĺ                                                           */
/*----------------------------------------------------------------------------*/
  MssOptRNG optLEN={
    ORNG,   /* ץ󥿥                                             */
    "l",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "2_5",  /* ǥե(ʸȤƻꤹ)                             */
    1,      /* ޤǶڤǿκ                             */
    1,      /* ͤκǾ                                                   */
    50,     /* ͤκ                                                   */
    LENT,   /* ΥץΥȥ(Helpɽ)                         */
    LENC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ֥                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSSQ={
    OFLG,   /* ץ󥿥                                             */
    "Q",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    SSQT,   /* ΥץΥȥ(Helpɽ)                         */
    SSQC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̾                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* ץ󥿥                                             */
    "a",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "sequence,no,len,cnt,totalCnt", /* ǥե(ʸ)                   */
    5,      /* ޤǶڤǿκ                             */
    1,      /* ǤʸĹκǾ                                     */
    MssFieldNameMaxLen,/* ǤʸĹκ                          */
    0,      /* 1:Ǥ˥Ǥ,0:Բ  ex) aaaa:xxxxx            */
    FNMT,   /* ΥץΥȥ(Helpɽ)                         */
    FNMC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* 󥷥                                                         */
/*----------------------------------------------------------------------------*/
  MssOptFLG optSEQ={
    OFLG,   /* ץ󥿥                                             */
    "q",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    SEQT,   /* ΥץΥȥ(Helpɽ)                         */
    SEQC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optUNT,&optSRT,&optFLD,&optCNT,&optPCT,&optLEN,&optSSQ,
               &optFNM,&optSEQ,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

  struct mssHeader    *hdi; /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdo=NULL; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fpr; /*ϥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  struct mssFldRecDbl *frd=NULL; /*-Хåե¤*/
  struct mssFields    *sf;  /*ȹܹ¤     */

  int ukb,kkb;  /*֥졼ե饰*/
  int sorted;            /*Ⱥѥå*/
  int keyCnt;
  int recNo;
  struct mssHash *hash;
  struct mssHashNode **seq; /*󥹤*/
  int supportCnt;

  struct SuffixTree *suffix=NULL; /*եåĥ꡼ΥȥåץΡ*/
  struct DASG       *dasg  =NULL;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */
  mssSetOptKey(&optKEY, hdi);        /* -k ܤإåܤ˴ϢŤ     */
  mssSetOptKey(&optUNT, hdi);        /* -u ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optSRT, hdi);        /* -s ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optFLD, hdi);        /* -f ܤإåܤ˴ϢŤ     */

  /*ȹܤκ*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k ܤ򥽡ȹܤȤƥå    */
  mssAddFieldsByFields(sf,optUNT.flds); /* -u ܤ򥽡ȹܤȤƥå    */
  mssAddFieldsByFields(sf,optSRT.flds); /* -s ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sf);         /* ֹͥϿˤդ   */
  sorted=mssChkSorted(sf,hdi);          /* ȺѤå                 */

/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

  /*-aꤹĿϣĤǤʤФʤʤ*/
  if(optFNM.set && optFNM.cnt!=5){
    mssShowErrMsg("must specify five field names on -a");
    mssEnd(mssErrorNoDefault);
  }

  if(!optCNT.set && !optPCT.set){
    mssShowErrMsg("must specify either -c or -p");
    mssEnd(mssErrorNoDefault);
  }
/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdi);

  mssAddFieldsByFields(hdo->flds,optKEY.flds);
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+0)); /*unit̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+1)); /*no̾ɲ*/
  mssAddFieldsByFields(hdo->flds,optFLD.flds);
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+2)); /*len̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+3)); /*cnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+4)); /*totalCnt̾ɲ*/

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*ȤɬѤʤХȤƥȺѤߥեȤƥץ*/
  if(!optSEQ.set && !sorted)
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);

  /*FRD¤Τν*/
  frd=mssInitFRD(hdi->flds->cnt);

  seq=NULL;                   /*ñ̤ȤΥ*/
  keyCnt=0;                   /*ˤǤ뤫*/
  recNo=0;                    /*keyǲܤΥ󥹤(start from 1)*/
  if(optSSQ.set) dasg  =DASGinit(3);  /*dasgν*/
  else           suffix=SUFXinit(10); /*suffixTreeν*/
  hash=mssInitHash(101);         /*ϥåơ֥κ()*/
  if(!optSSQ.set) seq=setSeqDat(seq,hash,&keyCnt,"^");
  while( EOF!=mssReadFRD(fpr,frd) ){

    /*֥쥤ν*/
    kkb=mssKeyBreak(frd, &optKEY);
    ukb=mssKeyBreak(frd, &optUNT);
    if(kkb || ukb){ /*-k or -u Υ֥졼*/
      if(!optSSQ.set) seq=setSeqDat(seq,hash,&keyCnt,"$");
      if(optSSQ.set)  DASGaddStr(dasg  ,seq,keyCnt);
      else            SUFXaddStr(suffix,seq,keyCnt);
      mssFree(seq);
      seq=NULL;
      keyCnt=0;
      recNo++;
      if(!optSSQ.set) seq=setSeqDat( seq,hash,&keyCnt,"^");
    }
    if(kkb){ /*-k Υ֥졼*/
      if(optSSQ.set){
        /*ݡȷΥå*/
        if(optCNT.set) supportCnt=optCNT.val;
        else           supportCnt=(int)((optPCT.val/(double)100)*(double)recNo);
        /*DASGshow(dasg);*/
        DASGwriteXt(dasg,*optLEN.from,*optLEN.to,supportCnt,frd->pnt[frd->old],&optKEY,fpw);
        DASGfree(dasg);
        dasg=DASGinit(3);
      }else{
        /*ݡȷΥå*/
        if(optCNT.set) supportCnt=optCNT.val;
        else           supportCnt=(int)((optPCT.val/(double)100)*(double)recNo);
        /*SUFXshow(suffix); */
        SUFXwriteXt(suffix,*optLEN.from,*optLEN.to,recNo,supportCnt,frd->pnt[frd->old],&optKEY,fpw);
        SUFXfree(suffix);
        suffix=SUFXinit(10); /*suffixTreeν*/
      }

      mssFreeHash(hash);
      hash=mssInitHash(101);
      recNo=0;  /*keyǲܤΥ󥹤(start from 1)*/
      mssFree(seq);
      seq=NULL;
      keyCnt=0;
      if(!optSSQ.set) seq=setSeqDat( seq,hash,&keyCnt,"^");

      if(frd->eof) break;
    }

    mssGV.inCnt++;
    /*̾Ԥν(ͤη׻)*/
    seq=setSeqDat( seq,hash,&keyCnt,*(frd->pnt[frd->new]+MssFlds2num(optFLD.flds,0)) );

  }
  if(optSSQ.set) DASGfree(dasg);
  else           SUFXfree(suffix);
  mssFree(seq);
  mssFreeHash(hash);
  mssFreeFRD(frd);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /* եåν             */
  mssCloseFPR(fpr);       /* ϥեΥ     */
  mssCloseFPW(fpw);       /* ϥեΥ     */
  mssFreeFields(sf);      /* ȹܹ¤Τΰ賫 */
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeHeader(hdo);     /* ϥإåΰ賫         */
  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
