/**
 * # CHAPTER #
 * ============================================================================
 * ΰʬ˴ؤإåե
 * ============================================================================
 */

#define MALLOC_CNT 200
#define XMAX 1024
#define YMAX 1024
#define DBLMINVAL -3.4E+38
#define DBLMAXVAL 3.4028E+38

#define Ar1(a,x)     (a+(x))
#define Ar2(a,x,y)   (a+(y)*cntTbl->xCnt+(x))
#define Ar3(a,x,y,z) (a+(z)*cntTbl->yCnt*cntTbl->xCnt+(y)*cntTbl->xCnt+(x))
#define Ar2p1(a,x,y) (a+(y)*((cntTbl->xCnt)+1)+(x))

/**
 * # STRUCT #
 * ĤΥ(pixel)ΥǡǼ빽¤
 */
struct CntCel {
  long negCnt;
  long posCnt;
  long total;
  double        weight;
};

struct RTBL {
  double from;
  double to;
};

/**
 * # STRUCT #
 * ΰΥǡǼ빽¤
 */
struct CntTbl {
  struct CntCel   tbl[XMAX][YMAX]; /*оݤȤ (Ǥ1)*/
  struct RTBL     rtbl[2][XMAX];   /*ϰ*/
  int             xCnt;            /*оݤȤXκǿ*/
  int             yCnt;            /*оݤȤYκǿ*/
  long   sup;                      /*ȡΥݡȷ sup(N)*/
  long   hit;                      /*ȡΥҥåȷ hit(N)*/
};

/**
 * -----------------------------------------------------------------------------
 * XñĴ,YñĴѤ빽¤
 * -----------------------------------------------------------------------------
 */

/**
 * ˤ륹Ȱ֤Ƚλ֡ȡj
 */
struct REGBDY {
  int    start;
  int    end;
  double weight;
  int    optJ;   /*0ϥ󥯤ʤ̣*/
};

/**
 * X,YñĴΰǻȤ,Ūΰ
 */
struct REGION {
  struct REGBDY *tbl;
  int    maxX;                   /*ȤǤ礭ʤXֹ*/
  int    maxY;                   /*ȤǤ礭ʤYֹ*/
  double maxWeight;              /*ȤǤ礭ʤweight*/
};

/**
 * max w[1,i] w[j,N] κŬ¸Ƥι¤
 */
struct W1IJN {
  int    start;
  double weight;
};

/**
 *
 */
struct WSUB {
  struct W1IJN *w1i; /*1i ޤǤιweight (1)*/
  struct W1IJN *wjN; /*jN ޤǤιweight (1)*/
  double       *w1u; /*1u ޤǤιweight (1)*/
  double       *wvN; /*vN ޤǤιweight (1)*/
  double        w1N;
};

/**
 * -----------------------------------------------------------------------------
 * ĹѤ빽¤
 * -----------------------------------------------------------------------------
 */
struct HSSUB {
  long *h1u; /*hit     from 1 to u(2)*/
  long *s1u; /*support from 1 to u(2)*/
  long *hvN; /*hit     from v to N(2)*/
  long *svN; /*support from v to N(2)*/
  long *h1N; /*hit     from 1 to N(1)*/
  long *s1N; /*support from 1 to N(1)*/
};

/**
 * -----------------------------------------------------------------------------
 * rectLinewr(XYñĴ)Ѥ빽¤
 * -----------------------------------------------------------------------------
 */

/**
 *
 */
struct XYBDY {
  int type; /*0:null 1:wide 2:upper 3:down 4:narrow*/
  int m;
  int s;
  int t;
  double weight;
};

/**
 *
 */
struct XYTBL {
  struct XYBDY fw;
  struct XYBDY fu;
  struct XYBDY fd;
  struct XYBDY fn;
};

/**
 * -----------------------------------------------------------------------------
 * Ŭΰ򵭲빽¤(ΰ趦̤)
 *                region nonregion total
 * actual positive  posO   posX      posOX
 * actual negative  negO   negX      negOX
 * total            supO   supX      supOX
 * -----------------------------------------------------------------------------
 */
struct SELREG {
           char   *tbl;    /*ΰXY(0:ΰ 1:ΰ)*/
  struct RTBL      rtbl[2][XMAX]; /*ΰϰ*/
           int     xCnt;
           int     yCnt;
           double  theta;  /*Ȥ(Ĺΰ̤)*/
           double  weight; /*weight(Ĺΰ̤)*/
  long    sup;    /*򤵤줿ΰΥݡȷ*/
  long    hit;    /*򤵤줿ΰΥҥåȷ*/
           double  objVal; /*Ūؿɾ*/
           double  variance;/*饹ʬ*/
           double  entropy; /*ȥԡ*/
           double  gini;    /*gini*/
           double  accuracy;/*Ψ*/

  long    supOX;
  long    supO;
  long    supX;
  long    posOX;
  long    posO;
  long    posX;
  long    negOX;
  long    negO;
  long    negX;
           int     fcNo;
           int     fcNoX;
           int     fcNoY;
};



struct CntTbl *initCntTbl(int x, int y);
void setCntTblByCell(struct CntTbl *cntTbl, int x, int y, int hit, int sup);
void adjustNulCntTbl( struct CntTbl *cntTbl, char *nul);
void deajustNulCntTbl( struct CntTbl *cntTbl, struct SELREG *selReg);
void dispCntTbl(struct CntTbl *cntTbl);
void dispCntTblWeight(struct CntTbl *cntTbl);
void dispCntTblHitRatio(struct CntTbl *cntTbl);
struct SELREG *segRegion(struct CntTbl *cntTbl, char *type, char *nul);
void dispSelReg(struct SELREG *selReg);

