#include <musashi.h>
#include <dasg.h>

extern struct mssGlobalVariables mssGV;

/*============================================================================*/
/* DASG(Directed Acyclic Subsequence Graph)κ                             */
/*  algorithm by H.Hosino, A.Shinohara, at el., "Online construction of subsequence automata for multiple texts",DOI Technical Report,2000.                   */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ޥ                                                                     */
/*----------------------------------------------------------------------------*/
/*directionѿstate"s",ե٥åȤ"a"Ǥ֤ޥ*/
#define Direction(s,a) (*(*(dasg->direction+(s))+(a)))
/*nsalѿstate"s",ե٥åȤ"a"Ǥ֤ޥ*/
#define Nsal(s,a)      (*(*(dasg->nsal     +(s))+(a)))
#define IniStat 0  /*stateֹ0*/
#define ErrStat 1  /*顼stateֹ1*/

/*============================================================================*/
/* ִؿ                                                                   */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* directionΥå                                                          */
/* state="s",alphabet="a"arc"state"ꤹ                             */
/* Ʊ"state"arcܿ򥫥ȤƤ                             */
/*----------------------------------------------------------------------------*/
static void setDirection(struct DASG *dasg,int s,int a,int state){
  (*(dasg->refCnt+state))++;
  (*(dasg->refCnt+Direction(s,a)))--;
  Direction(s,a)=state;
}

/*----------------------------------------------------------------------------*/
/* StateList¤Τνȳ                                              */
/*----------------------------------------------------------------------------*/
static struct StateList *initStateList(){
  struct StateList *sl;
  sl=mssCalloc(sizeof(struct StateList),"initStateList");
  return(sl);
}

static void freeStateList(struct StateList *sl){
  mssFree(sl->state);
  mssFree(sl);
}

/*----------------------------------------------------------------------------*/
/* StateList¤Τstateɲä(return 1)                               */
/* ˤв⤻0֤                                        */
/*----------------------------------------------------------------------------*/
static int addList(struct StateList *sl, int state){
  int i;
  for(i=0; i<sl->cnt; i++) if(*(sl->state+i) == state) return(0);
  sl->state=mssRealloc(sl->state,sizeof(int)*(sl->cnt+1),"addList");
  *(sl->state+sl->cnt)=state;
  sl->cnt++;
  return(1);
}

/*----------------------------------------------------------------------------*/
/* state="s",alphabet="a"nsal"state"ɲϿ롣                      */
/* Ʊˡstate="s"nsaCnt(nsaη)򹹿                             */
/*----------------------------------------------------------------------------*/
static void addNonSolidArcList(struct DASG *dasg,int s, int a, int state){
  if( addList(Nsal(s,a),state) ) (*(dasg->nsaCnt+s))++;
}

/*----------------------------------------------------------------------------*/
/* state="s",alphabet="a"nsal롣                                 */
/* Ʊˡstate="s"nsaCnt(nsaη)򹹿                             */
/*----------------------------------------------------------------------------*/
static void delNonSolidArcList(struct DASG *dasg,int s, int a){
  *(dasg->nsaCnt+s)-=Nsal(s,a)->cnt;
  Nsal(s,a)=initStateList();
}

/*----------------------------------------------------------------------------*/
/* DASG˰ĤʸɲäȤγƼ                           */
/*----------------------------------------------------------------------------*/
static void extendDimension(struct DASG *dasg){
  int a,i;
  int r,s;
  for(i=0; i<dasg->stateCnt; i++){
    *(dasg->nsaCnt+i)=0;
  }
  for(a=0; a<dasg->alpCnt; a++){
    for(s=0; s<(*(dasg->targetStates+a))->cnt; s++){
      i=*((*(dasg->targetStates+a))->state+s);
      freeStateList(Nsal(i,a));
      Nsal(i,a)=initStateList();
    }
    r=Direction(IniStat,a);
    addNonSolidArcList(dasg,r,a,IniStat);
    freeStateList(*(dasg->targetStates+a));
    *(dasg->targetStates+a)=initStateList();
    addList(*(dasg->targetStates+a),r);
  }
  (*(dasg->match+IniStat))++;
}

/*----------------------------------------------------------------------------*/
/* alphabetơ֥뤫顢Ϳ줿ʸ(chr)ֹc˥åȤ롣           */
/* ɲä1֤¸ߤ0֤                           */
/* setAlphaNogetNo4AlphaϸΨΤ褤르ꥺѹ뤳              */
/*----------------------------------------------------------------------------*/
static int setAlphaNo(struct DASG *dasg, struct mssHashNode *chr, int *c){
  int i;
  for(i=0; i<dasg->alpCnt; i++){
    if( *(dasg->alpTbl+i)==chr ){
      *c=i;
      return(0);
    }
  }

  /*ޤǤȤȤϡʸ*/
  dasg->alpTbl=mssRealloc(dasg->alpTbl,sizeof(int)*(dasg->alpCnt+1),"sa");
  *(dasg->alpTbl+dasg->alpCnt)=chr;
  *c=i;
  return(1);
}

/*----------------------------------------------------------------------------*/
/* alphabetơ֥뤫顢Ϳ줿alphabet餽ֹ֤                 */
/* ʤalphabetˤĤƤ-1֤                                             */
/*----------------------------------------------------------------------------*/
static int getNo4Alpha(struct DASG *dasg, struct mssHashNode *chr){
  int i;
  for(i=0; i<dasg->alpCnt; i++){
    if( *(dasg->alpTbl+i)==chr ){
      return(i);
    }
  }
  return(-1);
}


/*----------------------------------------------------------------------------*/
/* alphabetиȤDASGγƼѿΰĥ       */
/*----------------------------------------------------------------------------*/
static void extendAlp(struct DASG *dasg){
  int i;

  /*--- directionΰĥ(StateAlpha)*/
  for(i=0; i<dasg->stateCnt; i++){
    *(dasg->direction+i)
      =mssRealloc(*(dasg->direction+i),sizeof(int)*(dasg->alpCnt+1),"exAl");
    Direction(i,dasg->alpCnt)=ErrStat; /*ʸErrState³*/
  }

  /*--- refCntΰĥ(State)*/
  /*State³Arcdasg->stateCntʬοalphabetʬä*/
  *(dasg->refCnt+ErrStat)+=dasg->stateCnt;

  /*--- nsaCntΰĥ(State)*/
  /*refCntƱ͡ErrStatErrStatʬϰ(-1)*/
  *(dasg->nsaCnt+ErrStat)+=dasg->stateCnt-1;

  /*--- nsalΰĥ(StateAlpha)*/
  /*stateοalphabetStateListɲä
    state"b"ErrStateؤarcnsalɲ(ErrStateʳ)
    ơErrStatetargetStates[newChr]ɲ*/
  for(i=0; i<dasg->stateCnt; i++){
    *(dasg->nsal+i)=mssRealloc(*(dasg->nsal+i),
       sizeof(struct StateList)*(dasg->alpCnt+1),"exAl");
    Nsal(i,dasg->alpCnt)=initStateList();
  }
  for(i=0; i<dasg->stateCnt; i++){
    if(i != ErrStat) addList(Nsal(ErrStat,dasg->alpCnt),i);
  }

  /*--- targetStatesΰĥ(Alpha)*/
  /*newChrtargetErrStateɲ*/
  dasg->targetStates=mssRealloc(dasg->targetStates,
                       sizeof(struct StateList *)*(dasg->alpCnt+1),"exAl");
  *(dasg->targetStates+dasg->alpCnt)=initStateList();
  addList(*(dasg->targetStates+dasg->alpCnt),ErrStat);
}

/*----------------------------------------------------------------------------*/
/* stateɲäȤDASGγƼѿΰĥ          */
/*----------------------------------------------------------------------------*/
static void extendState(struct DASG *dasg){
  int j;

  /*--- directionΰĥ(StateAlpha)*/
  dasg->direction=mssRealloc(dasg->direction,sizeof(int *)*
                    (dasg->stateCnt+1),"exSt");
  *(dasg->direction+dasg->stateCnt)=mssMalloc(sizeof(int)*
                    (dasg->alpCnt),"exSt");
  for(j=0; j<dasg->alpCnt; j++) Direction(dasg->stateCnt,j)=0;

  /*--- matchΰĥ(State)*/
  dasg->match=mssRealloc(dasg->match,sizeof(int)*(dasg->stateCnt+1),"exSt");
  *(dasg->match+dasg->stateCnt)=0;

  /*--- refCntΰĥ(State)*/
  dasg->refCnt=mssRealloc(dasg->refCnt,sizeof(int)*(dasg->stateCnt+1),"exSt");
  *(dasg->refCnt+dasg->stateCnt)=0;

  /*--- nsaCntΰĥ(State)*/
  dasg->nsaCnt=mssRealloc(dasg->nsaCnt,sizeof(int)*(dasg->stateCnt+1),"exSt");
  *(dasg->nsaCnt+dasg->stateCnt)=0;

  /*--- nsalΰĥ(StateAlpha)*/
  dasg->nsal=mssRealloc(dasg->nsal,sizeof(struct StateList *)*
              dasg->alpCnt*(dasg->stateCnt+1),"exSt");
  *(dasg->nsal+dasg->stateCnt)=mssMalloc(sizeof(struct StateList)*
                    (dasg->alpCnt),"exSt");
  for(j=0; j<dasg->alpCnt; j++) Nsal(dasg->stateCnt,j)=initStateList();
}

/*----------------------------------------------------------------------------*/
/* DASG˰ʸɲä                                                       */
/*----------------------------------------------------------------------------*/
static void appendChar(struct DASG *dasg, int c){
  struct StateList *lastTargetStates;
  struct StateList **lastNonSolidArcs;
  int a,i,j,p;
  int r,s,t;
  int *tmpCnt;

  lastNonSolidArcs=mssMalloc(sizeof(struct StateList *)*dasg->stateCnt,"append");
  tmpCnt=mssMalloc(sizeof(int)*dasg->stateCnt,"append");

  lastTargetStates=*(dasg->targetStates+c);
  *(dasg->targetStates+c)=initStateList();

  for(s=0; s<lastTargetStates->cnt; s++){
    i=*(lastTargetStates->state+s);
    tmpCnt[i]=*(dasg->nsaCnt+i);
    lastNonSolidArcs[i]=Nsal(i,c);
    delNonSolidArcList(dasg,i,c);
  }

  for(s=0; s<lastTargetStates->cnt; s++){
    i=*(lastTargetStates->state+s);
    if(*(dasg->refCnt+i)==tmpCnt[i]){ /*¸StateȤ*/
      p=i;
    }else{                            /*Stateɲ*/
      extendState(dasg);  /*StateѤΰĥ*/
      p=dasg->stateCnt++;
    }

    for(a=0; a<dasg->alpCnt; a++){
      r=Direction(i,a);
      setDirection(dasg,p,a,r);
      addNonSolidArcList(dasg,r,a,p);
      addList(*(dasg->targetStates+a),r);
    }
    *(dasg->match+p)=*(dasg->match+i)+1;
    for(t=0; t<lastNonSolidArcs[i]->cnt; t++){
      j=*(lastNonSolidArcs[i]->state+t);
      setDirection(dasg,j,c,p);
    }
    freeStateList(lastNonSolidArcs[i]);
  }
  freeStateList(lastTargetStates);
  mssFree(lastNonSolidArcs);
  mssFree(tmpCnt);
}

/*============================================================================*/
/* PUBLICؿ                                                                 */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* DASG䤤碌֥"s"狼֤                          */
/*----------------------------------------------------------------------------*/
int DASGqueryCnt(struct DASG *dasg,struct mssHashNode **s, int n){
  int q,i;
  q=IniStat;
  for(i=0;i<n;i++){
    q=Direction(q,getNo4Alpha(dasg,*(s+i)));
  }
  return(*(dasg->match+q));
}

/*----------------------------------------------------------------------------*/
/* DASG                                                                 */
/*----------------------------------------------------------------------------*/
void DASGshow(struct DASG *dasg){
  int i,j,k;

  printf("----------------------------\n");
  for(i=0; i<dasg->alpCnt; i++){
    printf("  targetStates(cnt:%d)=",(*(dasg->targetStates+i))->cnt);
    for(j=0; j<(*(dasg->targetStates+i))->cnt; j++){
      printf("%d,",*((*(dasg->targetStates+i))->state+j));
    }
    printf("\n");
  }

  for(i=0; i<dasg->stateCnt; i++){
    printf("state[%d]:\n",i);

    printf("  match=%d\n",*(dasg->match+i));
    printf("  cnt(nonSolid,all)=(%d,%d)\n",*(dasg->nsaCnt+i),*(dasg->refCnt+i));

    printf("  d=");
    for(j=0; j<dasg->alpCnt; j++){
      printf("%d,",Direction(i,j));
    }
    printf("\n");

    printf("  nonSolidArcList=");
    for(j=0; j<dasg->alpCnt; j++){
      for(k=0; k<Nsal(i,j)->cnt; k++){
        printf("%d,",*(Nsal(i,j)->state+k));
      }
      printf("; ");
    }
    printf("\n");
  }
}

/*----------------------------------------------------------------------------*/
/* DASGν (˥ե٥åȤΥ)                                */
/*----------------------------------------------------------------------------*/
struct DASG *DASGinit(int size){
  struct DASG *dasg;

  dasg=mssMalloc(sizeof(struct DASG),"DASGinit");
  dasg->alpCnt      =0;
  dasg->alpTbl      =NULL;
  dasg->stateCnt    =2;
  dasg->direction   =mssCalloc(sizeof(int)*2,"main");
  dasg->match       =mssCalloc(sizeof(int)*2,"main");
  dasg->refCnt      =mssCalloc(sizeof(int)*2,"main");
  dasg->nsaCnt      =mssCalloc(sizeof(int)*2,"main");
  dasg->targetStates=NULL;
  dasg->nsal        =mssCalloc(sizeof(int)*2,"main");
  return(dasg);
}

/*----------------------------------------------------------------------------*/
/* DASGγ                                                                 */
/*----------------------------------------------------------------------------*/
void DASGfree(struct DASG *dasg){
  int i,j;

  for(i=0; i<dasg->stateCnt; i++){
    for(j=0; j<dasg->alpCnt; j++){
      freeStateList(Nsal(i,j));
    }
  }

  for(i=0; i<dasg->alpCnt; i++){
    freeStateList(*(dasg->targetStates+i));
  }

  for(i=0; i<dasg->stateCnt; i++){
    mssFree(*(dasg->direction+i));
    mssFree(*(dasg->nsal+i));
  }
  mssFree(dasg->direction);
  mssFree(dasg->match);
  mssFree(dasg->refCnt);
  mssFree(dasg->nsaCnt);
  mssFree(dasg->targetStates);
  mssFree(dasg->nsal);
  mssFree(dasg->alpTbl);
  mssFree(dasg);
}

/*----------------------------------------------------------------------------*/
/* DASGʸɲ                                                         */
/*----------------------------------------------------------------------------*/
void DASGaddStr(struct DASG *dasg,struct mssHashNode **str, int n){
  int i;
  int c;
  for(i=0; i<n; i++){
    if( 1==setAlphaNo(dasg,*(str+i),&c) ){ /*ꥸʥchrֹcѴ*/
      extendAlp(dasg); /*ʸʤСƼѿΰ礹*/
      dasg->alpCnt++;
    }
    appendChar(dasg,c);
  }

  extendDimension(dasg);
}

int *stateList; /*Ѥstateơ֥*/
int *alphaList; /*ե٥åȥơ֥*/
int statePnt=0; /*stateơ֥ˤ륫Ȱ*/
int outKeyCnt=0;
MssOptKEY *gKey;
char **gPnt;
/*----------------------------------------------------------------------------*/
/* DASGXMLtableǽ                                                   */
/*----------------------------------------------------------------------------*/
void DASGwriteXtSub(struct DASG *dasg, int state,
                    int minDepth,int maxDepth,int support,struct mssFPW *fpw){
  int i,j;

  if(*(dasg->match+state) < support){
    return;
  }
  if(statePnt>maxDepth){ /*ǾĹĹ˽񤭽Ф*/
    return;
  }
  if(statePnt>=minDepth){ /*ǾĹĹ˽񤭽Ф*/

    /*񤭽Ф*/
    for(i=0; i<statePnt; i++){
      for(j=0; j<gKey->cnt; j++){
        mssWriteStr(*(gPnt+MssFlds2num(gKey->flds,j)),fpw);
        mssWriteDlm(fpw);
      }
      mssWriteInt(outKeyCnt,fpw)      ; mssWriteDlm(fpw);
      mssWriteInt(i+1,fpw)            ; mssWriteDlm(fpw);
      mssWriteStr( (*(dasg->alpTbl+*(alphaList+i)))->str,fpw); mssWriteDlm(fpw);
      mssWriteInt(statePnt,fpw)      ; mssWriteDlm(fpw); /**/
      mssWriteInt(*(dasg->match+state),fpw)        ; mssWriteRet(fpw);
      mssGV.outCnt++;
    }
    outKeyCnt++;
  }

  for(j=0; j<dasg->alpCnt; j++){
    *(stateList+statePnt)=state;
    *(alphaList+statePnt)=j;
    statePnt++;
    DASGwriteXtSub(dasg,Direction(state,j),minDepth,maxDepth,support,fpw);
    statePnt--;
  }
}

void DASGwriteXt(struct DASG *dasg,int minDepth,int maxDepth,int support, char **pnt,MssOptKEY *key,struct mssFPW *fpw){

  stateList=mssCalloc(sizeof(int)*dasg->stateCnt,"DASGwriteXt");
  alphaList=mssCalloc(sizeof(int)*dasg->stateCnt,"DASGwriteXt");
  outKeyCnt=1;
  gPnt=pnt;
  gKey=key;
  DASGwriteXtSub(dasg,0,minDepth,maxDepth,support,fpw);
  mssFree(stateList);
  mssFree(alphaList);
}

