/*
 * unistd.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<stddef.h>
#include<callgate.h>
#include<share/syscall.h>
#include<system.h>
#include<errno.h>
#include<string.h>
#include<fcntl.h>
#include<sys/stat.h>
#include<signal.h>
#include<limits.h>
#include<stdio.h>
#include<fcntl.h>
#include<time.h>
#include<unistd.h>


/************************************************************************************
 *
 * exec
 *
 **************************************************************************************/

extern char **environ;


/*
 * PATHĶѿʸ롣
 */
static inline const char *getPathEnv()
{
	char **env=environ;
	char *pathstr="PATH=";
	int i;


	for(;env!=NULL;++env)
		for(i=0;(*env)[i]==pathstr[i];)
			if(pathstr[++i]=='\0')return &(*env)[i];

	return ":/ bin:/usr/bin";
}


/*
 * PATHĶѿʸ򥳥ԡ롣
 * return : pathμʸΥݥ(':' or '\0')
 */
static inline const char *cpyPathEnv(char *buf,const char *env)
{
	int i;


	for(i=0;env[i]!=':';++i)
		if((buf[i]=env[i])=='\0')return &env[i];
	buf[i]='\0';

	return &env[i];
}


int execve(const char *path, char *const argv[], char *const envp[])
{
	errno=-syscall4(SYS_EXEC,(int)path,(int)argv,(int)envp);
	return -1;
}


int execl(const char *path, const char *arg0, ...)
{
	return execve(path,(char**)&arg0,environ);
}


int execle(const char *path, const char *arg0, ...)
{
	char **env;


	env=(char**)&arg0;
	while(*env++!=NULL);
	return execve(path,(char**)&arg0,env);
}


int execv(const char *path, char *const argv[])
{
	return execve(path,argv,environ);
}


int execlp(const char *file, const char *arg0, ...)
{
	const char *epath;
	char buf[_PC_PATH_MAX];


	if(strchr(file,'/')==NULL)
	{
		/* pathĶѿõ */
		epath=getPathEnv();

		while(*epath!='0')
		{
			epath=cpyPathEnv(buf,epath);
			execve(strcat(buf,file),(char**)&arg0,environ);
			if(errno!=ENOENT)break;
			if(*epath==':')++epath;
		}

		return -1;
	}
	else return execve(file,(char**)&arg0,environ);
}


int execvp(const char *file, char *const argv[])
{
	const char *epath;
	char buf[_PC_PATH_MAX];


	if(strchr(file,'/')==NULL)
	{
		/* pathĶѿõ */
		epath=getPathEnv();

		while(*epath!='0')
		{
			epath=cpyPathEnv(buf,epath);
			execve(strcat(buf,file),argv,environ);
			if(errno!=ENOENT)break;
			if(*epath==':')++epath;
		}

		return -1;
	}
	else return execve(file,argv,environ);
}


/************************************************************************************
 *
 * process ID
 *
 ************************************************************************************/

pid_t getpid(void)
{
	PROC_ID pd;


	syscall3(SYS_GET_PROCID,0,(int)&pd);
	return pd.pid;
}


gid_t getgid(void)
{
	PROC_ID pd;


	syscall3(SYS_GET_PROCID,0,(int)&pd);
	return pd.gid;
}


uid_t getuid(void)
{
	PROC_ID pd;


	syscall3(SYS_GET_PROCID,0,(int)&pd);
	return pd.uid;
}


gid_t getegid(void)
{
	return getgid();
}


uid_t geteuid(void)
{
	return getuid();
}


pid_t getppid(void)
{
	PROC_ID pd;


	syscall3(SYS_GET_PROCID,0,(int)&pd);
	return pd.ppid;
}


pid_t getpgid(pid_t pid)
{
	int rest;
	PROC_ID pd;


	if((rest=syscall3(SYS_GET_PROCID,pid,(int)&pd))<0)
	{
		errno=-rest;
		return -1;
	}
	return pd.gid;
}


pid_t getpgrp(void)
{
	return getpgid(0);
}


int getgroups(int size, gid_t list[])
{
	/* ̤б */
	return 0;
}


int setgid(gid_t gid)
{
	int rest;
	PROC_ID pd;


	pd.gid=gid;
	pd.uid=-1;
	if((rest=syscall3(SYS_SET_PROCID,0,(int)&pd))<0)
	{
		errno=-rest;
		return -1;
	}
	return 0;
}


int setuid(uid_t uid)
{
	int rest;
	PROC_ID pd;


	pd.gid=-1;
	pd.uid=uid;
	if((rest=syscall3(SYS_SET_PROCID,0,(int)&pd))<0)
	{
		errno=-rest;
		return -1;
	}
	return 0;
}


int setegid(gid_t egid)
{
	return setgid(egid);
}


int setpgid(pid_t pid, pid_t pgid)
{
	int rest;
	PROC_ID pd;


	pd.gid=pgid;
	pd.uid=-1;
	if((rest=syscall3(SYS_SET_PROCID,pid,(int)&pd))<0)
	{
		errno=-rest;
		return -1;
	}
	return 0;
}


pid_t setsid(void)
{
	pid_t pid;


	pid=getpid();
	if(setgid(pid)==-1)return -1;
	return pid;
};


/************************************************************************************
 *
 * ¾
 *
 ************************************************************************************/

int chdir(const char *path)
{
	int rest;


	if((rest=syscall2(SYS_CHDIR,(int)path))<0)
	{
		errno=-rest;
		return -1;
	}

	return 0;
}


int dup(int fildes)
{
	return fcntl(fildes,F_DUPFD,0);
}


int dup2(int fildes,int fildes2)
{
	close(fildes2);
	return fcntl(fildes,F_DUPFD,fildes2);
}


void _exit(int state)
{
	syscall2(SYS_EXIT,(int)state);
}


pid_t fork(void)
{
	int rest;


	if((rest=syscall1(SYS_FORK))<0)
	{
		errno=-rest;
		return -1;
	}

	return rest;
}


char *getcwd(char *buf, size_t size)
{
	int rest;


	if((rest=syscall3(SYS_GETCWD,(int)buf,size))<0)
	{
		errno=-rest;
		return NULL;
	}

	return buf;
}


off_t lseek(int fildes,off_t offset,int whence)
{
	int rest;


	if((rest=syscall4(SYS_LSEEK,fildes,offset,whence))<0)
	{
		errno=-rest;
		return -1;
	}

	return rest;
}


ssize_t read(int fildes,void *buf,size_t nbyte)
{
	int rest;


	if((rest=syscall4(SYS_READ,fildes,(int)buf,(int)nbyte))<0)
	{
		errno=-rest;
		return -1;
	}

	return rest;
}


int rmdir(const char *path)
{
	int rest;


	if((rest=syscall2(SYS_RMDIR,(int)path))<0)
	{
		errno=-rest;
		return -1;
	}

	return 0;
}


ssize_t write(int fildes,const void *buf,size_t nbyte)
{
	int rest;


	if((rest=syscall4(SYS_WRITE,fildes,(int)buf,(int)nbyte))<0)
	{
		errno=-rest;
		return -1;
	}

	return rest;
}


int close(int fildes)
{
	int rest;


	/* ɸϤϥʤ */
	if((fildes>=STDIN_FILENO)&&(fildes<=STDERR_FILENO))
	{
		errno=EBADF;
		return -1;
	}

	if((rest=syscall2(SYS_CLOSE,fildes))<0)
	{
		errno=-rest;
		return -1;
	}

	return 0;
}


int brk(void *end_segment)
{
	static uint allocLast=0;
	uint alloc_last;


	if((alloc_last=ROUNDUP((uint)end_segment,PAGE_SIZE)-1)>allocLast)
	{
		if(syscall2(SYS_BRK,alloc_last)!=0)return -1;
		allocLast=alloc_last;
	}

	return 0;
}


void *sbrk(ptrdiff_t increment)
{
	void *begin;


	begin=(void*)(sys_info->lastAddr+1);

	if(increment>0)
	{
		if(brk((void*)(sys_info->lastAddr+increment))!=0)return NULL;
		sys_info->lastAddr+=increment;
	}

	return begin;
}


void sync()
{
	syscall1(SYS_SYNC);
}


int unlink(const char *path)
{
	int rest;


	if((rest=syscall2(SYS_UNLINK,(int)path))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int chown(const char *path, uid_t owner, gid_t group)
{
	int rest=0;


	if((int)owner!=-1)
		rest=syscall4(SYS_CHATTR,(int)path,CHATTR_UID,(int)owner);
	if((int)group!=-1)
		rest=syscall4(SYS_CHATTR,(int)path,CHATTR_GID,(int)group);
	if((rest)<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int reboot(int flag)
{
	int rest;


	if((rest=syscall2(SYS_REBOOT,flag))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


unsigned int sleep(unsigned int seconds)
{
	return syscall2(SYS_SLEEP,seconds);
}


unsigned int alarm(unsigned int seconds)
{
	return syscall2(SYS_ALARM,seconds);
}


int pause(void)
{
	sigset_t mask=0;


	return sigsuspend(&mask);
}


long sysconf(int name)
{
	switch(name)
	{
		case _SC_ARG_MAX:
			return ARG_MAX;
		case _SC_CHILD_MAX:
			return CHILD_MAX;
		case _SC_OPEN_MAX:
			return OPEN_MAX;
		case _SC_STREAM_MAX:
			return STREAM_MAX;
		case _SC_TZNAME_MAX:
			return TZNAME_MAX;
		case _SC_JOB_CONTROL:
			return _POSIX_JOB_CONTROL;
		case _SC_SAVED_IDS:
			return _POSIX_SAVED_IDS;
		case _SC_VERSION:
			return _POSIX_VERSION;
		case _SC_2_C_BIND:
		case _SC_2_C_DEV:
		case _SC_2_C_VERSION:
		case _SC_2_CHAR_TERM:
		case _SC_2_FORT_DEV:
		case _SC_2_FORT_RUN:
		case _SC_2_LOCALEDEF:
		case _SC_2_PBS:
		case _SC_2_PBS_ACCOUNTING:
		case _SC_2_PBS_CHECKPOINT:
		case _SC_2_PBS_LOCATE:
		case _SC_2_PBS_MESSAGE:
		case _SC_2_PBS_TRACK:
		case _SC_2_SW_DEV:
		case _SC_2_UPE:
		case _SC_2_VERSION:
		case _SC_ADVISORY_INFO:
		case _SC_AIO_LISTIO_MAX:
		case _SC_AIO_MAX:
		case _SC_AIO_PRIO_DELTA_MAX:
		case _SC_ASYNCHRONOUS_IO:
		case _SC_BC_BASE_MAX:
		case _SC_BC_DIM_MAX:
		case _SC_BC_SCALE_MAX:
		case _SC_BC_STRING_MAX:
		case _SC_CLK_TCK:
		case _SC_COLL_WEIGHTS_MAX:
		case _SC_CPUTIME:
		case _SC_DELAYTIMER_MAX:
		case _SC_EXPR_NEST_MAX:
		case _SC_FILE_LOCKING:
		case _SC_FSYNC:
		case _SC_GETGR_R_SIZE_MAX:
		case _SC_GETPW_R_SIZE_MAX:
		case _SC_HOST_NAME_MAX:
		case _SC_LINE_MAX:
		case _SC_LOGIN_NAME_MAX:
		case _SC_MAPPED_FILES:
		case _SC_MEMLOCK:
		case _SC_MEMLOCK_RANGE:
		case _SC_MEMORY_PROTECTION:
		case _SC_MESSAGE_PASSING:
		case _SC_MQ_OPEN_MAX:
		case _SC_MQ_PRIO_MAX:
		case _SC_NGROUPS_MAX:
		case _SC_PRIORITIZED_IO:
		case _SC_PRIORITY_SCHEDULING:
		case _SC_RE_DUP_MAX:
		case _SC_REALTIME_SIGNALS:
		case _SC_REGEXP:
		case _SC_RTSIG_MAX:
		case _SC_SEMAPHORES:
		case _SC_SEM_NSEMS_MAX:
		case _SC_SEM_VALUE_MAX:
		case _SC_SHARED_MEMORY_OBJECTS:
		case _SC_SHELL:
		case _SC_SIGQUEUE_MAX:
		case _SC_SPAWN:
		case _SC_SPORADIC_SERVER:
		case _SC_SYNCHRONIZED_IO:
		case _SC_THREAD_ATTR_STACKADDR:
		case _SC_THREAD_ATTR_STACKSIZE:
		case _SC_THREAD_CPUTIME:
		case _SC_THREAD_DESTRUCTOR_ITERATIONS:
		case _SC_THREAD_KEYS_MAX:
		case _SC_THREAD_PRIO_INHERIT:
		case _SC_THREAD_PRIO_PROTECT:
		case _SC_THREAD_PRIORITY_SCHEDULING:
		case _SC_THREAD_PROCESS_SHARED:
		case _SC_THREAD_SAFE_FUNCTIONS:
		case _SC_THREAD_SPORADIC_SERVER:
		case _SC_THREAD_STACK_MIN:
		case _SC_THREAD_THREADS_MAX:
		case _SC_TIMEOUTS:
		case _SC_THREADS:
		case _SC_TIMER_MAX:
		case _SC_TIMERS:
		case _SC_TTY_NAME_MAX:
		case _SC_V6_ILP32_OFF32:
		case _SC_V6_ILP32_OFFBIG:
		case _SC_V6_LP64_OFF64:
		case _SC_V6_LPBIG_OFFBIG:
			return 0;
		default:
			return _error(EINVAL);
	}
}


int access(const char *pathname, int mode)
{
	int fd;
	int flag;


	if(mode&W_OK)
	{
		if(mode&(R_OK|X_OK|F_OK))flag=O_RDWR;
		else flag=O_WRONLY;
	}
	else
	{
		if(mode&(R_OK|X_OK|F_OK))flag=O_RDONLY;
		else return _error(EINVAL);
	}

	if((fd=open(pathname,flag))==-1)return -1;
	close(fd);

	return 0;
}


long fpathconf(int filedes, int name)
{
	struct stat st;


	if(fstat(filedes,&st)==-1)return -1;

	switch(name)
	{
		case _PC_LINK_MAX:
			return _POSIX_LINK_MAX;
		case _PC_MAX_CANON:
			return _POSIX_MAX_CANON;
		case _PC_MAX_INPUT:
			return _POSIX_MAX_INPUT;
		case _PC_NAME_MAX:
			return NAME_MAX;
		case _PC_PATH_MAX:
			return _POSIX_PATH_MAX;
		case _PC_PIPE_BUF:
			return _POSIX_PIPE_BUF;
		case _PC_CHOWN_RESTRICTED:
			return st.st_uid;
		case _PC_NO_TRUNC:
			return 0;
		case _PC_VDISABLE:
			return 0;
		default:
			return _error(EINVAL);
	}
}


long pathconf(const char *path, int name)
{
	int fd;
	int rest;


	if((fd=open(path,O_RDONLY))==-1)return -1;
	rest=fpathconf(fd,name);
	close(fd);

	return rest;
}


static char ttynameBuf[TTY_NAME_MAX+5];

char *ttyname(int fd)
{
	int rest;


	strcpy(ttynameBuf,"/dev/");
	if((rest=syscall2(SYS_TTYNAME,(int)(ttynameBuf+5)))<0)
	{
		errno=-rest;
		return NULL;
	}

	return ttynameBuf;
}


int isatty(int desc)
{
	return (ttyname(desc)!=NULL);
}


int pipe(int filedes[2])
{
	char path[20];
	int fd[2];


	/* ѥѥե̾κ */
	sprintf(path,"%x%x",getuid(),clock());

	if((fd[0]=open(path,O_RDONLY|O_CREAT|O_DEL,S_IRWXU|S_IRWXG))==-1)return -1;
	if((fd[1]=open(path,O_WRONLY|O_DEL))==-1)
	{
		close(fd[0]);
		return -1;
	}

	filedes=fd;

	return 0;
}


int link(const char *oldpath, const char *newpath)
{
	int rest;


	if((*oldpath=='\0')||(*newpath=='\0'))return _error(ENOENT);

	if((rest=syscall3(SYS_LINK,(int)oldpath,(int)newpath))<0)
		return _error(rest);

	return 0;
}

/********************** ̤ݡ **************************/

pid_t tcgetpgrp(int fd)
{
	return _error(ENOSYS);
}

int tcsetpgrp(int fd, pid_t pgrp)
{
	return _error(ENOSYS);
}

char *getlogin(void)
{
	errno=ENOSYS;
	return NULL;
}
