/*
 * string.h
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef string_h
#define string_h


#include<sys/types.h>
#include<stddef.h>


extern inline int memcmp(const void *s1,const void *s2,size_t n)
{
	int i=0;


	while(((char*)s1)[i]==((char*)s2)[i])
		if(++i>=n)return 0;

	if(((char*)s1)[i]>((char*)s2)[i])return 1;
	return -1;
}

extern inline void *memchr(const void *s, int c, size_t n)
{
	int i;


	for(i=0;i<n;++i)
		if(((char*)s)[i]==(char)c)return &((char*)s)[i];

	return NULL;
}

extern inline int strcmp(const char *s1,const char *s2)
{
	while(*s1==*s2++)
		if(*s1++=='\0')return 0;

	if(*s1>*--s2)return 1;
	return -1;
}

extern inline int strncmp(const char *s1, const char *s2, size_t n)
{
	int i;


	for(i=0;;++i)
	{
		if(i>=n)return 0;
		if(s1[i]!=s2[i])break;
	}

	if(s1[i]>s2[i])return 1;
	return -1;
}

extern inline int strcoll(const char *s1, const char *s2)
{
	return strcmp(s1,s2);
}

extern inline char *strcpy(char *s1,const char *s2)
{
	char *p=s1;


	while((*p++=*s2++)!='\0');

	return s1;
}

extern inline size_t strlen(const char *s)
{
	const char *p=s;


	while(*p++!='\0');

	return (size_t)(p-s-1);
}

extern inline char *strncpy(char *s1,const char *s2,size_t n)
{
	int i=n;


	while(--i<n)s1[i]=s2[i];

	return s1;
}

extern inline char *strchr(const char *s,int c)
{
	do
	{
		if(*s==(char)c)return (char*)s;
	}while(*s++!='\0');

	return NULL;
}

extern inline char *strrchr(const char *s, int c)
{
	char *r=NULL;


	for(;*s!='\0';++s)
		if(*s==(char)c)r=(char*)s;

	return r;
}

extern inline char *strcat(char *s1,const char *s2)
{
	char *p=s1;


	for(;*p!='\0';++p);
	while((*p++=*s2++)!='\0');

	return s1;
}

extern inline char *strncat(char *dest, const char *src, size_t n)
{
	char *p=dest;
	int i;


	for(;*p!='\0';++p);
	for(i=0;i<n;++i)p[i]=src[i];
	p[i]='\0';

	return dest;
}

extern void    *memset(void *, int, size_t);

extern inline void bzero(void *s, size_t n)
{
	memset(s,0,n);
}

extern void    *memcpy(void *, const void *, size_t);

extern inline void *memmove(void *dest, const void *src, size_t n)
{
	int i;


	if((src<dest)&&((char*)src+n>(char*)dest))
	{
		for(i=n-1;i>=0;--i)((char*)dest)[i]=((char*)src)[i];

		return dest;
	}
	else return memcpy(dest,src,n);
}


/*
 * Copyright (c) 1985, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * 2004: modified by minoru murashma.
 */


extern inline char *strpbrk(const char *s1, const char *s2)
{
	const char *scanp;
	int c, sc;

	while ((c = *s1++) != 0)
	{
		for (scanp = s2; (sc = *scanp++) != 0;)
			if (sc == c)return (char *)(s1 - 1);
	}
	return NULL;
}


extern inline size_t strcspn(const char *s1, const char *s2)
{
	const char *p, *spanp;
	char c, sc;

	/*
	 * Stop as soon as we find any character from s2.  Note that there
	 * must be a NUL in s2; it suffices to stop when we find that, too.
	 */
	for (p = s1;;)
	{
		c = *p++;
		spanp = s2;
		do
		{
			if ((sc = *spanp++) == c)return (p - 1 - s1);
		} while (sc != 0);
	}
	/* NOTREACHED */
}


extern inline size_t strspn(const char *s1, const char *s2)
{
	const char *p = s1, *spanp;
	char c, sc;

	/*
	 * Skip any characters in s2, excluding the terminating \0.
	 */
cont:
	c = *p++;
	for (spanp = s2; (sc = *spanp++) != 0;)
		if (sc == c)goto cont;

	return (p - 1 - s1);
}


extern inline char *strstr(const char *s, const char *find)
{
	char c, sc;
	size_t len;

	if ((c = *find++) != 0)
	{
		len = strlen(find);
		do
		{
			do
			{
				if ((sc = *s++) == 0)return (NULL);
			} while (sc != c);
		} while (strncmp(s, find, len) != 0);
		s--;
	}
	return ((char *)s);
}


extern inline size_t strxfrm(char *dst, const char *src, size_t n)
{
	size_t srclen, copysize;

	/*
	 * Since locales are unimplemented, this is just a copy.
	 */
	srclen = strlen(src);
	if (n != 0)
	{
		copysize = srclen < n ? srclen : n - 1;
		(void)memcpy(dst, src, copysize);
		dst[copysize] = 0;
	}
	return (srclen);
}


extern char    *strerror(int);
extern char    *strtok(char *, const char *);


#endif
