/*
 * stdio.h
 */


#ifndef stdio_h
#define stdio_h


#include<sys/types.h>
#include<unistd.h>
#include<stddef.h>
#include<stdarg.h>
#include<limits.h>


enum{
	BUFSIZ=1024,		/* Size of <stdio.h> buffers. */
	_IOFBF=0,			/* Input/output fully buffered. */
	_IOLBF,				/* Input/output line buffered. */
	_IONBF,				/* Input/output unbuffered. */
	L_tmpnam=20,		/* Maximum size of character array to hold tmpnam() output. */

	FILENAME_MAX=NAME_MAX,	/* Maximum size in bytes of the longest filename string. */
	FOPEN_MAX=STREAM_MAX,	/* Number of streams.The value is at least eight. */
	TMP_MAX,				/* Minimum number of unique filenames generated by tmpnam().
						 	   Maximum number of times an application can call tmpnam() reliably.
						       The value of {TMP_MAX} is at least 25. */

	EOF=-1,					/* End-of-file return value. */
};


/* File stream structure. */
typedef struct{
	int fd;
	int bufMode;
	int flag;
	size_t size;
	void *buf;
}FILE;

typedef unsigned int fpos_t;


extern FILE *stdin;
extern FILE *stdout;
extern FILE *strerr;


/* Function declarations. */
extern void     clearerr(FILE *);
extern char    *ctermid(char *);
extern int      fclose(FILE *);
extern FILE    *fdopen(int,const char*);
extern int      feof(FILE *);
extern int      ferror(FILE *);
extern int      fflush(FILE *);
extern int      fgetc(FILE *);
extern int      fgetpos(FILE *, fpos_t *);
extern char    *fgets(char *,int,FILE*);
extern FILE    *fopen(const char *, const char *);
extern int      fprintf(FILE *, const char *, ...);
extern int      fputc(int, FILE *);
extern int      fputs(const char *, FILE *);
extern size_t   fread(void *, size_t, size_t, FILE *);
extern FILE    *freopen(const char *, const char *,FILE *);
extern int      fscanf(FILE *, const char *, ...);
extern int      fseek(FILE *, long, int);
extern int      fsetpos(FILE *,fpos_t *);
extern long     ftell(FILE *);
extern size_t   fwrite(const void *, size_t, size_t, FILE *);
extern int      getc(FILE *);
extern int      getchar(void);
extern char    *gets(char *);
extern void     perror(const char *);
extern int      printf(const char *, ...);
extern int      putc(int, FILE *);
extern int      putchar(int);
extern int      puts(const char *);
extern int      rename(const char *, const char *);
extern int      remove(const char *);
extern void     rewind(FILE *);
extern void     setbuf(FILE *, char *);
extern int      setvbuf(FILE *, char *, int, size_t);
extern int		sprintf(char *, const char *, ...);
extern int      scanf(const char *, ...);
extern int      sscanf(const char *, const char *, ...);
extern FILE    *tmpfile(void);
extern int      ungetc(int, FILE *);
extern int      vfprintf(FILE *, const char *, va_list);
extern int      vprintf(const char *, va_list);
extern int      vsprintf(char *, const char *, va_list);

/* ̤ */
extern char    *tmpname(char *);


#endif
