/*
 * tcp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Transmission control Protocl.
 */


#include<types.h>
#include<lib.h>
#include<errno.h>
#include<mm.h>
#include<proc.h>
#include<time.h>
#include<lock.h>
#include<interrupt.h>
#include<signal.h>
#include<net/net.h>
#include<net/ether.h>
#include<net/ip.h>
#include<net/tcp.h>
#include<test.h>


static void closeConnect(SOCKET*,TCP_HEADER*);


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


enum{
	/* TCP flag. */
	TCP_FLG_FIN=1<<0,
	TCP_FLG_SYN=1<<1,
	TCP_FLG_RST=1<<2,
	TCP_FLG_PSH=1<<3,
	TCP_FLG_ACK=1<<4,
	TCP_FLG_URG=1<<5,

	/* ͥ֡ */
	SOCK_CNCT_ON=         1,		/* ͥѤߡ */
	SOCK_CNCT_TRANS_FIN=  1<<1,		/* ͥλ */
	SOCK_CNCT_RECV_FINACK=1<<2,		/* ͥλ */
	SOCK_CNCT_RECV_FIN=   1<<3,		/* ͥλ */
	SOCK_LISTEN=          1<<4,		/* åԤϡ */
	SOCK_LINK_ON=         1<<7,		/* åȥ󥯺Ѥߡ */

	TCP_WIN_SIZE=0xffff,	/* Window size. */
	TCP_MSS_SIZE=1460,		/* Ⱥ祵 */
};


/*
 * PUBLIC
 * إåꡣ
 * parameters : dectination IP,pseudo header address,data size
 */
static inline void setPseudoHead(in_addr_t dstip,in_addr_t srcip,uint16_t size,PSEUDO_HEADER *pshead)
{
	pshead->dstip=dstip;
	pshead->srcip=srcip;
	pshead->tmp=0;
	pshead->prot=IPPROTO_TCP;
	pshead->len=swapWord(size);
}


/**************************************************************************
 *
 * إåץ
 *
 **************************************************************************/


enum{
	/* Header option. */
	TCP_KIND_END=  0,
	TCP_KIND_NOP=  1,
	TCP_KIND_MSS=  2,
	TCP_KIND_WSC=  3,
	TCP_KIND_TSTMP=8,

	TCP_OPT_MAXSIZE=32,		/* TCP ץκ祵 */
};


typedef struct{
	uint32_t timeStamp;
	uint32_t timeEcho;
	uint16_t mss;
	uint8_t  winscal;
}OPTIONS;


/*
 * PUBLIC
 * Get TCP options.
 * parameters : option address
 */
static void getTcpOptions(uchar *c,int size,OPTIONS *optst)
{
	uchar *last;


	last=c+size;
	while(c<last)
	{
		switch(*c)
		{
			case TCP_KIND_MSS:
				optst->mss= *(uint16_t*)(c+2);
				c+=4;
				break;
			case TCP_KIND_WSC:
				optst->winscal=*(uint8_t*)(c+2);
				c+=3;
				break;
			case TCP_KIND_TSTMP:
				optst->timeStamp=*(uint32_t*)(c+2);
				optst->timeEcho=*(uint32_t*)(c+6);
				c+=10;
				break;
			case TCP_KIND_NOP:
				c+=1;
				break;
			case TCP_KIND_END:
				break;
			default:
				c+=*(c+1);
		}
	}
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/*
 * PUBLIC
 * Transmit a tcp segment.
 * Note!
 *  ץǡɬintǳڤ륵ˤ뤳ȡ
 * parameters : socket,TCP flag,option address,option size,data address,data size,fragment flag
 */
static void transSegment(SOCKET *sc,uint8_t flag,void *opt,int opt_size,void *data,int data_size,int fragment)
{
	char head[sizeof(PSEUDO_HEADER)+sizeof(TCP_HEADER)+TCP_OPT_MAXSIZE];
	TRANS_BUF_INFO tbi;
	TCP_HEADER *send_tcp;


	send_tcp=(TCP_HEADER*)(head+sizeof(PSEUDO_HEADER));

	/* إåꡣ */
	setPseudoHead(sc->dstip,getSrcip(sc->dstip),sizeof(TCP_HEADER)+opt_size+data_size,(PSEUDO_HEADER*)head);

	/* Хåեơ֥ */
	tbi.data[2]=data;
	tbi.size[2]=data_size;
	tbi.data[1]=(char*)send_tcp;
	tbi.size[1]=sizeof(TCP_HEADER)+opt_size;
	tbi.ipType=IPPROTO_TCP;

	/* Make TCP header. */
	send_tcp->srcport= sc->srcport;
	send_tcp->dstport= sc->dstport;
	send_tcp->seqnum=  swapInt32(sc->seqnum);
	send_tcp->acknum=  swapInt32(sc->acknum);
	send_tcp->headlen= ((sizeof(TCP_HEADER)+opt_size)/sizeof(uint32_t))<<4;
	send_tcp->flag=    flag;
	send_tcp->wndsize= swapWord(TCP_WIN_SIZE);
	send_tcp->chksum=  0;
	send_tcp->urgpoint=0;
	memcpy(send_tcp->option,opt,opt_size);
	send_tcp->chksum=calcSumM((uint*)head,data,sizeof(PSEUDO_HEADER)+sizeof(TCP_HEADER)+opt_size,data_size);
/************************************************************************************************************************
printk("send    %x,%x,%x,%x,%x\n",
	swapWord(send_tcp->srcport),swapWord(send_tcp->dstport),swapInt32(send_tcp->seqnum),swapInt32(send_tcp->acknum),
	send_tcp->flag);
************************************************************************************************************************/
	/*  */
	transIp(&tbi,sc->dstip,0,fragment);
}


/*
 * PUBLIC
 * ͥ󤬤ʤΥꥻåȥȤ
 * parameters : receive IP header
 */
static inline void transReset(IP_HEADER *ip)
{
	SOCKET sc;
	TCP_HEADER *tcp;


	tcp=(TCP_HEADER*)ip->data;
	sc.seqnum= 0;
	sc.acknum= swapInt32(tcp->seqnum)+1;
	sc.srcport=tcp->dstport;
	sc.dstport=tcp->srcport;
	sc.dstip=  ip->srcip;
	transSegment(&sc,TCP_FLG_RST,NULL,0,NULL,0,1);
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


enum{
	WATI_COUNT_MAX=3,		/* åȥХåեԤ祫ȿ */
};


/* PUBLIC */
static SOCKET waitCnctSc;	/* Ԥ󥯡 */
static SOCKET waitLstnSc;		/* å󥯡 */
static int waitCnctLock;	/* Ԥѥåȡ */


/*
 * PRIVATE
 * åȥ󥯤鳺åȤõ
 * parameters : destination port number,source port number,destination IP,source IP
 * return : socket address to failed=NULL
 */
static inline SOCKET *searchSocketLink(uint16_t dstport,uint16_t srcport,uint32_t dstip,uint32_t srcip)
{
	SOCKET *sc;


	/* ͥ󥯤õ */
	for(sc=waitCnctSc.next;sc!=&waitCnctSc;sc=sc->next)
		if((sc->srcport==dstport)&&(sc->dstport==srcport)&&(sc->dstip==srcip))
			return sc;

	/* å󥯤õ */
	for(sc=waitLstnSc.next;sc!=&waitLstnSc;sc=sc->next)
		if((sc->srcport==dstport)&&((sc->srcip==INADDR_ANY)||(sc->srcip==dstip)))
		{
			sc->dstip=srcip;
			return sc;
		}

	return NULL;
}


/*
 * PRIVATE
 * Save receive data.
 * parameters : IP data
 * return : 0 or task switch=1
 */
static int saveRecv(IP_HEADER *ip)
{
	TCP_HEADER *tcp;
	SOCKET *sc;


	tcp=(TCP_HEADER*)ip->data;
/**************************************************************************************************************
printk("receive %x,%x,%x,%x,%x\n",
	swapWord(tcp->srcport),swapWord(tcp->dstport),swapInt32(tcp->acknum),swapInt32(tcp->seqnum),tcp->flag);
**************************************************************************************************************/
	/* ͥ󥽥åȤθ */
	enter_spinlock(&waitCnctLock);
	{
		if((sc=searchSocketLink(tcp->dstport,tcp->srcport,ip->dstip,ip->srcip))==NULL)
		{
			exit_spinlock(&waitCnctLock);
			transReset(ip);
			return 0;
		}

		while(sc->update==1);
		sc->update=1;								/* åȹϡ */
	}
	exit_spinlock(&waitCnctLock);

	if(sc->stat&SOCK_CNCT_TRANS_FIN)closeConnect(sc,tcp);
	else
	{
		/*
		 * ǡ򥽥åȤϤ
		 * ХåեƤʤȤϺåԤġ
		 */
		for(;;)
		{
			if(sc->buf==NULL)
			{
				sc->buf=ip;
				sc->waitCnt=0;
				break;
			}
			if(sc->waitCnt>=WATI_COUNT_MAX)break;
			wait_task();
			sc->waitCnt+=1;
		}

	}
	sc->update=0;									/* åȹλ */

	/* READԤץε */
	if(sc->wait.flag!=0)
	{
		wake_intr(&sc->wait,TASK_SIGNAL_WAIT);
		return 1;
	}

	return 0;
}


/*
 * PUBLIC
 * Get data from receive buffer.
 * parameters : socket,segment address buffer
 * return : receive segment size or error number,time out ms
 */
static int waitReceive(SOCKET *sc,TCP_HEADER **tcp_buf,uint timeout)
{
	IP_HEADER *ip;


	for(;;)
	{
		/* 쥷֥Хåեˤꡣ */
		if(sc->buf!=NULL)break;

		/* SIGINTߤ */
		if(isSigint())return -EINTR;

		/* ǡ쥷Ԥ */
		sc->wait.flag=0;
		wait_intr(&sc->wait,timeout,TASK_SIGNAL_WAIT);

		/*  */
		if(sc->wait.flag)		/* Time out. */
		{
			sc->wait.flag=0;
			if(sc->buf==NULL)return -ETIMEDOUT;
			break;
		}
	}

	ip=(IP_HEADER*)sc->buf;
	sc->buf=NULL;
	*tcp_buf=(TCP_HEADER*)ip->data;

	return swapWord(ip->len)-(ip->verhead&0xf)*4;
}


/*
 * PUBLIC
 * Add to connection link.
 * parameters : socket
 */
static void addWaitCnctLink(SOCKET *sc)
{
	cli();
	enter_spinlock(&waitCnctLock);
	{
		sc->next=waitCnctSc.next;
		sc->prev=&waitCnctSc;
		waitCnctSc.next->prev=sc;
		waitCnctSc.next=sc;
	}
	exit_spinlock(&waitCnctLock);
	sti();
}


/*
 * PUBLIC
 * Add to connection link.
 * parameters : socket
 */
static void addWaitLstnLink(SOCKET *sc)
{
	cli();
	enter_spinlock(&waitCnctLock);
	{
		sc->next=waitLstnSc.next;
		sc->prev=&waitLstnSc;
		waitLstnSc.next->prev=sc;
		waitLstnSc.next=sc;
	}
	exit_spinlock(&waitCnctLock);
	sti();
}


/*
 * PUBLIC
 * Delete from connection link.
 * parameters : socket
 */
static void delWaitLink(SOCKET *sc)
{
	cli();
	enter_spinlock(&waitCnctLock);
	{
		while(sc->update==1);
		sc->next->prev=sc->prev;
		sc->prev->next=sc->next;
		sc->next=sc->prev=sc;
	}
	exit_spinlock(&waitCnctLock);
	sti();
}


/*
 * PUBLIC
 * 㤦Ȥ줿Ȥν
 * parameters : socket,receive TCP header
 * return : error number
 */
static int recvBadSegment(SOCKET *sc,TCP_HEADER *tcp)
{
	if(tcp->flag&TCP_FLG_RST)return -ECONNREFUSED;

	/* ꥻåȥȤ */
	sc->acknum=swapInt32(tcp->seqnum)+1;
	sc->seqnum=0;
	transSegment(sc,TCP_FLG_RST,NULL,0,NULL,0,1);

	return -EAGAIN;
}


/*
 * GROBAL
 * Receive TCP datagram.
 * parameters : IP data
 * return : 0 or task switch=1
 */
int receiveTcp(IP_HEADER *ip)
{
	int tcp_size;
	PSEUDO_HEADER pshead;


	/* åγǧ */
	tcp_size=swapWord(ip->len)-(ip->verhead&0xf)*4;
	setPseudoHead(ip->dstip,ip->srcip,tcp_size,&pshead);
	if(calcSumM((uint*)&pshead,(uint*)ip->data,sizeof(PSEUDO_HEADER),tcp_size))
		return 0;

	return saveRecv(ip);
}


/**************************************************************************
 *
 * ͥ
 *
 **************************************************************************/


enum{
	CNCT_CLOSE_WAIT_TIME=5000,		/* ǽॢȻms */
	REPLY_TIMEOUT=5000,				/* ॢȥߥá */
};


typedef struct{
	uint8_t  kind;
	uint8_t  len;
	uint16_t mss;
}MSS;


/* PRIVATE */
static SOCKET *finSocket;		/* 楽åȥ󥯡 */


/*
 * PRIVATE
 * ǳϥåȤ󥯤³롣
 * parameters : socket
 */
static inline void addCloseSocket(SOCKET *sc)
{
	sc->waitNext=finSocket;
	finSocket=sc;
	sc->waitTime=sys_time();
}


/*
 * PRIVATE
 * ǳϥåȤǡॢȤõ
 */
static inline void delCloseTimeout()
{
	uint time;
	SOCKET *p;


	time=sys_time();
	while(finSocket!=NULL)
	{
		if(time-finSocket->waitTime>=CNCT_CLOSE_WAIT_TIME)
		{
			p=finSocket->waitNext;
			delWaitLink(finSocket);
			kfree(finSocket);
			finSocket=p;
		}
		else break;
	}
}


/*
 * PUBLIC
 * Get sequence number.
 * return : sequence number
 */
static inline uint32_t getSeqNumber()
{
	/* 4msǣ䤹RFC793ˡ */
	return rdtsc()/clock_1m*4;
}


/*
 * PUBLIC
 * Get ephemeral port number.
 * return : ephemeral port number
 */
static ushort getEphemeralPort()
{
	enum{BEGIN_EPHM_PORT=1024};		/* եݡȤκǽֹ档 */

	static int gate=0;
	static int volatile port=BEGIN_EPHM_PORT;
	int pt;


	enter_spinlock(&gate);
	{
		pt=port++;
	}
	exit_spinlock(&gate);

	return pt;
}


/*
 * PBLIC
 * Send FIN ack.
 * parameters : socket
 */
static void sendFinAck(SOCKET *sc)
{
	sc->stat|=SOCK_CNCT_RECV_FIN;
	sc->acknum+=1;
	transSegment(sc,TCP_FLG_ACK,NULL,0,NULL,0,1);
}


/*
 * PUBLIC
 * Close connection.
 */
static void closeConnect(SOCKET *sc,TCP_HEADER *tcp)
{
	if(tcp->flag&TCP_FLG_FIN)												/* FINȤ */
	{
		if(sc->stat&SOCK_CNCT_RECV_FINACK)
		{
			if(swapInt32(tcp->acknum)==sc->seqnum)sendFinAck(sc);
		}
		else
		{
			if(swapInt32(tcp->acknum)==sc->seqnum)
			{
				sc->stat|=SOCK_CNCT_RECV_FINACK;
				sendFinAck(sc);
			}
			else if(swapInt32(tcp->acknum)==sc->seqnum-1)
				sendFinAck(sc);
		}
	}
	else if((tcp->flag&TCP_FLG_ACK)&&(swapInt32(tcp->acknum)==sc->seqnum))	/* ACKȤ */
		sc->stat|=SOCK_CNCT_RECV_FINACK;

	sc->waitTime=sys_time();
}


/*
 * PUBLIC
 * transmit fin segment.
 * parameters :
 */
static void sendFin(SOCKET *sc)
{
	/* FINȤ */
	transSegment(sc,TCP_FLG_FIN|TCP_FLG_ACK,NULL,0,NULL,0,1);
	sc->seqnum+=1;
	sc->stat|=SOCK_CNCT_TRANS_FIN;

	/* Хåե˻Ĥꤢꡣ */
	if(sc->buf!=NULL)closeConnect(sc,(TCP_HEADER*)sc->buf->data);
	sc->buf=NULL;

	sc->waitTime=sys_time();
	delCloseTimeout();				/* ॢȥåȤ롣 */
	addCloseSocket(sc);				/* åȥ󥯤³롣 */
}


/*
 * PUBLIC
 * ͥΩ
 * parameters : socket
 * return : 0 or error number
 */
static int connectTo(SOCKET *sc)
{
	int rest;
	int tcp_size;
	MSS mss;
	TCP_HEADER *recv_tcp;
	OPTIONS optst;


	/* ͥ󥯤³ */
	addWaitCnctLink(sc);

	/* إåץꡣ */
	mss.kind=TCP_KIND_MSS;
	mss.len= 4;
	mss.mss= swapWord(TCP_MSS_SIZE);

	/* SYNȤ */
	transSegment(sc,TCP_FLG_SYN,&mss,sizeof(mss),NULL,0,1);
	sc->seqnum+=1;

	/* Ȥμ */
	if((rest=waitReceive(sc,&recv_tcp,REPLY_TIMEOUT))<0)goto ERR;
	tcp_size=rest;
	if((swapInt32(recv_tcp->acknum)!=sc->seqnum)||((recv_tcp->flag&(TCP_FLG_SYN|TCP_FLG_ACK))!=(TCP_FLG_SYN|TCP_FLG_ACK)))
	{
		rest=recvBadSegment(sc,recv_tcp);
		goto ERR;
	}

	/* ץγǧ(MSSΤ߼) */
	optst.mss=TCP_MSS_SIZE;
	getTcpOptions(recv_tcp->option,tcp_size-sizeof(TCP_HEADER),&optst);
	sc->mss=optst.mss;

	/* ǧ */
	sc->acknum=swapInt32(recv_tcp->seqnum)+1;
	sc->stat|=SOCK_CNCT_ON;
	transSegment(sc,TCP_FLG_ACK,NULL,0,NULL,0,1);

	return 0;
ERR:
	/* ͥ󥯤 */
	delWaitLink(sc);

	return rest;
}


/*
 * PUBLIC
 * ͥαΩ
 * parameters : socket
 * return window size or error number
 */
static int acceptFrom(SOCKET *sc)
{
	int rest;
	MSS mss;
	TCP_HEADER *recv_tcp;


	/* ͥ󥯤³ */
	addWaitCnctLink(sc);

	/* إåץꡣ */
	mss.kind=TCP_KIND_MSS;
	mss.len= 4;
	mss.mss= swapWord(TCP_MSS_SIZE);

	/* SYNȤ */
	sc->acknum+=1;
	transSegment(sc,TCP_FLG_SYN|TCP_FLG_ACK,&mss,sizeof(mss),NULL,0,1);
	sc->seqnum+=1;

	/* Ȥμ */
	if((rest=waitReceive(sc,&recv_tcp,REPLY_TIMEOUT))<0)goto ERR;
	if((swapInt32(recv_tcp->acknum)!=sc->seqnum)||((recv_tcp->flag&TCP_FLG_ACK)==0))
	{
		rest=recvBadSegment(sc,recv_tcp);
		goto ERR;
	}
	sc->stat|=SOCK_CNCT_ON;

	return swapWord(recv_tcp->wndsize);
ERR:
	/* ͥ󥯤 */
	delWaitLink(sc);
	return rest;
}


/**************************************************************************
 *
 * Socket interface.
 *
 **************************************************************************/


enum{
	RECEIVE_TIMEOUT=5000,				/* ॢȥߥá */
};


/*
 * GLOBAL
 * åȤ򥳥ͥ󤫤鳫롣
 * parameters : socket
 */
void releaseSckFromConect(SOCKET *sc)
{
	if(sc->stat&SOCK_CNCT_ON)
	{
		if((sc->stat&SOCK_CNCT_TRANS_FIN)==0)
			sendFin(sc);
	}
	else if(sc->stat&SOCK_LINK_ON)
	{
		delWaitLink(sc);
		kfree(sc);
	}
	else kfree(sc);
}


/*
 * PRIVATE
 * Ȥγǧ
 * parameters : socket,TCP header
 * return : =1,ʤ=0,λ=-1
 */
static inline int isAck(SOCKET *sc,TCP_HEADER *tcp,uint32_t acknum)
{
	if((tcp->flag&TCP_FLG_ACK)&&(swapInt32(tcp->seqnum)==sc->acknum)&&(swapInt32(tcp->acknum)<=sc->seqnum))
	{
		/* λȤμ */
		if(tcp->flag&TCP_FLG_FIN)
		{
			sendFinAck(sc);
			return -1;
		}
		
		if(swapInt32(tcp->acknum)>=acknum)return 1;
	}
	return 0;
}

static int send(SOCKET *sc,const void *msg,size_t len,int flags,struct sockaddr *to)
{
	enum{
		RESEND_CNT=3,		/*  */
	};

	char *buf;
	int resend;				/*  */
	int rest;
	int window;				/* 襦ɥ */
	uint32_t acknum;		/* ֹ档 */
	uint32_t lastnum;		/* ֹ档 */
	uint32_t sendnum;		/* ǽֹ档 */
	TCP_HEADER *tcp;
	int l;


	/* γǧ */
	if((sc->stat&SOCK_CNCT_ON)==0) return -ENOTCONN;

	window=sc->window;
	acknum=sc->seqnum;
	buf=(char*)msg;
	resend=0;
	lastnum=acknum+len;
	for(;;)
	{
		/*  */
		sendnum=(lastnum>acknum+window)?acknum+window:lastnum;
		for(;sc->seqnum<sendnum;sc->seqnum+=l)
		{
			l=(sc->mss>(sendnum-sc->seqnum))?(sendnum-sc->seqnum):sc->mss;
			transSegment(sc,TCP_FLG_PSH|TCP_FLG_ACK,NULL,0,buf,l,0);
			buf+=l;
			
			/* γǧ */
			if(sc->buf!=NULL)
			{
				tcp=(TCP_HEADER*)sc->buf->data;
				sc->buf=NULL;
				if((rest=isAck(sc,tcp,acknum))==1)
				{
					acknum=swapInt32(tcp->acknum);
					window=swapWord(tcp->wndsize);
					sendnum=(lastnum>acknum+window)?acknum+window:lastnum;
				}
				else if(rest==-1)return len-(lastnum-(sc->seqnum+l));
			}
		}
		
		/* Ԥ */
		for(;;)
		{
			/* ԡ */
			if((rest=waitReceive(sc,&tcp,RECEIVE_TIMEOUT))<0)
			{
				if(rest==-EINTR)return -EINTR;
				if(++resend>RESEND_CNT)return rest;
				sc->seqnum=acknum;
				buf-=sendnum-acknum;
				break;				/*  */
			}

			if((rest=isAck(sc,tcp,acknum))==1)
			{
				acknum=swapInt32(tcp->acknum);
				window=swapWord(tcp->wndsize);
				resend=0;
				if((sendnum<lastnum)&&(acknum+window>sendnum))break;
				if(acknum==lastnum)return len;
			}
			else if(rest==-1)return len-(lastnum-sc->seqnum);
		}
	}
}


/*
 * return : copy data size or error number
 */
static int recv(SOCKET *sc,void *buf,size_t len,int flags,uint32_t *srcip)
{
	char *data;
	int tcp_size,data_size,all_size;
	TCP_HEADER *tcp;
	struct RESERVE{
		TCP_HEADER *tcp;
		int         size;
	}reserve={NULL};


	/* γǧ */
	if((sc->stat&SOCK_CNCT_ON)==0)return -ENOTCONN;
	
	if(sc->stat&SOCK_CNCT_RECV_FIN)return 0;	/* ǤFINȤƤ롣 */ 

	all_size=0;
	for(;;)
	{
		/*  */
		if((tcp_size=waitReceive(sc,&tcp,RECEIVE_TIMEOUT))<0)return tcp_size;

		/* γǧ */
RET:	if(swapInt32(tcp->acknum)==sc->seqnum)
		{
			if(tcp->flag&TCP_FLG_RST)return -ECONNREFUSED;

			if(swapInt32(tcp->seqnum)==sc->acknum)
			{
				/* λȤμ */
				if(tcp->flag&TCP_FLG_FIN)
				{
					sendFinAck(sc);
					return all_size;
				}
			}
			else if(swapInt32(tcp->seqnum)>sc->acknum)
			{
				/*
				 * ȤΥֹ椬礭ȤϡΥȤ夷ǽΤ
				 * αƤ
				 */
				reserve.tcp=tcp;
				reserve.size=tcp_size;
				continue;
			}
			else continue;
		}
		else return recvBadSegment(sc,tcp);

		/* 桼Хåե˥ԡ */
		data_size=tcp_size-(tcp->headlen>>4)*4;
		data=(char*)tcp+(tcp_size-data_size);
		all_size+=data_size;
		sc->acknum+=data_size;
		if(all_size>len)
		{
			data_size-=all_size-len;
			all_size=len;
			memcpy(buf,data,data_size);
			break;
		}
		memcpy(buf,data,data_size);
		(char*)buf+=data_size;

		/* αȤ硣 */
		if(reserve.tcp!=NULL)
		{
			tcp=reserve.tcp;
			tcp_size=reserve.size;
			reserve.tcp=NULL;
			goto RET;
		}

		if(sc->buf==NULL)break;
	}

	/* Ȥ */
	transSegment(sc,TCP_FLG_ACK,NULL,0,NULL,0,1);

	*srcip=sc->dstip;

	return all_size;
}


static int shutdown(SOCKET *sc,int flag)
{
	if((sc->stat&SOCK_CNCT_ON)==0)return -ENOTCONN;
	if((sc->stat&SOCK_CNCT_TRANS_FIN)==0)
		sendFin(sc);

	return 0;
}


static int connect(SOCKET *sc)
{
	if(sc->stat&SOCK_CNCT_ON)return -EISCONN;

	/* Set connect structure. */
	sc->next=sc->prev=sc;
	sc->stat=SOCK_LINK_ON;
	sc->waitCnt=0;
	sc->srcport=swapWord(getEphemeralPort());
	sc->seqnum=getSeqNumber();
	sc->acknum=0;

	/* ͥγΩ */
	return connectTo(sc);
}


static int listen(SOCKET *sc)
{
	SOCKET *s;


	if(sc->stat&SOCK_LISTEN)return -EADDRINUSE;
	for(s=waitLstnSc.next;s!=&waitLstnSc;s=s->next)
		if(s->srcport==sc->srcport)return -EADDRINUSE;

	sc->next=sc->prev=sc;
	sc->stat=SOCK_LINK_ON;
	sc->waitCnt=0;
	addWaitLstnLink(sc);
	sc->stat|=SOCK_LISTEN;

	return 0;
}


static int accept(SOCKET *sc,SOCKET *newsc,uint32_t *srcip)
{
	int tcp_size;
	int rest;
	TCP_HEADER *recv_tcp;
	OPTIONS optst;


	newsc->stat=0;

	for(;;)
	{
		/* ³׵Ԥ */
		if((tcp_size=waitReceive(sc,&recv_tcp,-1))<0)
		{
			if(tcp_size==-EINTR)return -EINTR;
			continue;
		}

		sc->dstport=recv_tcp->srcport;

		/* ³׵᥻Ȥγǧ */
		if(((recv_tcp->flag&TCP_FLG_SYN)==0)||(recv_tcp->acknum!=0))
			recvBadSegment(sc,recv_tcp);
		else break;
	}

	/*
	 * åȤꡣ
	 * sc->dstipsearchSocketLink()Ƥ롣
	 */
	memcpy(newsc,sc,sizeof(SOCKET));
	newsc->acknum=swapInt32(recv_tcp->seqnum);
	newsc->seqnum=getSeqNumber();
	newsc->next=newsc->prev=newsc;
	newsc->stat=SOCK_LINK_ON;
	newsc->waitCnt=0;

	/* ץγǧ(MSSΤ߼) */
	optst.mss=TCP_MSS_SIZE;
	getTcpOptions(recv_tcp->option,tcp_size-sizeof(TCP_HEADER),&optst);
	newsc->mss=optst.mss;

	/* ͥγΩ */
	if((rest=acceptFrom(newsc))<0)
		return rest;

	newsc->window=rest;
	*srcip=newsc->dstip;

	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


static SOCKET_INFO sockInfo={send,recv,connect,shutdown,listen,accept};


/*
 * GLOBAL
 * Init UDP.
 */
int initTcp()
{
	registSocket(&sockInfo,IPPROTO_TCP);
	waitCnctSc.next=waitCnctSc.prev=&waitCnctSc;
	waitLstnSc.next=waitLstnSc.prev=&waitLstnSc;

	return 0;
}

/***************************************************************************/
void test_tcp()
{
	printk("waitNext=%x\n",*(uint*)0x16be64);
}
/****************************************************************************/
