/*
 * ip.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Internet Protocol.
 */


#include<types.h>
#include<lib.h>
#include<lock.h>
#include<net/net.h>
#include<net/ether.h>
#include<net/arp.h>
#include<net/icmp.h>
#include<net/udp.h>
#include<net/tcp.h>
#include<net/ip.h>


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


enum{
	IP_HEAD_VERSION=4<<4,

	IP_HEAD_FRAG_ON= 0x2000,	/* ե饰ȥǡե饰 */
	IP_HEAD_FRAG_NOT=0x4000,	/* ե饰Բĥե饰 */
};


typedef struct{
	int    lock;
	ushort id;
}HEAD_ID;


#define GET_ID(a)	enter_spinlock(&headId.lock);\
			 		a=headId.id++;\
					exit_spinlock(&headId.lock)


static HEAD_ID headId;
/************************************************************************************************
static void viewHead(IP_HEADER *head)
{
	printk("TRANS IP version=%x,head length=%x,TOS=%x,total length=%x,id=%x,fragment=%x\n"
	       "TTL=%x,protocol=%x,sourceIP=%x,destIP=%x\n",
	       head->verhead>>4,head->verhead&0xf,head->tos,swapWord(head->len),head->id,head->frag,
	       head->ttl,head->prot,head->srcip,head->dstip);
}
*************************************************************************************************/
/*
 * GLOBAL
 * Transfer IP datagram.
 * parameters : TRANS_BUF_INFO address,destination IP,TOS,ե饰ȲԲĥե饰
 * return : 0 or error number
 */
int transIp(TRANS_BUF_INFO *tbi,uint dstip,uchar tos,int flag)
{
	char dstmac[6];
	uint transip;
	int num;
	int rest;
	IP_HEADER head;
	int max,total,trans;


	/* Get device number. */
	num=searchDevnum(dstip,&transip);

	/*  MAC */
	if((rest=getMac(num,transip,dstmac))<0)return rest;

	/* Set IP head. */
	head.verhead=IP_HEAD_VERSION|(sizeof(IP_HEADER)/4);
	head.tos=tos;
	GET_ID(head.id);
	head.ttl=255;
	head.prot=tbi->ipType;
	head.srcip=ethDev[num].ip;
	head.dstip=dstip;
	head.chksum=0;

	tbi->type=DIX_TYPE_IP;
	tbi->data[0]=(char*)&head;
	tbi->size[0]=sizeof(IP_HEADER);			/* IP header size. */
	max=ethDev[num].mtu-sizeof(IP_HEADER);	/* ǡ */
	total=tbi->size[1]+tbi->size[2];		/* ǡȡ륵 */

	if(total<=max)
	{
		head.len=swapWord(tbi->size[0]+total);
		head.frag=swapWord(flag<<14);
		head.chksum=calcSum((uint*)&head,tbi->size[0]);
/**********************************************
viewHead(&head);
**********************************************/
		ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);
	}
	else
	{
		head.len=swapWord(tbi->size[0]+max);
		head.frag=swapWord(IP_HEAD_FRAG_ON);
		tbi->size[2]=max-tbi->size[1];
		head.chksum=calcSum((uint*)&head,tbi->size[0]);
/**********************************************
viewHead(&head);
**********************************************/
		ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);

		trans=max;						/* ѥ */
		tbi->data[2]+=max-tbi->size[1];
		tbi->size[1]=0;

		for(;;)
		{
			head.chksum=0;

			if(total-trans<=max)
			{
				head.len=swapWord(tbi->size[0]+total-trans);
				head.frag=swapWord(trans);
				GET_ID(head.id);
				head.chksum=calcSum((uint*)&head,tbi->size[0]);
				tbi->size[2]=total-trans;
/**********************************************
viewHead(&head);
**********************************************/
				ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);
				break;
			}
			else
			{
				head.len=swapWord(tbi->size[0]+max);
				head.frag=swapWord(trans|IP_HEAD_FRAG_ON);
				GET_ID(head.id);
				head.chksum=calcSum((uint*)&head,tbi->size[0]);
				tbi->size[2]=max;
/**********************************************
viewHead(&head);
**********************************************/
				ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);
			}

			trans+=max;
			tbi->data[2]+=max;
		}
	}

	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/*
 * GROBAL
 * Receive IP datagram.
 * parameters : IP header
 * return : 0 or task switch=1
 */
int receiveIp(IP_HEADER *head)
{
/*****************************************************************************************
	printk("IP version=%x,head length=%x,TOS=%x,total length=%x,id=%x,fragment=%x\n"
	       "TTL=%x,protocol=%x,sourceIP=%x,destIP=%x\n",
	       head->verhead>>4,head->verhead&0xf,head->tos,swapWord(head->len),head->id,head->frag,
	       head->ttl,head->prot,head->srcip,head->dstip);
*******************************************************************************************/
	/* åγǧ */
	if(calcSum((uint*)head,(head->verhead&0xf)*4))return 0;

	/* ̥ץȥϤ */
	switch(head->prot)
	{
		case IPPROTO_TCP:
			return receiveTcp(head);
		case IPPROTO_UDP:
			return receiveUdp(head);
		case IPPROTO_ICMP:
			return receiveIcmp(head);
	}

	return 0;
}
