/*
 * mp.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * mp.c ѥإåե
 */


#ifndef mp_h
#define mp_h


#include"types.h"
#include"pci.h"


#ifndef ASM_FILE


enum{
	/* LOCAL APIC register */
	LOCAL_APIC_ID=	0x20/sizeof(int),
	LOCAL_APIC_TPR=	0x80/sizeof(int),
	LOCAL_APIC_EOI=	0xb0/sizeof(int),
	LOCAL_APIC_LDR=	0xd0/sizeof(int),
	LOCAL_APIC_DFR=	0xe0/sizeof(int),
	LOCAL_APIC_SVR=	0xf0/sizeof(int),
	LOCAL_APIC_ISR1=0x100/sizeof(int),
	LOCAL_APIC_ISR2=0x110/sizeof(int),
	LOCAL_APIC_TMR1=0x180/sizeof(int),
	LOCAL_APIC_TMR2=0x190/sizeof(int),
	LOCAL_APIC_IRR1=0x200/sizeof(int),
	LOCAL_APIC_IRR2=0x200/sizeof(int),
	LOCAL_APIC_ICR1=0x300/sizeof(int),
	LOCAL_APIC_ICR2=0x310/sizeof(int),
	LOCAL_APIC_TIME=0x320/sizeof(int),
	LOCAL_APIC_LNT0=0x350/sizeof(int),
	LOCAL_APIC_LNT1=0x360/sizeof(int),
	LOCAL_APIC_ICNT=0x380/sizeof(int),
	LOCAL_APIC_CCNT=0x390/sizeof(int),
	LOCAL_APIC_TDVC=0x3e0/sizeof(int),

	/* IOAPIC register */
	IO_APIC_ID=		0x0,
	IO_APIC_VER=	0x1,
	IO_APIC_ARBT=	0x2,
	IO_APIC_LRT0=	0x10,
	IO_APIC_HRT0=	0x11,
	IO_APIC_LRT1=	0x12,
	IO_APIC_HRT1=	0x13,
	IO_APIC_LRT2=	0x14,
	IO_APIC_HRT2=	0x15,
	IO_APIC_LRT3=	0x16,
	IO_APIC_HRT3=	0x17,
	IO_APIC_LRT4=	0x18,
	IO_APIC_HRT4=	0x19,
	IO_APIC_LRT5=	0x1a,
	IO_APIC_HRT5=	0x1b,
	IO_APIC_LRT6=	0x1c,
	IO_APIC_HRT6=	0x1d,
	IO_APIC_LRT7=	0x1e,
	IO_APIC_HRT7=	0x1f,
	IO_APIC_LRT8=	0x20,
	IO_APIC_HRT8=	0x21,
	IO_APIC_LRT9=	0x22,
	IO_APIC_HRT9=	0x23,
	IO_APIC_LRT10=	0x24,
	IO_APIC_HRT10=	0x25,
	IO_APIC_LRT11=	0x26,
	IO_APIC_HRT11=	0x27,
	IO_APIC_LRT12=	0x28,
	IO_APIC_HRT12=	0x29,
	IO_APIC_LRT13=	0x2a,
	IO_APIC_HRT13=	0x2b,
	IO_APIC_LRT14=	0x2c,
	IO_APIC_HRT14=	0x2d,
	IO_APIC_LRT15=	0x2e,
	IO_APIC_HRT15=	0x2f,
	IO_APIC_LRT16=	0x30,
	IO_APIC_HRT16=	0x31,
	IO_APIC_LRT17=	0x32,
	IO_APIC_HRT17=	0x33,
	IO_APIC_LRT18=	0x34,
	IO_APIC_HRT18=	0x35,
	IO_APIC_LRT19=	0x36,
	IO_APIC_HRT19=	0x37,

	/* ߥ٥ */
	APIC_TIMER_VECT=	0x30,
	IRQ0_VECT=			0x2f,
	IRQ1_VECT=			0x2e,
	IRQ3_VECT=			0x2c,
	IRQ4_VECT=			0x2b,
	IRQ5_VECT=			0x2a,
	IRQ6_VECT=			0x29,
	IRQ7_VECT=			0x28,
	IRQ8_VECT=			0x27,
	IRQ9_VECT=			0x26,
	IRQ10_VECT=			0x25,
	IRQ11_VECT=			0x24,
	IRQ12_VECT=			0x23,
	IRQ13_VECT=			0x22,
	IRQ14_VECT=			0x21,
	IRQ15_VECT=			0x20,
	FLASH_PAGEDIR_VECT=	0x31,
};


extern uint MFPS_addres;
extern uint volatile *local_apic;
extern uint volatile *io_apic_regsel;
extern uint volatile *io_apic_win;
extern uint ioapic_hrt[];
extern uchar ioapic_intr_vect[];


/*
 * Read IOAPIC
 *  : ɥ쥹
 * ֤ : ɤ߹
 */
extern inline uint read_ioapic(uint addr)
{
	*io_apic_regsel=addr;
	return *io_apic_win;
}

/*
 * Write IOAPIC
 *  : ɥ쥹񤭹
 */
extern inline void write_ioapic(uint addr,uint value)
{
	*io_apic_regsel=addr;
	*io_apic_win=value;
}

/*
 * IOAPICγߤʪ⡼ɤˤ롣
 * parameters : IRQ
 */
extern inline void set_physical_intr(int irq)
{
	write_ioapic(ioapic_hrt[irq],0|ioapic_intr_vect[irq]);
}

/*
 * IOAPICγߤ⡼ɤˤ롣
 * parameters : IRQ
 */
extern inline void set_logical_intr(int irq)
{
	write_ioapic(ioapic_hrt[irq],0x900|ioapic_intr_vect[irq]);
}

/*
 * IOAPICγcpuꤹ롣
 * parameters : IRQ,cpu number
 */
extern inline void set_intr_cpu(int irq,int cpu)
{
	write_ioapic(ioapic_hrt[irq],cpu<<24);
}

/*
 * IOAPICγcpuǤդˤ롣
 * parameters : IRQ,cpu number
 */
extern inline void set_intr_anony(int irq)
{
	write_ioapic(ioapic_hrt[irq],0xff000000);
}


extern int init_mp();
extern void issue_interrupt_to_cpu(int,int);
extern int SetPciIrqInIoapic(PCI_INFO*,int);
extern void releasePciIrqIoapicMask(PCI_INFO*);


#endif


#endif
