# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

package Lovers::LoveLetter;
use strict;

use MT::Object;
use base qw( MT::Object );

__PACKAGE__->install_properties({
    column_defs => {
        'id' => 'integer not null auto_increment',

        'love_letter_id' => 'string(255)',
        'entry_id' => 'integer not null',
        'template_id' => 'integer not null',
        'author_id' => 'integer not null',

        'from' => 'string(255)',
        'to' => 'string(255)',

        'sent_on' => 'datetime',
    },
    audit => 1,
    indexes => {
        love_letter_id => 1,
    },
    default => {
        sent_on => '00000000000000',
    },
    datasource => 'love_letter',
    primary_key => 'id',
});

sub mail_param {
    my $self = shift;
    my $app = MT->instance;
    my $param = $self->column_values;
    if (! $param->{'from'}) {
        my $author_class = $app->model('author');
        my $author = $author_class->load($param->{'author_id'});
        $param->{'from'} =
            $author->nickname
            . ' <' . $author->email . '>';
    }

    $param;
}

1;
