# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

package Lovers::App;
use strict;

sub _hdlr_popular_with {
    my($ctx, $args, $cond) = @_;
	my $app = MT->instance;
	my $plugin = MT->component('Lovers');

    my $res = '';
    my $builder = $ctx->stash('builder');
    my $tokens = $ctx->stash('tokens');

    defined($res = $builder->build($ctx, $tokens, $cond))
        or return $ctx->error( $builder->errstr );

	$app->session(
        'lovers_message',
        $res || $plugin->translate('My heart begins to throb...')
    );
	$app->session('lovers_type', $args->{'type'} || '');
}

sub source_rebuilding {
	my ($cb, $app, $tmpl) = @_;
	my $plugin = $app->component('Lovers');
	my $blog_id = $app->param('blog_id');
	my ($old, $new);

	if (my $text = $app->param('text')) {
		if ($text =~ m/<mt:?mote([^>]*)>(.*)<\/mt:?mote>/is) {
			$app->session('lovers_message', $2);

			my $args = $1;
			$args =~ m/type\s*=\s*"?(\w+)/is;
			$app->session('lovers_type', $1 || '');
		}
	}

	my $msg = $app->session('lovers_message');
	my $type = $app->session('lovers_type') || 'heat';

	if (! $msg) {
		return;
	}

	my $uri = $app->static_path . 'plugins/Lovers/icon/' . $type . '.gif';

	if ($type eq 'persistent') {
		$new = <<__EOF__;
<style type="text/css">
div.msg-publishing {
    background-color:#FFFFFF;
	background-image: none;
}
</style>
__EOF__
	}
	else {
		$new = <<__EOF__;
<style type="text/css">
div.msg-publishing {
    background-color:#FFFFFF;
    background-image:url($uri);
}
</style>
__EOF__
	}
	$old = '<mt:if name="is_one_index">';
	$$tmpl =~ s/($old)/$new\n$1/;

    $old = '\s+<__trans phrase="Publishing.*';
    $new = $msg;

	if ($type eq 'persistent') {
		require MT::Util;
		$new =
			'<script type="text/javascript">' .
			join('', map({
				$_ =~ s/^\s*|\s*$//gs;
				if ($_) {
					"alert('" . MT::Util::encode_js($_) . "');\n";
				}
				else {
					'';
				}
			} split(/\n/, $new))) .
			'</script>';
	}
	else {
		$new =~ s/^\s*|\s*$//gs;
		$new =~ s/\r?\n/<br>/g;
		$new =~ s/([\w._-~]+@[\w._-~]+)/<a href="$1">$1<\/a>/;
	}

	$$tmpl =~ s/($old)/$new/g;
}

sub _hdlr_love_letter_response {
    my($ctx, $args, $cond) = @_;
    my $width = $args->{'width'} ? ' width: ' . $args->{'width'} : '';
    my $height = $args->{'height'} ? ' height: ' . $args->{'height'} : '';
    my $style = $args->{'style'} || '';

    <<__EOF__;
<textarea name="response" style="$width $height $style; display: none;">
</textarea>
__EOF__
}

sub _hdlr_love_letter_ok {
    my($ctx, $args, $cond) = @_;

    <<__EOF__;
<input type="submit" name="ok" value="@{[ $args->{'value'} || 'OK' ]}" style="display: none;"/>
__EOF__
}

sub _hdlr_love_letter_cancel {
    my($ctx, $args, $cond) = @_;

    <<__EOF__;
<input type="submit" name="cancel" value="@{[ $args->{'value'} || 'Cancel' ]}" style="display: none;" />
__EOF__
}

sub _hdlr_love_letter {
    my($ctx, $args, $cond) = @_;
    my $tmpl = $ctx->stash('template');
    my $app = MT->instance;
	my $plugin = MT->component('Lovers');
	my $password = $args->{'password'} || '';

    my $res = '';
    my $builder = $ctx->stash('builder');
    my $tokens = $ctx->stash('tokens');

    defined($res = $builder->build($ctx, $tokens, $cond))
        or return $ctx->error( $builder->errstr );

    my $entry = $ctx->stash('entry');
    my $entry_id = $entry ? $entry->id : 0;
    my $love_letter_id = $args->{'id'} || 0;
    my $template_id = $tmpl ? $tmpl->id : 0;
    my $ll_class = $app->model('love_letter');
	my $obj = $ll_class->load({
		entry_id => $entry_id,
		template_id => $template_id,
		love_letter_id => $love_letter_id,
	});
	if (! $obj) {
		$obj = $ll_class->new;
	}

	$obj->set_values({
		entry_id => $entry_id,
		template_id => $template_id,
		love_letter_id => $love_letter_id,
		author_id => $entry ? $entry->author_id : $tmpl->modified_by,
		from => $args->{'from'} || '',
		to => $args->{'to'} || '',
	});

	if ((! $obj->sent_on || $obj->sent_on =~ m/^0/) && $obj->to) {
		my $param = $obj->mail_param;
		$param->{'permalink'} =
			$entry ? $entry->permalink : $tmpl->published_url;
		if ($password) {
			$param->{'permalink'} =~ s/#.*//;
			$param->{'permalink'} .= '#password'
		}
		my $tmpl = $plugin->load_tmpl('mail_love_letter.tmpl');
		my $body = MT->translate_templatized(
			$tmpl->output($param)
		);
		my $cfg = $app->config;

		my %head = (
			id => 'love_letter',
			To => $param->{'to'},
			From => $param->{'from'},
			Subject => $plugin->translate('You got love letter.'),
		);
		my $charset = $cfg->MailEncoding || $cfg->PublishCharset;
		$head{'Content-Type'} = qq(text/plain; charset="$charset");

		require MT::Mail;
		MT::Mail->send( \%head, $body )
			or return $app->error( MT::Mail->errstr() );

		my @lt = reverse((localtime)[0 .. 5]);
		$lt[0] += 1900;
		$lt[1] += 1;
		$obj->sent_on(sprintf('%04d%02d%02d%02d%02d%02d', @lt));
	}

	$obj->save;

	if ($password) {
		require Crypt::CBC;
		require MIME::Base64;
		require Encode;

		my $content_header = 'love_letter:';

		eval{
			my $dec = Encode::decode('utf-8', $password);
			$password = $dec;
		};
		$password = join('', map(ord($_), split(//, $password)));
		$password .= '0' x 32;
		$password = substr($password, 0, 32);

		my $cbc = Crypt::CBC->new({
			cipher => 'Crypt::Camellia_PP',
			key => pack('H*', $password),
			iv  => pack('H*', '00000000000000000000000000000000'),
			literal_key => 1,
			header => 'none',
			padding => 'standard',

			keysize => 16,
		});
		
		$res = MIME::Base64::encode_base64($cbc->encrypt(
			$content_header . $res
		));

		$res = <<__EOF__;
<script type="text/javascript" src="@{[ $app->static_path ]}plugins/Lovers/js/CryptoCipherCamellia.js"></script>
<script type="text/javascript">
function love_letter_decrypt_$love_letter_id(k) {
	var j = jQuery;

	if (! k) {
		k = '';
	}

	k = j.map(k.split(''), function(v, k) {
		return v.charCodeAt(0);
	}).join('');
	k += '00000000000000000000000000000000';
	k = k.substr(0, 32);

	var iv = '00000000000000000000000000000000';
	var cipher = new CryptoCipherCamellia();
	try {
		var cbc = new CryptoModeCBC(cipher,
									CryptoUtil.arrayFromHex(k),
									CryptoUtil.arrayFromHex(iv));
		var res = cbc.decrypt(CryptoUtil.arrayFromBase64(
			j.trim(j('#love_letter_encrypted_$love_letter_id').text())
		));
		var contents = CryptoUtil.stringFromArray(res);
		var match = contents.match(/^$content_header/);
		if (match) {
			j('#love_letter_encrypted_$love_letter_id').html(
				contents.replace(/^$content_header/, '')
			).show();
			setTimeout(love_letter_init_form_$love_letter_id, 0);
			return true;
		}
		else {
			alert('@{[ $plugin->translate('wrong password') ]}');
		}
	}
	catch (e) {
		alert(e);
	} 

	return false;
}

jQuery(function() {
	var j = jQuery;
	var k = '';

	if (document.location.hash.match(/password/i)) {
		/*
		k = window.prompt('password');
		love_letter_decrypt_$love_letter_id(k);
		*/
		var prompt = j('#love_letter_prompt_$love_letter_id');
		var pass = prompt.find('input[name="password"]');
		prompt.show();
		prompt.find('input[name="password_input"]').focus(function() {
			j(this).hide();
			pass.show().get(0).focus();
		});
		prompt.find('input[type="submit"]').click(function() {
			if (love_letter_decrypt_$love_letter_id(pass.val())) {
				prompt.hide();
			}
			return false;
		});
	}
});
</script>
<div id="love_letter_prompt_$love_letter_id" style="display:none">
<input name="password_input" value="@{[ $plugin->translate('Please input password.') ]}" style="color: #999"/>
<input type="password" name="password" value="" style="display: none;"/>
<br />
<input type="submit" value="@{[ $plugin->translate('show love letter') ]}" />
</div>
<div id="love_letter_encrypted_$love_letter_id" style="display:none">$res</div>
__EOF__
		;
	}

    $res = <<__EOF__;
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.1/jquery.min.js"></script>
<script type="text/javascript">
jQuery.noConflict();
function love_letter_init_form_$love_letter_id() {
	var j = jQuery;
	var speed = 'normal';

	var container = j('#love_letter_container_$love_letter_id');
	var loading = j('#love_letter_loading_$love_letter_id');
	if (loading.length == 0) {
		container.append(
			'<div id="love_letter_loading_$love_letter_id" style="background: white url(\\'@{[ $app->static_path ]}plugins/Lovers/img/loading.gif\\') center center no-repeat; display: none; height: ' + container.height() + 'px; width: ' + container.width() + 'px;"></div>'
		);
		loading = j('#love_letter_loading_$love_letter_id');
	}
	function show_loading() {
		loading.width(container.width());
		loading.height(container.height());
		loading.fadeIn();
	}

	var form = j('#love_letter_form_$love_letter_id');

	function send(type, callback) {
		var param = form.serializeArray();
		param.push({
			'name': type,
			'value': 1
		});
		j.post(form.attr('action'), param, function() {
			var args = arguments;
			setTimeout(function() {
				callback.apply(null, args);
			}, 2000);
		});
	}

	form.find('textarea[name="response"]').show();

	form.find('input[name="ok"]').show().click(function() {
		send('ok', function(data) {
			var message = data.match(/<message>(.*?)<\\/message/i);
			if (! message) {
				alert('@{[ $plugin->translate('unknown error') ]}');
			}
			else if (message[1].match(/^\\s+ok\\s+\$/i)) {
				alert(message[1]);
			}
			else {
				loading.fadeOut(
					speed,
					function() {
						form.find('[name="if_love_letter_ok"]').show();
					}
				);
			}
		});

		form.find(
			'textarea[name="response"], input[name="ok"], input[name="cancel"]'
		).fadeOut(speed, show_loading);

		return false;
	});

	form.find('input[name="cancel"]').show().click(function() {
		send('cancel', function(data) {
			var message = data.match(/<message>(.*?)<\\/message/i);
			if (! message) {
				alert('@{[ $plugin->translate('Unknown error.') ]}');
			}
			else if (message[1].match(/^\\s+ok\\s+\$/i)) {
				alert(message[1]);
			}
			else {
				loading.fadeOut(
					speed,
					function() {
						form.find('[name="if_love_letter_cancel"]').show();
					}
				);
			}
		});

		form.find(
			'textarea[name="response"], input[name="ok"], input[name="cancel"]'
		).fadeOut(speed, show_loading);

		return false;
	});
}

jQuery(function() {
	love_letter_init_form_$love_letter_id();
});
</script>
<form
    class="@{[ $args->{'class'} || 'love_letter' ]}"
    action="@{[ $app->base . $app->mt_uri ]}"
    method="post"
	id="love_letter_form_$love_letter_id"
>
<input type="hidden" name="__mode" value="love_letter" />
<input type="hidden" name="entry_id" value="$entry_id" /> <input type="hidden" name="template_id" value="$template_id" />
<input type="hidden" name="love_letter_id" value="$love_letter_id" />
<div id="love_letter_container_$love_letter_id">
$res
</form>
__EOF__

    $res;
}

sub _hdlr_if_love_letter_ok {
    my($ctx, $args, $cond) = @_;
    my $tmpl = $ctx->stash('template');
    my $app = MT->instance;

    my $res = '';
    my $builder = $ctx->stash('builder');
    my $tokens = $ctx->stash('tokens');

    defined($res = $builder->build($ctx, $tokens, $cond))
        or return $ctx->error( $builder->errstr );

    $res = <<__EOF__;
<div name="if_love_letter_ok" style="display: none">
$res
</div>
__EOF__

    $res;
}

sub _hdlr_if_love_letter_cancel {
    my($ctx, $args, $cond) = @_;
    my $tmpl = $ctx->stash('template');
    my $app = MT->instance;

    my $res = '';
    my $builder = $ctx->stash('builder');
    my $tokens = $ctx->stash('tokens');

    defined($res = $builder->build($ctx, $tokens, $cond))
        or return $ctx->error( $builder->errstr );

    $res = <<__EOF__;
<div name="if_love_letter_cancel" style="display: none">
$res
</div>
__EOF__

    $res;
}

sub app_love_letter {
	my ($app) = @_;

	my $plugin = MT->component('Lovers');

    my $ll_class = $app->model('love_letter');
	my $ll = $ll_class->load({
		entry_id => $app->param('entry_id') || 0,
		template_id => $app->param('template_id') || 0,
		love_letter_id => $app->param('love_letter_id') || 0,
	});

	if (! $ll) {
		return <<__MSG__;
<message>@{[
	$plugin->translate('unknown love letter')
]}</message>
__MSG__
	}

	if (! $app->param('ok') && ! $app->param('cancel')) {
		return <<__MSG__;
<message>@{[
	$plugin->translate('vague response')
]}</message>
__MSG__
	}

	my $param = $ll->mail_param;
	$param->{'message'} = $app->param('response') || '';
	$param->{'ok'} = $app->param('ok') ? 1 : 0;

	my $tmpl = $plugin->load_tmpl('mail_response.tmpl');
	my $body = MT->translate_templatized(
		$tmpl->output($param)
	);
	my $cfg = $app->config;

	my %head = (
		id => 'love_letter',
		To => $param->{'from'},
		From => $param->{'to'} || $param->{'from'},
		Subject => $plugin->translate('You got response of love letter.'),
	);
	my $charset = $cfg->MailEncoding || $cfg->PublishCharset;
	$head{'Content-Type'} = qq(text/plain; charset="$charset");

	require MT::Mail;
	MT::Mail->send( \%head, $body )
		or return $app->error( MT::Mail->errstr() );

	return <<__MSG__;
<message>ok</message>
__MSG__

}

sub post_build {
	my ($cb) = @_;

	my $app = MT->instance;
	my $msg = $app->session('lovers_message', '');
	my $type = $app->session('lovers_type', '');
}

1;
