/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class CRLFOutputStream
extends FilterOutputStream {
    static final String US_ASCII = "US-ASCII";
    public static final int CR = 13;
    public static final int LF = 10;
    public static final byte[] CRLF = new byte[]{13, 10};
    protected int last = -1;

    public CRLFOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int ch) throws IOException {
        if (ch == 13) {
            this.out.write(CRLF);
        } else if (ch == 10) {
            if (this.last != 13) {
                this.out.write(CRLF);
            }
        } else {
            this.out.write(ch);
        }
        this.last = ch;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int d = off;
        len += off;
        for (int i = off; i < len; ++i) {
            switch (b[i]) {
                case 13: {
                    this.out.write(b, d, i - d);
                    this.out.write(CRLF, 0, 2);
                    d = i + 1;
                    break;
                }
                case 10: {
                    if (this.last != 13) {
                        this.out.write(b, d, i - d);
                        this.out.write(CRLF, 0, 2);
                    }
                    d = i + 1;
                }
            }
            this.last = b[i];
        }
        if (len - d > 0) {
            this.out.write(b, d, len - d);
        }
    }

    public void write(String text) throws IOException {
        try {
            byte[] bytes = text.getBytes(US_ASCII);
            this.write(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("The US-ASCII encoding is not supported on this system");
        }
    }

    public void writeln() throws IOException {
        this.out.write(CRLF, 0, 2);
    }
}

